/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.BlobOutputStream;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStatement;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;

public class Blob
extends com.teradata.jdbc.interfaces.Blob {
    private TDSession session;
    protected short lobLocatorType = (short)408;
    private InputStream outStream;
    private boolean atEof = false;

    public Blob() {
        this.amountRead = 0L;
    }

    public Blob(InputStream inputStream) {
        this();
        this.outStream = inputStream;
    }

    public Blob(byte[] byArray) {
        this();
        this.outStream = new ByteArrayInputStream(byArray);
    }

    public Blob(Blob blob) throws SQLException {
        this.session = blob.session;
        this.setLength(blob.length());
        this.locator = blob.locator;
        this.lobLocatorType = blob.lobLocatorType;
    }

    public InputStream getBinaryStream() throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        return new LobStream(this.locator, this.length(), this.session, this.lobLocatorType);
    }

    public byte[] getBytes(long l, int n) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        if (l < 1L || n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "getBytes");
        }
        if (l + (long)n > this.length() + 1L) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "getBytes");
        }
        if (n == 0) {
            return new byte[0];
        }
        LobStream lobStream = new LobStream(this.locator, this.length(), this.session, this.lobLocatorType);
        return lobStream.getBytes(l, n);
    }

    public long position(byte[] byArray, long l) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "Blob", "position");
    }

    public long position(java.sql.Blob blob, long l) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "Blob", "position");
    }

    public int write(TDPacketStream tDPacketStream, int n, String string) throws IOException, SQLException {
        n = (int)(this.length() < (long)n ? this.length() : (long)n);
        int n2 = tDPacketStream.putInputStream(this.outStream, n);
        this.amountRead += (long)n2;
        if (this.amountRead == this.length() || n2 == 0) {
            this.atEof = true;
        }
        return n2;
    }

    public boolean eof() throws IOException {
        return this.atEof;
    }

    public void setOutStream(InputStream inputStream) {
        this.outStream = inputStream;
    }

    public void setTDSession(TDSession tDSession) {
        this.session = tDSession;
    }

    public TDSession getTDSession() {
        return this.session;
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.setBinaryStream");
        }
        String string = this.initWritableLobs(this.session, "Blob.setBinaryStream");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.setBinaryStream");
        }
        String string2 = "UPDATE " + string + " SET bval=substring(? FROM 0 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType);
        lobStatement.close();
        this.setStaleLocator(true);
        this.close();
        return new BufferedOutputStream(new BlobOutputStream(this), 64000);
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.truncate");
        }
        String string = this.initWritableLobs(this.session, "Blob.truncate");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.truncate");
        }
        String string2 = "UPDATE " + string + " SET bval=substring( ? FROM 1 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType);
        lobStatement.close();
        this.setStaleLocator(true);
        this.close();
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Blob.setBytes");
        }
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        if (byArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Blob.setBytes");
        }
        if (n < 0 || n2 < 0 || l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Blob.setBytes");
        }
        if (n + n2 > byArray.length) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "Blob.setBytes");
        }
        String string = this.initWritableLobs(this.session, "setBytes");
        byte[] byArray2 = byArray;
        if (n2 != byArray.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
        }
        if (byArray2.length > 64000) {
            throw ErrorFactory.makeDriverJDBCException("TJ515", "Blob.setBytes", String.valueOf(byArray.length));
        }
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.setBytes");
        }
        String string2 = "UPDATE " + string + " SET bval = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? || " + "SUBSTRING(? FROM " + (l + (long)n2) + " FOR " + this.length() + ") " + "WHERE id=" + this.getWritableLobId();
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType, byArray2, 689);
        lobStatement.close();
        this.setStaleLocator(true);
        this.close();
        return n2;
    }

    public void writeStream(long l, InputStream inputStream, long l2) throws SQLException {
        String string = this.initWritableLobs(this.session, "Blob.writeStream");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Blob.writeStream");
        }
        String string2 = "UPDATE " + string + " SET bval = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? WHERE id=" + this.getWritableLobId();
        Blob blob = new Blob(inputStream);
        blob.setLength(l2);
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType, blob, this.session.getLobToken(), 405);
        lobStatement.close();
        this.close();
        this.setStaleLocator(true);
    }

    public long length() throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        return super.length();
    }

    public long dataLeft() {
        return 0L;
    }

    public InputStream getInBinaryStream() {
        return null;
    }

    public void setDataLeft(long l) {
    }

    protected void setInBinaryStream(InputStream inputStream) {
    }

    public void finalize() {
        try {
            if (this.session != null && !this.session.isClosed() && this.getWritableLobId() > 0) {
                String string = "DELETE FROM " + this.session.getLobTempTable() + " WHERE id = " + this.getWritableLobId();
                Statement statement = this.session.createStatement(1003, 1007);
                statement.setIsFinalized(true);
                statement.executeUpdate(string);
                statement.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

