/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobOutputStream;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobStream;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobStreamReader;
import com.teradata.jdbc.jdbc_4.ifsupport.ClobWriter;
import com.teradata.jdbc.jdbc_4.ifsupport.LobReader;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStatement;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.SQLException;

public class Clob
extends com.teradata.jdbc.interfaces.Clob {
    private Reader outReader;
    private boolean atEof = false;
    private byte[] data = null;
    private int offset;
    private TDSession session;
    protected short lobLocatorType = (short)424;
    private String charSet = "ASCII";
    private int charSize = 1;
    private long totalBytesSent = 0L;
    protected Log log;

    public Clob(Log log) {
        this.amountRead = 0L;
        this.log = log;
    }

    public Clob(Reader reader, Log log) {
        this(log);
        this.outReader = new BufferedReader(reader);
    }

    public Clob(Clob clob) throws SQLException {
        this.session = clob.session;
        this.setLength(clob.length());
        this.locator = clob.locator;
        this.lobLocatorType = clob.lobLocatorType;
        this.log = clob.log;
    }

    public InputStream getAsciiStream() throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        return new ClobStream(this.locator, this.length(), this.session, this.lobLocatorType, this.log);
    }

    public Reader getCharacterStream() throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        return new LobReader(new ClobStreamReader(this.locator, this.length(), this.session, this.lobLocatorType, this.log));
    }

    public String getSubString(long l, int n) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        if (l < 1L || n < 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "getSubString");
        }
        if (l + (long)n > this.length() + 1L) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "getSubString");
        }
        if (n == 0) {
            return "";
        }
        ClobStream clobStream = new ClobStream(this.locator, this.length(), this.session, this.lobLocatorType, this.log);
        return clobStream.getSubString(l, n);
    }

    public long position(java.sql.Clob clob, long l) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "Clob", "position");
    }

    public long position(String string, long l) throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ215", "Clob", "position");
    }

    public int write(TDPacketStream tDPacketStream, int n, String string) throws IOException, SQLException {
        int n2 = 0;
        if (this.outReader == null) {
            throw new IOException("Clob has a NULL Reader");
        }
        if (this.length() == 0L) {
            this.atEof = true;
            return 0;
        }
        if (this.data != null) {
            tDPacketStream.put(this.data, this.offset, this.data.length - this.offset);
            this.totalBytesSent += (long)(n2 += this.data.length - this.offset);
            this.data = null;
        }
        if (n2 < n && !this.atEof) {
            if (this.readCharacterStream(n, string) == -1) {
                this.atEof = true;
                return n2;
            }
            int n3 = n - n2;
            if (this.data.length > n3) {
                tDPacketStream.put(this.data, 0, n3);
                this.totalBytesSent += (long)n3;
                n2 += n3;
                this.offset = n3;
            } else {
                tDPacketStream.put(this.data);
                n2 += this.data.length;
                this.totalBytesSent += (long)this.data.length;
                this.data = null;
            }
        }
        if (this.totalBytesSent >= this.length() * (long)this.charSize) {
            this.atEof = true;
        }
        return n2;
    }

    public boolean eof() {
        return this.atEof;
    }

    public void setTDSession(TDSession tDSession) {
        this.session = tDSession;
    }

    public TDSession getTDSession() {
        return this.session;
    }

    public Reader getInCharacterStream() {
        return null;
    }

    public InputStream getInAsciiStream() {
        return null;
    }

    public void setDataLeft(long l) {
    }

    public long dataLeft() {
        return 0L;
    }

    public void setInCharacterStream(Reader reader) {
    }

    public void setInAsciiStream(InputStream inputStream) {
    }

    private int readCharacterStream(int n, String string) throws IOException, SQLException {
        long l = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string));
        int n2 = this.outReader.read();
        if (n2 == -1) {
            this.data = null;
            return -1;
        }
        while (n2 != -1) {
            bufferedWriter.write(n2);
            ++this.amountRead;
            if (this.amountRead >= this.length() || ++l >= (long)n) break;
            n2 = this.outReader.read();
        }
        if (n2 == -1 && this.amountRead < this.length()) {
            this.setLength(l);
        }
        bufferedWriter.flush();
        this.data = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        this.charSize = (int)((long)this.data.length / l);
        return (int)l;
    }

    public void truncate(long l) throws SQLException {
        if (l < 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.truncate");
        }
        String string = this.initWritableLobs(this.session, "Clob.truncate");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.truncate");
        }
        String string2 = "UPDATE " + string + " SET cval=substring( ? FROM 1 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType);
        this.setStaleLocator(true);
        lobStatement.close();
        this.close();
    }

    public Writer setCharacterStream(long l) throws SQLException {
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setCharacterStream");
        }
        String string = this.initWritableLobs(this.session, "Clob.setCharacterStream");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.setCharacterStream");
        }
        String string2 = "UPDATE " + string + " SET cval=substring(? FROM 0 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType);
        this.setStaleLocator(true);
        lobStatement.close();
        this.close();
        return new BufferedWriter(new ClobWriter(this), 64000);
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        if (l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setAsciiStream");
        }
        String string = this.initWritableLobs(this.session, "Clob.setAsciiStream");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.setAsciiStream", String.valueOf(l));
        }
        String string2 = "UPDATE " + string + " SET cval=substring(? FROM 0 FOR " + l + ") WHERE id=" + this.getWritableLobId();
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType);
        this.setStaleLocator(true);
        lobStatement.close();
        this.close();
        return new BufferedOutputStream(new ClobOutputStream(this), 64000);
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Clob.setString");
        }
        if (n < 0 || n2 < 0 || l <= 0L) {
            throw ErrorFactory.makeDriverJDBCException("TJ218", "Clob.setString");
        }
        if (n + n2 > string.length()) {
            throw ErrorFactory.makeDriverJDBCException("TJ219", "Clob.setString");
        }
        String string2 = this.initWritableLobs(this.session, "Clob.setString");
        if (this.session != null) {
            String string3 = "UPDATE " + string2 + " SET cval = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? || SUBSTRING(? FROM " + (l + (long)n2) + " FOR " + this.length() + ") WHERE id=" + this.getWritableLobId();
            try {
                byte[] byArray = string.substring(n, n2 + n).getBytes(this.session.getCharSet());
                if (byArray.length > 64000) {
                    throw ErrorFactory.makeDriverJDBCException("TJ515", "String", String.valueOf(byArray.length));
                }
                LobStatement lobStatement = new LobStatement(this.session, string3);
                lobStatement.updateLob(string3, this.locator, this.lobLocatorType, byArray, 449);
                this.setStaleLocator(true);
                lobStatement.close();
                this.close();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw ErrorFactory.makeDriverJDBCException("TJ212", this.session.getCharSet());
            }
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.setString()");
        }
        return n2;
    }

    public int setString(long l, String string) throws SQLException {
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ516", "Clob.setString");
        }
        return this.setString(l, string, 0, string.length());
    }

    public long length() throws SQLException {
        if (this.locatorIsStale()) {
            this.refreshStaleLocator(this.session, this.lobLocatorType);
        }
        return super.length();
    }

    public void writeStream(long l, Reader reader, int n) throws SQLException {
        String string = this.initWritableLobs(this.session, "Clob.writeStream");
        if (this.session == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "Clob.writeStream()");
        }
        String string2 = "UPDATE " + string + " SET cval = " + "SUBSTRING(? FROM 1 FOR " + (l - 1L) + ") || ? WHERE id=" + this.getWritableLobId();
        Clob clob = new Clob(reader, this.log);
        clob.setLength(n);
        LobStatement lobStatement = new LobStatement(this.session, string2);
        lobStatement.updateLob(string2, this.locator, this.lobLocatorType, clob, this.session.getLobToken(), 421);
        this.setStaleLocator(true);
        lobStatement.close();
        this.close();
    }

    public void finalize() {
        try {
            if (this.session != null && !this.session.isClosed() && this.getWritableLobId() > 0) {
                String string = "DELETE FROM " + this.session.getLobTempTable() + " WHERE id = " + this.getWritableLobId();
                Statement statement = this.session.createStatement(1003, 1007);
                statement.setIsFinalized(true);
                statement.executeUpdate(string);
                statement.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

