/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.FormatChecker;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemByteInt;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemDecimal;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemInteger;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItemSmallInt;
import com.teradata.jdbc.jdbc_4.util.ColumnDisplaySizes;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class ColumnProperties {
    private int precision;
    private int scale;
    private String columnName;
    private String actualColumnName;
    private String columnFormat;
    private int columnType;
    private String columnTypeName;
    private String columnClassName;
    private String schemaName;
    private String tableName;
    private boolean autoIncrement;
    private boolean currency;
    private boolean signed;
    private boolean searchable;
    private boolean readOnly;
    private boolean writable;
    private boolean definitelyWritable;
    private boolean keyColumn;
    private boolean unique;
    private int nullable;
    private String columnLabel;
    private int tdType;
    private int maxDataLengthInBytes;
    private int columnDisplaySize;
    private byte columnExtInfo;

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSearchable() {
        return this.searchable;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isWritable() {
        return this.writable;
    }

    public boolean isDefinitelyWritable() {
        return this.definitelyWritable;
    }

    public boolean isKeyColumn() {
        return this.keyColumn;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public void setColumnDisplaySize(int n) {
        this.columnDisplaySize = n;
    }

    public byte getColumnExtInfo() {
        return this.columnExtInfo;
    }

    public String getColumnFormat() {
        return this.columnFormat;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public void setColumnLabel(String string) {
        this.columnLabel = string;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String string) {
        this.columnName = string;
    }

    public String getActualColumnName() {
        return this.actualColumnName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public void setColumnType(int n) {
        this.columnType = n;
        this.columnTypeName = JDBC4Constants.getJavaSQLTypeName(n);
        this.columnClassName = JDBC4Constants.getJavaClassName(n);
    }

    public String getColumnTypeName() {
        return this.columnTypeName;
    }

    public String getColumnClassName() {
        return this.columnClassName;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public int getNullable() {
        return this.nullable;
    }

    public void setNullable(int n) {
        this.nullable = n;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int n) {
        this.precision = n;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public int getTdType() {
        return this.tdType;
    }

    public void setTdType(int n) {
        this.tdType = n;
    }

    public int getMaxDataLengthInBytes() {
        return this.maxDataLengthInBytes;
    }

    public void initWithPrepInfoItem(PrepInfoItem prepInfoItem, String string) throws JDBCException {
        if (prepInfoItem != null) {
            this.columnFormat = prepInfoItem.getColumnFormat();
            this.columnName = prepInfoItem.getColumnName();
            this.columnLabel = prepInfoItem.getColumnTitle();
            this.columnType = this.determineJavaSQLType(prepInfoItem.getDataType());
            this.columnTypeName = JDBC4Constants.getJavaSQLTypeName(this.columnType);
            this.columnClassName = JDBC4Constants.getJavaClassName(this.columnType);
            this.nullable = JDBC4Constants.getNullable(prepInfoItem.getDataType());
            this.tdType = prepInfoItem.getDataType();
            this.maxDataLengthInBytes = prepInfoItem.getDataLen();
            this.columnDisplaySize = JDBC4Constants.getDisplaySize(prepInfoItem.getDataType());
            if (this.columnDisplaySize == 0 && JDBC4Constants.isCharType(prepInfoItem.getDataType())) {
                this.columnDisplaySize = ColumnDisplaySizes.getCharDisplaySize(prepInfoItem.getDataLen(), string, prepInfoItem.getColumnServerCharSet());
            }
            if (this.columnDisplaySize == 0) {
                this.columnDisplaySize = prepInfoItem.getDataLen();
            }
            if (prepInfoItem instanceof PrepInfoItemDecimal) {
                this.precision = ((PrepInfoItemDecimal)prepInfoItem).getPrecision();
                this.scale = ((PrepInfoItemDecimal)prepInfoItem).getScale();
            } else {
                this.precision = prepInfoItem instanceof PrepInfoItemByteInt ? 3 : (prepInfoItem instanceof PrepInfoItemSmallInt ? 5 : (prepInfoItem instanceof PrepInfoItemInteger ? 10 : 0));
            }
            this.columnExtInfo = prepInfoItem.getColumnExtInfo();
        }
    }

    public void initWithMetadataItem(FullContentMetadataItem fullContentMetadataItem) {
        this.columnFormat = fullContentMetadataItem.getFormat();
        this.columnName = fullContentMetadataItem.getCustomerVisibleColumnName();
        this.actualColumnName = fullContentMetadataItem.getColumnOrParameterName();
        this.columnLabel = fullContentMetadataItem.getTitle();
        this.columnType = JDBC4Constants.getJavaSQLType(fullContentMetadataItem.getDataType());
        this.columnTypeName = JDBC4Constants.getTDTypeName(fullContentMetadataItem.getDataType());
        this.columnClassName = JDBC4Constants.getJavaClassName(this.columnType);
        this.tdType = fullContentMetadataItem.getDataType();
        this.maxDataLengthInBytes = (int)fullContentMetadataItem.getMaxDataLengthInBytes();
        this.tableName = fullContentMetadataItem.getProcedureOrTableName();
        this.schemaName = fullContentMetadataItem.getDatabaseName();
        this.autoIncrement = fullContentMetadataItem.isIdentityColumn() == 89;
        this.signed = fullContentMetadataItem.isSigned() == 89;
        this.searchable = fullContentMetadataItem.isSearchable() == 89;
        this.writable = fullContentMetadataItem.isWritable() == 89;
        this.definitelyWritable = fullContentMetadataItem.isDefinitelyWritable() == 89;
        this.keyColumn = fullContentMetadataItem.isKeyColumn() == 89;
        this.unique = fullContentMetadataItem.isUnique() == 89;
        this.precision = fullContentMetadataItem.getTotalNumberOfDigits();
        this.scale = fullContentMetadataItem.getNumberOfFractionalDigits();
        this.columnExtInfo = fullContentMetadataItem.getColumnExtInfo();
        this.columnDisplaySize = JDBC4Constants.getDisplaySize(fullContentMetadataItem.getDataType());
        if (JDBC4Constants.isTemporalType(fullContentMetadataItem.getDataType())) {
            this.columnDisplaySize += fullContentMetadataItem.getNumberOfFractionalDigits() > 0 ? fullContentMetadataItem.getNumberOfFractionalDigits() + 1 : 0;
            this.columnDisplaySize += fullContentMetadataItem.getNumberOfIntervalDigits();
        }
        if (this.columnDisplaySize == 0 && JDBC4Constants.isCharType(fullContentMetadataItem.getDataType())) {
            this.columnDisplaySize = (int)fullContentMetadataItem.getMaxNumberOfCharacters();
        }
        if (this.columnDisplaySize == 0) {
            this.columnDisplaySize = (int)fullContentMetadataItem.getMaxDataLengthInBytes();
        }
        this.nullable = fullContentMetadataItem.isNullable() == 89 ? 1 : (fullContentMetadataItem.isNullable() == 78 ? 0 : 2);
    }

    private int determineJavaSQLType(int n) {
        if (this.getColumnFormat() != null && (n == 452 || n == 453)) {
            switch (FormatChecker.getFormatType(this.getColumnFormat())) {
                case 2: {
                    n = 760;
                    break;
                }
                case 3: {
                    n = 764;
                    break;
                }
                case 4: {
                    n = 748;
                    break;
                }
            }
        }
        return JDBC4Constants.getJavaSQLType(n);
    }
}

