/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class GeneratedKeys {
    private int autoGeneratedKeys = 2;
    private int[] columnIndex = null;
    private String[] columnName = null;
    private int genKeyIndex = 0;
    private int numberOfColumnsUsed = 0;
    protected Log log;

    public GeneratedKeys(int n, TDSession tDSession) throws JDBCException {
        if (!tDSession.generatedKeysSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ441");
        }
        this.autoGeneratedKeys = n;
    }

    public GeneratedKeys(int[] nArray, TDSession tDSession) throws JDBCException {
        if (!tDSession.generatedKeysSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ441");
        }
        if (nArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ440");
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= 1) continue;
            throw ErrorFactory.makeDriverJDBCException("TJ439");
        }
        this.columnIndex = nArray;
    }

    public GeneratedKeys(String[] stringArray, TDSession tDSession) throws JDBCException {
        if (!tDSession.generatedKeysSupported()) {
            throw ErrorFactory.makeDriverJDBCException("TJ441");
        }
        if (stringArray == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ440");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] != null) continue;
            throw ErrorFactory.makeDriverJDBCException("TJ438");
        }
        this.columnName = stringArray;
    }

    public boolean returnGeneratedKeys() {
        return this.autoGeneratedKeys == 1 || this.columnIndex != null || this.columnName != null;
    }

    public boolean returnsColumn() {
        return this.autoGeneratedKeys == 1;
    }

    public boolean addColumn(int n) {
        if (this.returnsColumn()) {
            return true;
        }
        if (this.columnIndex != null) {
            for (int i = 0; i < this.columnIndex.length; ++i) {
                if (this.columnIndex[i] != n) continue;
                return true;
            }
        }
        return false;
    }

    public void verifyColumns(int n) throws JDBCException {
        if (this.returnsColumn()) {
            return;
        }
        if (this.columnIndex.length > this.numberOfColumnsUsed) {
            if (this.columnName != null) {
                throw ErrorFactory.makeDriverJDBCException("TJ438");
            }
            throw ErrorFactory.makeDriverJDBCException("TJ439");
        }
    }

    private boolean locateColIndex(int n) {
        if (this.columnIndex != null) {
            for (int i = 0; i < this.genKeyIndex; ++i) {
                if (n != this.columnIndex[i]) continue;
                return true;
            }
        }
        return false;
    }

    public boolean addColumnProperties(String string, int n) {
        block6: {
            block5: {
                if (this.returnsColumn()) {
                    return true;
                }
                if (this.columnIndex == null) {
                    this.columnIndex = new int[this.columnName.length];
                }
                if (this.columnName == null) break block5;
                for (int i = 0; i < this.columnName.length; ++i) {
                    if (this.columnName[i].compareToIgnoreCase(string) != 0) continue;
                    if (!this.locateColIndex(n)) {
                        this.columnIndex[this.genKeyIndex++] = n;
                        ++this.numberOfColumnsUsed;
                    }
                    return true;
                }
                break block6;
            }
            if (this.columnIndex == null) break block6;
            for (int i = 0; i < this.columnIndex.length; ++i) {
                if (this.columnIndex[i] != n) continue;
                ++this.numberOfColumnsUsed;
                return true;
            }
        }
        return false;
    }
}

