/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.PreparedParameter;
import com.teradata.jdbc.StatementParameters;
import com.teradata.jdbc.jdbc_4.ParameterSet;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXField;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PushbackInputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.ArrayList;

public class ParameterProperties {
    private DataInfoField[] dataInfoFields;
    private int numberOfParams;
    private ArrayList parameterSets;
    private int numberOfOutParams = 0;
    private int parameterSetIndex = 0;

    public ParameterProperties(int n) {
        this.numberOfParams = n;
    }

    public int getNumberOfParams() {
        return this.numberOfParams - this.getNumberOfOutParams();
    }

    public void addParameterSet(ParameterSet parameterSet) {
        if (this.parameterSets == null) {
            this.parameterSets = new ArrayList();
        }
        this.parameterSets.add(parameterSet);
    }

    public ParameterSet getParameterSet(int n) throws JDBCException {
        if (n < 0 || n >= this.parameterSets.size()) {
            throw ErrorFactory.makeDriverJDBCException("TJ371", n, this.parameterSets.size());
        }
        return (ParameterSet)this.parameterSets.get(n);
    }

    public ParameterSet getParameterSet() throws JDBCException {
        return this.getParameterSet(this.parameterSetIndex);
    }

    public ArrayList getParameterSets() {
        return this.parameterSets;
    }

    public int getParameterSetIndex() {
        return this.parameterSetIndex;
    }

    public void setNextParameterSet() {
        ++this.parameterSetIndex;
    }

    public void resetParameterSetIndex() {
        this.parameterSetIndex = 0;
    }

    public int numberOfParamSets() {
        if (this.parameterSets != null) {
            return this.parameterSets.size();
        }
        return 0;
    }

    public int numberOfParamSetsLeft() {
        if (this.parameterSets != null) {
            return this.parameterSets.size() - this.parameterSetIndex;
        }
        return 0;
    }

    public int getDataSize(int n) throws JDBCException {
        return this.getParameterSet(n).getDataSize() + this.getParameterSet(n).getNullIndicatorBitsSize();
    }

    public int getDataSize() throws JDBCException {
        return this.getDataSize(this.parameterSetIndex);
    }

    public DataInfoField[] getDataInfoFields() {
        return this.dataInfoFields;
    }

    public void setDataInfoFields(DataInfoField[] dataInfoFieldArray) {
        this.dataInfoFields = dataInfoFieldArray;
    }

    public void clear() {
        this.clearDataInfoFields();
        this.parameterSets = null;
        this.resetParameterSetIndex();
    }

    public void clearDataInfoFields() {
        this.dataInfoFields = null;
    }

    public int getDataInfoType(int n) {
        if (this.dataInfoFields == null) {
            return 0;
        }
        return this.dataInfoFields[n - 1].getType();
    }

    public void setDataInfoType(int n, int n2) {
        this.dataInfoFields[n - 1].setType(n2);
    }

    public int getDataInfoScale(int n) {
        if (this.dataInfoFields == null) {
            return 0;
        }
        return this.dataInfoFields[n - 1].getScale();
    }

    public void setDataInfoAdjustedScale(int n, boolean bl, boolean bl2) {
        int n2 = this.getDataInfoScale(n);
        int n3 = this.getDataInfoSignificantDigits(n);
        int n4 = this.getDataInfoPrec(n);
        int n5 = 18;
        if (bl2) {
            n5 = 38;
        }
        if (n2 + n3 > n5) {
            int n6 = n5 - n3;
            this.setDataInfoScale(n, n6);
            this.setDataInfoLength(n, this.setDecLength(n4, n6, bl));
        }
    }

    private long setDecLength(int n, int n2, boolean bl) {
        if (bl) {
            return ComUtil.makeDataInfoXDecLength(n, n2);
        }
        return ComUtil.makeDataInfoDecLength((short)n, (byte)n2);
    }

    public void setDataInfoScale(int n, int n2) {
        this.dataInfoFields[n - 1].setScale(n2);
    }

    public void setDataInfoSignificantDigits(int n, int n2) {
        this.dataInfoFields[n - 1].setSignificantDigits(n2);
    }

    public int getDataInfoSignificantDigits(int n) {
        if (this.dataInfoFields == null) {
            return 0;
        }
        return this.dataInfoFields[n - 1].getSignificantDigits();
    }

    public int getDataInfoPrec(int n) {
        if (this.dataInfoFields == null) {
            return 0;
        }
        return this.dataInfoFields[n - 1].getPrecision();
    }

    public void setDataInfoPrec(int n, int n2) {
        this.dataInfoFields[n - 1].setPrecision(n2);
    }

    public long getDataInfoLength(int n) {
        if (this.dataInfoFields == null) {
            return -1L;
        }
        return this.dataInfoFields[n - 1].getLength();
    }

    public void setDataInfoLength(int n, long l) {
        this.dataInfoFields[n - 1].setLength(l);
    }

    public void setDataInfoField(int n, int n2, long l, int n3, int n4, int n5, boolean bl) throws JDBCException {
        this.verifyParameter(n - 1);
        if (this.dataInfoFields == null) {
            this.dataInfoFields = new DataInfoField[this.numberOfParams];
        }
        this.dataInfoFields[n - 1] = bl ? new DataInfoXField(n2, l, n3, n4) : new DataInfoField(n2, l, n3, n4);
        this.dataInfoFields[n - 1].setSignificantDigits(n5);
    }

    public int getDataInfoSize() {
        if (this.numberOfParams > 0) {
            return this.numberOfParams * this.dataInfoFields[0].getSize();
        }
        return 0;
    }

    private void verifyParameter(int n) throws JDBCException {
        if (n >= this.numberOfParams || n < 0) {
            ErrorFactory.makeDriverJDBCException("TJ169", n, this.numberOfParams);
        }
    }

    public int getNumberOfOutParams() {
        return this.numberOfOutParams;
    }

    public void setNumberOfOutParams(int n) {
        this.numberOfOutParams = n;
    }

    public void adjustParameters(StatementParameters statementParameters, String string) throws SQLException {
        ArrayList arrayList = this.getParameterSets();
        for (int i = 0; i < arrayList.size(); ++i) {
            ParameterSet parameterSet = (ParameterSet)arrayList.get(i);
            this.validateAndAdjustParameterSet(parameterSet, statementParameters, string);
        }
    }

    public void validateAndAdjustParameterSet(ParameterSet parameterSet, StatementParameters statementParameters, String string) throws SQLException {
        block6: for (int i = 1; i <= parameterSet.getNumberOfParams(); ++i) {
            PreparedParameter preparedParameter = parameterSet.getPreparedParameter(i);
            switch (preparedParameter.getSqlType()) {
                case 421: {
                    if (preparedParameter.getOutParamSqlType() == 1 || preparedParameter.getOutParamSqlType() == 12 || preparedParameter.getOutParamSqlType() == -1 || this.getDataInfoType(i) == 449) {
                        this.convertStreamToVarChar(preparedParameter, string, i);
                        continue block6;
                    }
                    this.convertStreamToClob(preparedParameter, i, statementParameters);
                    continue block6;
                }
                case 449: 
                case 453: {
                    if (preparedParameter.getOutParamSqlType() != 2005) continue block6;
                    throw ErrorFactory.makeDriverJDBCException("TJ497", String.valueOf(i));
                }
                case 405: {
                    if (preparedParameter.getOutParamSqlType() == -2 || preparedParameter.getOutParamSqlType() == -3 || preparedParameter.getOutParamSqlType() == -4 || this.getDataInfoType(i) == 689) {
                        this.convertStreamToVarByte(preparedParameter, i);
                        continue block6;
                    }
                    this.convertStreamToBlob(preparedParameter, i, statementParameters);
                    continue block6;
                }
                case 689: 
                case 693: {
                    if (preparedParameter.getOutParamSqlType() != 2004) continue block6;
                    throw ErrorFactory.makeDriverJDBCException("TJ498", String.valueOf(i));
                }
            }
        }
    }

    protected void convertStreamToClob(PreparedParameter preparedParameter, int n, StatementParameters statementParameters) throws SQLException {
        Reader reader = (Reader)preparedParameter.getValue();
        if (reader == null) {
            return;
        }
        this.setDataInfoLength(n, 2097088000L);
        int n2 = statementParameters.addLob(reader, (long)preparedParameter.getLength());
        byte[] byArray = ByteConverter.putInt(n2);
        preparedParameter.setBinaryValue(byArray);
    }

    protected void convertStreamToBlob(PreparedParameter preparedParameter, int n, StatementParameters statementParameters) throws SQLException {
        InputStream inputStream = (InputStream)preparedParameter.getValue();
        if (inputStream == null) {
            return;
        }
        this.setDataInfoLength(n, 2097088000L);
        int n2 = statementParameters.addLob(inputStream, (long)preparedParameter.getLength());
        byte[] byArray = ByteConverter.putInt(n2);
        preparedParameter.setBinaryValue(byArray);
    }

    protected void convertStreamToVarChar(PreparedParameter preparedParameter, String string, int n) throws SQLException {
        int n2 = preparedParameter.getLength();
        Reader reader = (Reader)preparedParameter.getValue();
        this.setDataInfoType(n, 449);
        if (reader == null) {
            preparedParameter.setLength(2);
            preparedParameter.setBinaryValue(new byte[2]);
            return;
        }
        try {
            reader = new BufferedReader(reader);
            reader.mark(n2);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)byteArrayOutputStream, string));
            boolean bl = this.readCharacterStream(n, reader, bufferedWriter, n2);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            n2 = byArray.length;
            if (n2 < 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ171", n2);
            }
            if (n2 > 64000) {
                throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(n2));
            }
            byte[] byArray2 = new byte[n2 + 2];
            ByteConverter.putShort(byArray2, 0, (short)n2);
            System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
            if (this.getDataInfoLength(n) < (long)n2) {
                this.setDataInfoLength(n, n2);
            }
            preparedParameter.setLength(n2);
            preparedParameter.setBinaryValue(byArray2);
        }
        catch (IOException iOException) {
            throw ErrorFactory.makeDriverJDBCException("TJ490", Integer.toString(n), iOException.getMessage());
        }
    }

    protected void convertStreamToVarByte(PreparedParameter preparedParameter, int n) throws SQLException {
        int n2 = preparedParameter.getLength();
        InputStream inputStream = (InputStream)preparedParameter.getValue();
        this.setDataInfoType(n, 689);
        if (inputStream == null) {
            preparedParameter.setLength(2);
            preparedParameter.setBinaryValue(new byte[2]);
            return;
        }
        try {
            Object object;
            byte[] byArray;
            if (n2 == 0) {
                byArray = new byte[]{};
            } else {
                inputStream = new PushbackInputStream(inputStream, n2);
                object = new ByteArrayOutputStream(n2);
                boolean bl = this.readBinaryStream(n, (PushbackInputStream)inputStream, (ByteArrayOutputStream)object, n2);
                byArray = ((ByteArrayOutputStream)object).toByteArray();
                n2 = byArray.length;
                if (n2 > 64000) {
                    throw ErrorFactory.makeDriverJDBCException("TJ499", String.valueOf(n), String.valueOf(n2));
                }
            }
            object = new byte[n2 + 2];
            ByteConverter.putShort((byte[])object, 0, (short)n2);
            System.arraycopy(byArray, 0, object, 2, n2);
            if (this.getDataInfoLength(n) < (long)n2) {
                this.setDataInfoLength(n, n2);
            }
            preparedParameter.setLength(n2);
            preparedParameter.setBinaryValue((byte[])object);
        }
        catch (IOException iOException) {
            throw ErrorFactory.makeDriverJDBCException("TJ490", Integer.toString(n), iOException.getMessage());
        }
    }

    private boolean readCharacterStream(int n, Reader reader, BufferedWriter bufferedWriter, long l) throws IOException, SQLException {
        long l2 = 0L;
        int n2 = reader.read();
        while (n2 != -1) {
            bufferedWriter.write(n2);
            if (++l2 >= l) break;
            n2 = reader.read();
        }
        bufferedWriter.flush();
        return n2 == -1;
    }

    private boolean readBinaryStream(int n, PushbackInputStream pushbackInputStream, ByteArrayOutputStream byteArrayOutputStream, long l) throws IOException, SQLException {
        long l2 = 0L;
        byte[] byArray = new byte[(int)l];
        int n2 = pushbackInputStream.read(byArray, 0, (int)l);
        while (n2 != -1) {
            byteArrayOutputStream.write(byArray, 0, (int)l);
            if ((l2 += (long)n2) >= l) break;
            n2 = pushbackInputStream.read(byArray, 0, (int)l);
        }
        byteArrayOutputStream.flush();
        return n2 == -1;
    }
}

