/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.PreparedParameter;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import java.util.HashMap;

public class ParameterSet {
    private PreparedParameter[] preparedParameters;
    private int nullIndicatorBitsSize;
    private int numberOfParams;
    private int numberOfOutParams = 0;
    private ParameterProperties paramProperties;
    private HashMap deferredLobs;
    private byte[] nullIndicatorBits;

    public ParameterSet(int n, ParameterProperties parameterProperties) {
        this.numberOfParams = n;
        this.nullIndicatorBitsSize = (n + 7) / 8;
        this.deferredLobs = new HashMap();
        this.paramProperties = parameterProperties;
        this.preparedParameters = new PreparedParameter[n];
    }

    public ParameterSet(ParameterSet parameterSet, ParameterProperties parameterProperties) {
        this.paramProperties = parameterProperties;
        this.numberOfParams = parameterSet.getNumberOfParams();
        this.numberOfOutParams = parameterSet.getNumberOfOutParams();
        this.deferredLobs = new HashMap();
        this.preparedParameters = new PreparedParameter[this.numberOfParams];
        for (int i = 1; i <= this.numberOfParams; ++i) {
            this.preparedParameters[i - 1] = parameterSet.getPreparedParameter(i).copy();
        }
    }

    public int getUnsetParameter() {
        for (int i = 0; i < this.numberOfParams; ++i) {
            if (this.preparedParameters[i] != null) continue;
            return i + 1;
        }
        return 0;
    }

    public void clear() {
        for (int i = 0; i < this.numberOfParams; ++i) {
            this.preparedParameters[i] = null;
        }
        this.numberOfOutParams = 0;
        this.nullIndicatorBits = new byte[this.nullIndicatorBitsSize];
    }

    public void setParameterProperties(ParameterProperties parameterProperties) {
        this.paramProperties = parameterProperties;
    }

    public int getNumberOfParams() {
        return this.numberOfParams;
    }

    public int getNumberOfOutParams() {
        return this.numberOfOutParams;
    }

    public void setNumberOfOutParams(int n) {
        this.numberOfOutParams = n;
    }

    public PreparedParameter getPreparedParameter(int n) {
        return this.preparedParameters[n - 1];
    }

    public PreparedParameter[] getPreparedParameters() {
        return this.preparedParameters;
    }

    public void setPreparedParameters(PreparedParameter[] preparedParameterArray) {
        this.preparedParameters = preparedParameterArray;
    }

    public void setPreparedParameter(int n, PreparedParameter preparedParameter) {
        this.preparedParameters[n - 1] = preparedParameter;
    }

    protected boolean isNullValue(int n) {
        int n2 = (n + 7) / 8 - 1;
        int n3 = 1 << 7 - (n - 1) % 8;
        return (this.nullIndicatorBits[n2] & (byte)n3) == (byte)n3;
    }

    public boolean isNull(int n) {
        return this.preparedParameters[n - 1].isNullValue();
    }

    public void setNullIndicatorBits(byte[] byArray) {
        this.nullIndicatorBitsSize = byArray.length;
        this.nullIndicatorBits = new byte[this.nullIndicatorBitsSize];
        System.arraycopy(byArray, 0, this.nullIndicatorBits, 0, this.nullIndicatorBitsSize);
    }

    public byte[] getNullIndicatorBits() {
        return this.nullIndicatorBits;
    }

    public int getDataSize() {
        int n = 0;
        for (int i = 0; i < this.numberOfParams; ++i) {
            if (this.preparedParameters[i].getParamType() == 2) continue;
            n += this.preparedParameters[i].getBinaryValue().length;
        }
        return n;
    }

    public int getNullIndicatorBitsSize() {
        return this.nullIndicatorBitsSize;
    }

    public HashMap getDeferredLobs() {
        return this.deferredLobs;
    }

    public void setDeferredLobs(HashMap hashMap) {
        this.deferredLobs = hashMap;
    }

    public void setParameter(int n, Object object, byte[] byArray, int n2, boolean bl, int n3, int n4) {
        PreparedParameter preparedParameter = this.preparedParameters[n - 1];
        if (preparedParameter == null) {
            this.preparedParameters[n - 1] = new PreparedParameter(object, byArray, n2, bl, n3, n4);
        } else {
            preparedParameter.setNewValues(object, byArray, n2, bl, n3, n4);
        }
    }

    public void setOutParamSqlType(int n, int n2) {
        PreparedParameter preparedParameter = this.preparedParameters[n - 1];
        if (preparedParameter == null) {
            this.preparedParameters[n - 1] = preparedParameter = new PreparedParameter();
        }
        preparedParameter.setOutParamSqlType(n2);
    }

    public void setParamType(int n, int n2) {
        if (this.preparedParameters[n - 1] == null) {
            this.preparedParameters[n - 1] = new PreparedParameter(n2);
        } else {
            this.preparedParameters[n - 1].setParamType(n2);
        }
    }

    public int getParamType(int n) {
        if (this.preparedParameters[n - 1] != null) {
            return this.preparedParameters[n - 1].getParamType();
        }
        return 4;
    }

    public void setOutParamName(int n, String string) {
        if (this.preparedParameters[n - 1] != null) {
            this.preparedParameters[n - 1].setOutParamName(string);
        }
    }

    public void setBinaryValue(int n, byte[] byArray) {
        if (this.preparedParameters[n - 1] != null) {
            this.preparedParameters[n - 1].setBinaryValue(byArray);
        }
    }

    public String getOutParamName(int n) {
        if (this.preparedParameters[n - 1] != null) {
            return this.preparedParameters[n - 1].getOutParamName();
        }
        return null;
    }
}

