/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedBatchStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PreparedStatement
extends Statement {
    private ParameterProperties paramProperties = null;
    private int numberOfBatchStatements = 0;
    private byte mode = (byte)69;
    private ArrayList parameterMetaData = null;

    public PreparedStatement(TDSession tDSession, String string, int n, int n2, GeneratedKeys generatedKeys) throws SQLException {
        super(tDSession, n, n2, generatedKeys);
        if (string != null) {
            boolean bl;
            boolean bl2 = bl = tDSession.getURLParameters().getPrepSupport() || tDSession.isStatementInfoSupported();
            if (bl) {
                this.prepareRequest(string, 3, (byte)83);
            }
            if (this.getMetaDataList().size() == 0 || ActivityAnalyzer.outParamResultSet(this.getMetaDataList().getFirstMetaData().getActivityType()) || this.anyAmbiguousResultSetColumns()) {
                this.mode = (byte)66;
            }
        }
    }

    private boolean anyAmbiguousResultSetColumns() throws SQLException {
        for (int i = 1; i <= this.getMetaDataList().size(); ++i) {
            TeraResultSetMetaData teraResultSetMetaData = this.getMetaDataList().getMetaDataForStatement(i);
            for (int j = 1; j <= teraResultSetMetaData.getColumnCount(); ++j) {
                if (teraResultSetMetaData.getColumnType(j) != 0) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean execute(String string) throws SQLException {
        PreparedStatementController preparedStatementController = new PreparedStatementController(this, this.getConnection(), string);
        this.executeStatement(preparedStatementController, 3, this.mode);
        if (this.paramProperties != null) {
            this.paramProperties.clear();
        }
        return this.getResults().moreResults() && this.getResults().getResult(0).getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        try {
            if (this.getMetaData() == null && this.getMetaDataList().size() > 0 && !ActivityAnalyzer.outParamResultSet(this.getMetaDataList().getFirstMetaData().getActivityType())) {
                throw ErrorFactory.makeDriverJDBCException("TJ388");
            }
            if (this.getMetaDataList().size() > 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ390", "executeQuery()");
            }
            PreparedStatementController preparedStatementController = new PreparedStatementController(this, this.getConnection(), string);
            this.executeStatement(preparedStatementController, 2, this.mode);
            Object var4_3 = null;
            if (this.paramProperties != null) {
                this.paramProperties.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.paramProperties != null) {
                this.paramProperties.clear();
            }
            throw throwable;
        }
        return this.getResultSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int executeUpdate(String string) throws SQLException {
        try {
            if (this.getMetaData() != null && !this.returnGeneratedKeys()) {
                throw ErrorFactory.makeDriverJDBCException("TJ389");
            }
            if (this.getMetaDataList().size() > 1) {
                throw ErrorFactory.makeDriverJDBCException("TJ390", "executeUpdate()");
            }
            PreparedStatementController preparedStatementController = new PreparedStatementController(this, this.getConnection(), string);
            this.executeStatement(preparedStatementController, 1, this.mode);
            Object var4_3 = null;
            if (this.paramProperties != null) {
                this.paramProperties.clear();
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.paramProperties != null) {
                this.paramProperties.clear();
            }
            throw throwable;
        }
        return this.getUpdateCount();
    }

    public int[] executeBatchDMLArray(String string) throws SQLException {
        if (this.getMetaData() != null && !this.returnGeneratedKeys()) {
            throw ErrorFactory.makeDriverJDBCException("TJ391");
        }
        try {
            try {
                this.numberOfBatchStatements = this.paramProperties != null ? this.paramProperties.numberOfParamSets() : 0;
                this.getMetaDataList().setBatchStatement(true);
                PreparedBatchStatementController preparedBatchStatementController = new PreparedBatchStatementController(this, this.getConnection(), string);
                boolean bl = this.returnGeneratedKeys() && !this.getGeneratedKeys().returnsColumn();
                this.executeStatement(preparedBatchStatementController, 5, (byte)69, bl);
            }
            catch (JDBCException jDBCException) {
                int[] nArray = this.getResults().getUpdateArray();
                if (nArray == null || nArray.length == 0) {
                    nArray = new int[this.numberOfBatchStatements];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = -3;
                    }
                }
                throw ErrorFactory.convertToBatchUpdateException(jDBCException, nArray);
            }
            Object var6_6 = null;
            if (this.paramProperties != null) {
                this.paramProperties.clear();
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.paramProperties != null) {
                this.paramProperties.clear();
            }
            throw throwable;
        }
        this.checkResults();
        return this.getResults().getUpdateArray();
    }

    public void setParameterProperties(ParameterProperties parameterProperties) {
        this.paramProperties = parameterProperties;
    }

    public ParameterProperties getParameterProperties() {
        return this.paramProperties;
    }

    public int getNumberOfBatchStatements() {
        return this.numberOfBatchStatements;
    }

    public TeraResultSetMetaData getMetaData() throws JDBCException {
        boolean bl;
        boolean bl2 = this.getResults().getResultsSize() > 0 && this.getResultSet() != null;
        boolean bl3 = bl = this.getResults().getResultsSize() == 0 && this.getMetaDataList().size() > 0;
        TeraResultSetMetaData teraResultSetMetaData = bl2 ? this.getResultSet().getMetaData() : (bl ? this.getMetaDataList().getFirstMetaData() : null);
        return teraResultSetMetaData != null && ActivityAnalyzer.resultSetExpected(teraResultSetMetaData.getActivityType()) && !ActivityAnalyzer.outParamResultSet(teraResultSetMetaData.getActivityType()) ? teraResultSetMetaData : null;
    }

    public void setParameterMarkerMetaData(ArrayList arrayList) {
        this.parameterMetaData = arrayList;
    }

    public ArrayList getParameterMarkerMetaData() {
        return this.parameterMetaData;
    }
}

