/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc.RowFetchController;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.ForwardOnlyResultSet;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.ScrollableResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.UpdatableResultSet;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public abstract class ResultSet {
    private RowFetchController m_controller;
    private int m_nRequestNumber;
    private int m_nStatementNumber;
    private int m_nFetchSize;
    private int m_nFetchDirection;
    private int m_nActivityCount = 0;
    protected int m_nCurrentRowNumber = 0;
    protected ResultSetRow m_rowCurrent = null;
    protected List m_listFetchedRows = new ArrayList();
    protected int m_nFirstFetchedRowNumber = 1;
    private boolean m_bMoreToFetch = false;
    private TeraResultSetMetaData m_rsmd = null;
    private boolean m_bWasNull = false;
    private int m_nTotalAvailableRowCount = -1;
    private boolean m_bResultSetClosed = false;
    protected Log log;
    private FetchedRowsPostProcessor m_postprocessor;

    protected ResultSet(RowFetchController rowFetchController, Log log) {
        this.log = log;
        this.m_controller = rowFetchController;
        if (rowFetchController != null) {
            this.m_nRequestNumber = this.m_controller.getCurrentRequestNumber();
            this.m_nStatementNumber = this.m_controller.getCurrentStatementNumber();
            this.m_nFetchSize = this.m_controller.getRowFetchSize();
            this.m_nFetchDirection = this.m_controller.getRowFetchDirection();
        }
    }

    public static ResultSet createResultSet(Statement statement, RowFetchController rowFetchController, Log log) throws JDBCException {
        return ResultSet.createResultSet(statement, rowFetchController, log, null);
    }

    public static ResultSet createResultSet(Statement statement, RowFetchController rowFetchController, Log log, TeraResultSetMetaData teraResultSetMetaData) throws JDBCException {
        ResultSet resultSet = ResultSet.internalCreateResultSet(statement, rowFetchController, log, teraResultSetMetaData);
        if (log.isDebugEnabled()) {
            log.debug("ResultSet.createResultSet: created result set type " + resultSet.getClass().getName());
        }
        resultSet.m_rsmd = teraResultSetMetaData;
        return resultSet;
    }

    private static ResultSet internalCreateResultSet(Statement statement, RowFetchController rowFetchController, Log log, TeraResultSetMetaData teraResultSetMetaData) throws JDBCException {
        if (statement == null && rowFetchController instanceof StatementController) {
            statement = ((StatementController)rowFetchController).getStatement();
        }
        if (statement != null) {
            if (statement.getResultSetConcurrency() == 1008) {
                if (teraResultSetMetaData != null) {
                    for (int i = 0; i < teraResultSetMetaData.getColumnCount(); ++i) {
                        ColumnProperties columnProperties = teraResultSetMetaData.getColumnProperties(i + 1);
                        if (!columnProperties.isUnique() && !columnProperties.isKeyColumn()) continue;
                        return new UpdatableResultSet((StatementController)rowFetchController, log);
                    }
                }
                log.debug("ResultSet.internalCreateResultSet: downgraded concurrency from updatable result set to read-only because the result set had no unique columns or key columns");
                statement.getConnection().addWarning(ErrorFactory.makeSQLWarning("TJ500"));
            }
            switch (statement.getResultSetType()) {
                case 1004: 
                case 1005: {
                    return new ScrollableResultSet((StatementController)rowFetchController, log);
                }
            }
        }
        return new ForwardOnlyResultSet(rowFetchController, log);
    }

    public void setNumberOfRows(int n) {
        this.m_nActivityCount = n;
    }

    public int getNumberOfRows() {
        return this.m_nActivityCount;
    }

    protected int getRowCount() {
        int n;
        int n2 = this.m_controller == null ? 0 : this.m_controller.getMaxFetchRows();
        int n3 = n = n2 > 0 ? Math.min(n2, this.m_nActivityCount) : this.m_nActivityCount;
        if (this.m_nTotalAvailableRowCount >= 0) {
            n = Math.min(n, this.m_nTotalAvailableRowCount);
        }
        return n;
    }

    public Object getObject(int n) throws SQLException {
        this.validateRowPositionForGet(String.valueOf(n));
        Object object = this.m_rowCurrent == null ? null : this.m_rowCurrent.getValue(n - 1);
        this.m_bWasNull = object == null;
        return object;
    }

    public void addResultSetRow(ResultSetRow resultSetRow) throws JDBCException {
        if (this.m_controller != null) {
            int n = this.m_controller.getMaxFetchFieldSize();
            int n2 = this.m_rsmd.getColumnCount();
            for (int i = 1; i <= n2; ++i) {
                int n3 = this.m_rsmd.getColumnType(i);
                if (n <= 0 || !this.validTruncationType(n3)) continue;
                this.limitColumn(resultSetRow, i - 1, n);
            }
        }
        this.m_listFetchedRows.add(resultSetRow);
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSet.addResultSetRow added row with " + resultSetRow.size() + " columns; m_listFetchedRows.size=" + this.m_listFetchedRows.size() + " this=" + this);
        }
    }

    private boolean validTruncationType(int n) {
        switch (n) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    private void limitColumn(ResultSetRow resultSetRow, int n, int n2) throws JDBCException {
        String string;
        Object object = resultSetRow.getValue(n);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if (byArray.length > n2) {
                byte[] byArray2 = new byte[n2];
                System.arraycopy(byArray, 0, byArray2, 0, n2);
                resultSetRow.setValue(n, byArray2);
            }
        } else if (object instanceof String && (string = (String)object).length() > n2) {
            resultSetRow.setValue(n, string.substring(0, n2));
        }
    }

    public boolean isMoreToFetch() {
        return this.m_bMoreToFetch;
    }

    public void setMoreToFetch(boolean bl) {
        this.m_bMoreToFetch = bl;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSet.setMoreToFetch m_bMoreToFetch=" + this.m_bMoreToFetch + " this=" + this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean goToRow(int n) throws SQLException {
        boolean bl;
        block14: {
            boolean bl2;
            block13: {
                boolean bl3;
                block12: {
                    this.cancelRowChanges();
                    try {
                        boolean bl4;
                        boolean bl5;
                        if (this.m_controller != null) {
                            if (!this.m_controller.registerStatement()) {
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug("ResultSet.goToRow: cleanup has already started");
                                }
                                boolean bl6 = false;
                                Object var10_4 = null;
                                if (this.m_controller == null) return bl6;
                                this.m_controller.unregisterStatement();
                                return bl6;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ResultSet.goToRow: cleanup has not started");
                            }
                        }
                        this.m_rowCurrent = null;
                        int n2 = this.getRowCount();
                        this.m_nCurrentRowNumber = n < 0 ? 0 : (n > n2 + 1 ? n2 + 1 : n);
                        boolean bl7 = this.m_nCurrentRowNumber == 0;
                        boolean bl8 = this.m_nCurrentRowNumber == n2 + 1;
                        boolean bl9 = bl5 = bl7 || bl8;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ResultSet.goToRow nAbsolute=" + n + " bBeforeFirstRow=" + bl7 + " bAfterLastRow=" + bl8 + " bInvalidRow=" + bl5 + " nRowCount=" + n2);
                        }
                        if (bl5) {
                            bl3 = false;
                            break block12;
                        }
                        int n3 = this.m_nFirstFetchedRowNumber + this.m_listFetchedRows.size();
                        boolean bl10 = bl4 = this.m_nCurrentRowNumber >= this.m_nFirstFetchedRowNumber && this.m_nCurrentRowNumber < n3;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ResultSet.goToRow m_nCurrentRowNumber=" + this.m_nCurrentRowNumber + " m_nFirstFetchedRowNumber=" + this.m_nFirstFetchedRowNumber + " m_listFetchedRows.size=" + this.m_listFetchedRows.size() + " nBeyondFetchRowNumber=" + n3 + " bAlreadyFetched=" + bl4);
                        }
                        if (!bl4) {
                            this.m_listFetchedRows.clear();
                            this.m_nFirstFetchedRowNumber = this.m_nCurrentRowNumber;
                            this.m_controller.fetchRows(this, this.m_nRequestNumber, this.m_nStatementNumber, this.m_nCurrentRowNumber, n3);
                            if (this.m_listFetchedRows.isEmpty()) {
                                bl2 = false;
                                break block13;
                            }
                            if (this.m_postprocessor != null) {
                                this.m_postprocessor.processRows(this.m_nFirstFetchedRowNumber, this.m_listFetchedRows);
                            }
                        }
                        this.m_rowCurrent = (ResultSetRow)this.m_listFetchedRows.get(this.m_nCurrentRowNumber - this.m_nFirstFetchedRowNumber);
                        bl = true;
                        break block14;
                    }
                    catch (Throwable throwable) {
                        Object var10_8 = null;
                        if (this.m_controller == null) throw throwable;
                        this.m_controller.unregisterStatement();
                        throw throwable;
                    }
                }
                Object var10_5 = null;
                if (this.m_controller == null) return bl3;
                this.m_controller.unregisterStatement();
                return bl3;
            }
            Object var10_6 = null;
            if (this.m_controller == null) return bl2;
            this.m_controller.unregisterStatement();
            return bl2;
        }
        Object var10_7 = null;
        if (this.m_controller == null) return bl;
        this.m_controller.unregisterStatement();
        return bl;
    }

    public void setFetchedRowsPostProcessor(FetchedRowsPostProcessor fetchedRowsPostProcessor) throws SQLException {
        this.m_postprocessor = fetchedRowsPostProcessor;
        if (this.m_postprocessor != null && !this.m_listFetchedRows.isEmpty()) {
            this.m_postprocessor.processRows(this.m_nFirstFetchedRowNumber, this.m_listFetchedRows);
        }
    }

    public TeraResultSetMetaData getMetaData() {
        return this.m_rsmd;
    }

    public void setMetaData(TeraResultSetMetaData teraResultSetMetaData) {
        this.m_rsmd = teraResultSetMetaData;
    }

    public TDSession getLobSession() {
        return this.m_controller.getLobSession();
    }

    public void close() throws SQLException {
        boolean bl = false;
        this.internalClose(bl);
    }

    protected void finalize() {
        try {
            boolean bl = true;
            this.internalClose(bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void internalClose(boolean bl) throws SQLException {
        ResultSet resultSet;
        ResultSet resultSet2 = resultSet = this.m_controller != null ? this.m_controller.getCloseMutex() : this;
        synchronized (resultSet2) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ResultSet.close: upon entry m_bResultSetClosed=" + this.m_bResultSetClosed + ", this=" + this);
            }
            if (this.m_bResultSetClosed) {
                return;
            }
            this.m_bResultSetClosed = true;
            if (this.m_controller != null) {
                this.m_controller.closingResultSet(bl);
            }
        }
    }

    public void suppressResponseCancel() {
        this.m_bResultSetClosed = true;
        if (this.m_controller != null) {
            this.m_controller.suppressResponseCancel();
        }
    }

    public int getRequestNumber() {
        return this.m_nRequestNumber;
    }

    public int getStatementNumber() {
        return this.m_nStatementNumber;
    }

    public void setStartingRowPosition(long l) throws JDBCException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw ErrorFactory.makeDriverJDBCException("TJ627", String.valueOf(l));
        }
        int n = (int)l;
        this.m_nCurrentRowNumber = n == 0 ? 0 : n - 1;
        this.m_nFirstFetchedRowNumber = n == 0 ? 1 : n;
    }

    public boolean wasNull() {
        return this.m_bWasNull;
    }

    public int getConcurrency() {
        return 1007;
    }

    public abstract boolean absolute(int var1) throws SQLException;

    public abstract void afterLast() throws SQLException;

    public abstract void beforeFirst() throws SQLException;

    public abstract boolean first() throws SQLException;

    public int getFetchDirection() {
        return this.m_nFetchDirection;
    }

    public int getFetchSize() {
        return this.m_nFetchSize;
    }

    public int getRow() {
        return this.m_rowCurrent == null ? 0 : this.m_nCurrentRowNumber;
    }

    public abstract int getType() throws SQLException;

    public boolean isAfterLast() throws SQLException {
        return this.m_nCurrentRowNumber > this.getRowCount();
    }

    public boolean isBeforeFirst() {
        return this.getRowCount() != 0 && this.m_nCurrentRowNumber == 0;
    }

    public boolean isFirst() {
        return this.m_nCurrentRowNumber == 1;
    }

    public boolean isLast() throws SQLException {
        int n = this.getRowCount();
        return n != 0 && this.m_nCurrentRowNumber == n;
    }

    public abstract boolean last() throws SQLException;

    public boolean next() throws SQLException {
        return this.goToRow(this.m_nCurrentRowNumber + 1);
    }

    public abstract boolean previous() throws SQLException;

    public void refreshRow() throws SQLException {
    }

    public abstract boolean relative(int var1) throws SQLException;

    public void setFetchDirection(int n) throws SQLException {
        if (this.getType() == 1003 && n != 1000) {
            throw ErrorFactory.makeDriverJDBCException("TJ320");
        }
        this.m_nFetchDirection = n;
    }

    public void setFetchSize(int n) throws SQLException {
        int n2;
        int n3 = n2 = this.m_controller == null ? 0 : this.m_controller.getMaxFetchRows();
        if (n < 0 || n2 > 0 && n > n2) {
            throw ErrorFactory.makeDriverJDBCException("TJ321", n);
        }
        this.m_nFetchSize = n;
    }

    public void lastRowFetched() {
        this.m_nTotalAvailableRowCount = this.m_nFirstFetchedRowNumber + this.m_listFetchedRows.size() - 1;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ResultSet.lastRowFetched m_nTotalAvailableRowcount=" + this.m_nTotalAvailableRowCount);
        }
    }

    public boolean isClosed() {
        return this.m_bResultSetClosed;
    }

    public void updateInt(int n, int n2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateDouble(int n, double d) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateBlob(int n, Blob blob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateByte(int n, byte by) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateClob(int n, Clob clob) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateDate(int n, Date date) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateFloat(int n, float f) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateLong(int n, long l) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateNull(int n) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateShort(int n, short s) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateString(int n, String string) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateTime(int n, Time time) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateObject(int n, Object object) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void updateRow() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void deleteRow() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void insertRow() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void moveToInsertRow() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void moveToCurrentRow() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    public void cancelRowUpdates() throws SQLException {
        throw ErrorFactory.makeDriverJDBCException("TJ501");
    }

    protected void cancelRowChanges() throws SQLException {
    }

    public void validateRowPositionForGet(String string) throws SQLException {
        if (this.getRowCount() == 0) {
            throw ErrorFactory.makeDriverJDBCException("TJ630", string);
        }
        if (this.isBeforeFirst()) {
            throw ErrorFactory.makeDriverJDBCException("TJ632", string);
        }
        if (this.isAfterLast()) {
            throw ErrorFactory.makeDriverJDBCException("TJ633", string);
        }
    }

    public static interface FetchedRowsPostProcessor {
        public void processRows(int var1, List var2) throws SQLException;
    }
}

