/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.ifsupport.Results;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementCancelState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;

public class Statement
implements Mutex.AcquireCallback {
    private TDPacket lnkTDPacket;
    protected TDSession session;
    private Collection batch;
    private Results results;
    private ResultSet m_rsOutParams;
    private SQLWarning warning;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private int maxFieldSize = 0;
    private int resultSetType;
    private int resultSetConcurrency;
    private int fetchSize = 0;
    private int fetchDirection = 1000;
    private StatementState statementState;
    private long statementStartTime;
    private Thread executingThread;
    private int currentRequestNumber = 0;
    private boolean abortLobTransfer = false;
    protected boolean escapeProcessing = true;
    private boolean m_bRequestClosed = false;
    private boolean useKeepResponse;
    protected Log log;
    private boolean m_isFinalized = false;
    private GeneratedKeys generatedKeys;
    private MetaDataList metaDataList = new MetaDataList();
    private byte m_nRequestMode = (byte)73;

    public Statement(TDSession tDSession, int n, int n2, GeneratedKeys generatedKeys) throws JDBCException {
        int n3 = n;
        int n4 = n2;
        if (n4 == 1008 && !tDSession.isStatementInfoSupported()) {
            n4 = 1007;
            tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ367"));
        }
        if (n3 == 1004) {
            if (!tDSession.isPositioningSupported()) {
                n3 = 1003;
                tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ368"));
            } else if (!tDSession.isLobSupported()) {
                n3 = 1003;
                tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ554"));
            }
        } else if (n3 == 1005) {
            if (tDSession.isPositioningSupported() && tDSession.isLobSupported()) {
                n3 = 1004;
                tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ369"));
            } else if (!tDSession.isPositioningSupported()) {
                n3 = 1003;
                tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ370"));
            } else if (!tDSession.isLobSupported()) {
                n3 = 1003;
                tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ555"));
            }
        }
        if (n3 == 1003 && n4 == 1008 && tDSession.isPositioningSupported()) {
            n3 = 1004;
            tDSession.addWarning(ErrorFactory.makeSQLWarning("TJ502"));
        }
        if (tDSession.isLobSupported()) {
            this.m_nRequestMode = (byte)77;
        }
        this.session = tDSession;
        this.log = tDSession.getLog();
        this.batch = new ArrayList();
        this.results = new Results(this.log);
        this.resultSetType = n3;
        this.resultSetConcurrency = n4;
        this.generatedKeys = generatedKeys;
        this.statementState = new StatementState();
    }

    public ResultSet getResultSet() throws JDBCException {
        if (this.results.getResultType() == 2 || this.results.getResultType() == 3) {
            return this.results.getResult().getResultSet();
        }
        return null;
    }

    public LocalEscapeFunctions getLocalEscapeFunctions() {
        return this.session;
    }

    public byte getRequestMode() {
        return this.m_nRequestMode;
    }

    public void setRequestMode(byte by) {
        this.m_nRequestMode = by;
    }

    public void setResultSet(ResultSet resultSet) {
        this.results.reinit();
        this.results.addResult(null, new Result(resultSet));
    }

    public GeneratedKeys getGeneratedKeys() {
        return this.generatedKeys;
    }

    public void setGeneratedKeys(GeneratedKeys generatedKeys) {
        this.generatedKeys = generatedKeys;
    }

    public boolean returnGeneratedKeys() {
        return this.generatedKeys != null;
    }

    public MetaDataList getMetaDataList() {
        return this.metaDataList;
    }

    public ResultSet getOutParamResultSet() {
        return this.m_rsOutParams;
    }

    public void setOutParamResultSet(ResultSet resultSet) {
        this.m_rsOutParams = resultSet;
    }

    public synchronized boolean execute(String string) throws SQLException {
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions());
        byte by = 66;
        if (this.generatedKeys != null && this.generatedKeys.returnGeneratedKeys()) {
            this.prepareRequest(string, 3, (byte)80);
            by = 69;
        }
        this.executeStatement(new StatementController(this, this.session, string), 3, by);
        return this.results.moreResults() && this.results.getResult(0).getType() == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ResultSet executeQuery(String string) throws SQLException {
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions());
        try {
            this.session.registerStatement(this);
            this.executeStatement(new StatementController(this, this.session, string), 2, (byte)66);
            ResultSet resultSet = this.results.getResult().getResultSet();
            return resultSet;
        }
        finally {
            this.session.unregisterStatement(this);
        }
    }

    protected void executeStatement(StatementController statementController, int n, byte by) throws SQLException {
        this.executeStatement(statementController, n, by, this.session.isLobSupported());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void executeStatement(StatementController statementController, int n, byte by, boolean bl) throws SQLException {
        if (this.log.canLog(1)) {
            this.log.info("executeStatement queryTimeout=" + this.queryTimeout);
        }
        this.initStatement(bl);
        this.session.acquireSessionLock(this);
        try {
            boolean bl2;
            statementController.setResultTypeExpected(n);
            statementController.setMode(by);
            boolean bl3 = bl2 = by == 83 || by == 80;
            if (!bl2) {
                this.session.beforeExecuteStatement();
            }
            this.checkAborted("prior to executing the statement request");
            try {
                this.changeStatementState(3);
                statementController.run();
            }
            catch (JDBCException jDBCException) {
                this.log.info(jDBCException);
                try {
                    if (!bl2) {
                        this.session.afterExecuteStatement();
                    }
                }
                catch (JDBCException jDBCException2) {
                    this.log.info(jDBCException2);
                    jDBCException.setNextException(jDBCException2);
                }
                this.changeStatementState(1);
                throw ErrorAnalyzer.analyzeError(jDBCException);
            }
            try {
                if (!bl2) {
                    this.session.afterExecuteStatement();
                }
            }
            finally {
                this.changeStatementState(1);
            }
        }
        finally {
            this.session.releaseSessionLock();
            this.log.debug("executeStatement() exit");
        }
    }

    private void checkAborted(String string) throws JDBCException {
        JDBCException jDBCException = null;
        this.statementState.acquireStatementStateLock();
        if (!this.statementState.isState(2)) {
            if (this.statementState.isState(11)) {
                jDBCException = ErrorFactory.makeDriverJDBCException("TJ057");
            } else if (this.statementState.isState(8)) {
                jDBCException = ErrorFactory.makeDriverJDBCException("TJ159", "StatementState.TIMEOUT " + string);
            }
        }
        this.statementState.releaseStatementStateLock();
        if (jDBCException != null) {
            throw jDBCException;
        }
    }

    public void changeStatementState(int n) throws JDBCException {
        this.statementState.acquireStatementStateLock();
        this.statementState.setState(n);
        this.statementState.releaseStatementStateLock();
    }

    public synchronized void close() throws SQLException {
        boolean bl = false;
        this.internalClose(bl);
    }

    protected void finalize() {
        try {
            boolean bl = true;
            this.internalClose(bl);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public synchronized void internalClose(boolean bl) throws SQLException {
        if (bl) {
            this.m_isFinalized = true;
        }
        if (this.getState() == 0 || this.getState() == 7) {
            return;
        }
        if (this.m_rsOutParams != null) {
            this.m_rsOutParams.close();
        }
        for (int i = 0; i < this.results.getResultsSize(); ++i) {
            if (this.results.getResultType(i) != 2) continue;
            this.results.getResult(i).getResultSet().internalClose(bl);
        }
        if (this.session.isLobSupported()) {
            this.closeRequest(bl);
        }
        this.executingThread = null;
        this.warning = null;
        this.results.reinit();
        this.batch.clear();
        this.m_rsOutParams = null;
        this.changeStatementState(7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeRequest(boolean bl) throws SQLException {
        if (bl) {
            this.m_isFinalized = true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statement.closeRequest: upon entry m_bRequestClosed=" + this.m_bRequestClosed + ", this=" + this);
        }
        if (this.m_bRequestClosed) {
            return;
        }
        this.m_bRequestClosed = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Statement.closeRequest: now m_bRequestClosed=" + this.m_bRequestClosed + ", this=" + this);
        }
        if (!this.useKeepResponse && this.results.requestComplete()) {
            return;
        }
        if (this.session.isClosed()) {
            return;
        }
        StatementController statementController = new StatementController(this, this.session);
        this.log.debug("closeRequest() enter - requesting session lock");
        this.session.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            statementController.setHistoricalState(new StatementCancelState(statementController));
            statementController.setCurrentRequestNumber(this.currentRequestNumber);
            this.log.debug("closeRequest() preparing to send cancel to the server");
            statementController.run();
        }
        finally {
            this.log.debug("closeRequest() exit - releasing the session lock");
            this.session.releaseSessionLock();
        }
    }

    public void suppressResponseCancel() {
        this.m_bRequestClosed = true;
    }

    public synchronized void prepareRequest(String string, int n, byte by) throws SQLException {
        StatementController statementController = new StatementController(this, this.session, string);
        this.executeStatement(statementController, n, by, false);
    }

    public synchronized int executeUpdate(String string) throws SQLException {
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions());
        if (this.generatedKeys != null && this.generatedKeys.returnGeneratedKeys()) {
            this.prepareRequest(string, 3, (byte)80);
            if (!ActivityAnalyzer.update(this.getMetaDataList().getFirstMetaData().getActivityType())) {
                throw ErrorFactory.makeDriverJDBCException("TJ389");
            }
        }
        StatementController statementController = new StatementController(this, this.session, string);
        this.executeStatement(statementController, 1, (byte)69, statementController.usePositioning());
        return this.results.getResult().getUpDateCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeSessionCommand(TDSession tDSession, String string, boolean bl) throws SQLException {
        Statement statement = tDSession.createStatement(1003, 1007);
        if (bl) {
            tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        }
        try {
            StatementController statementController = new StatementController(statement, tDSession, string);
            statementController.setMode((byte)69);
            statementController.setResultTypeExpected(1);
            statement.setUseKeepResponse(false);
            statementController.run();
        }
        finally {
            if (bl) {
                tDSession.releaseSessionLock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResultSet executeQuerySessionCommand(TDSession tDSession, String string, boolean bl) throws SQLException {
        Statement statement = tDSession.createStatement(1003, 1007);
        if (bl) {
            tDSession.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        }
        try {
            StatementController statementController = new StatementController(statement, tDSession, string);
            statementController.setMode((byte)66);
            statementController.setResultTypeExpected(2);
            statement.setUseKeepResponse(false);
            statementController.run();
            ResultSet resultSet = statement.getResults().getResult().getResultSet();
            return resultSet;
        }
        finally {
            if (bl) {
                tDSession.releaseSessionLock();
            }
        }
    }

    public void addWarning(SQLWarning sQLWarning) {
        if (this.warning == null) {
            this.warning = sQLWarning;
        } else {
            this.warning.setNextWarning(sQLWarning);
        }
    }

    public SQLWarning getWarnings() {
        return this.warning;
    }

    public void clearWarnings() {
        this.warning = null;
    }

    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    public void setMaxFieldSize(int n) {
        this.maxFieldSize = n <= 0 ? 0 : n;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setMaxRows(int n) {
        this.maxRows = n <= 0 ? 0 : n;
    }

    public void setEscapeProcessing(boolean bl) {
        this.escapeProcessing = bl;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public boolean isFinalized() {
        return this.m_isFinalized;
    }

    protected void setIsFinalized(boolean bl) {
        this.m_isFinalized = bl;
    }

    public void setQueryTimeout(int n) {
        this.queryTimeout = n;
    }

    public void addBatch(String string) {
        this.batch.add(string);
    }

    public void clearBatch() {
        this.batch.clear();
    }

    public int[] executeBatchMSR(String string, int n) throws SQLException {
        string = EscapeUtil.nativeSQL(string, this.escapeProcessing, this.getLocalEscapeFunctions());
        try {
            StatementController statementController = new StatementController(this, this.session, string);
            this.executeStatement(statementController, 5, (byte)69, false);
        }
        catch (JDBCException jDBCException) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = -3;
            }
            throw ErrorFactory.convertToBatchUpdateException(jDBCException, nArray);
        }
        this.checkResults();
        return this.results.getUpdateArray();
    }

    public void setUseKeepResponse(boolean bl) {
        this.useKeepResponse = bl;
    }

    public boolean useKeepResponse() {
        return this.useKeepResponse;
    }

    public TDSession getConnection() {
        return this.session;
    }

    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    public int getResultSetType() {
        return this.resultSetType;
    }

    public int getFetchDirection() {
        return this.fetchDirection;
    }

    public void setFetchDirection(int n) throws JDBCException {
        switch (n) {
            case 1000: 
            case 1001: 
            case 1002: {
                this.fetchDirection = n;
                return;
            }
        }
        throw ErrorFactory.makeDriverJDBCException("TJ322");
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int n) {
        this.fetchSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() throws SQLException {
        if (this.executingThread != null) {
            this.log.debug("cancel() entered: executing thread is: " + this.executingThread.getName());
        } else {
            this.log.debug("cancel() entered but no active thread");
        }
        this.log.debug("cancel() current statementState is: " + this.statementState.getState());
        this.log.debug("cancel() Thread cancelling the Statement: " + Thread.currentThread().getName());
        this.log.debug("cancel() trying to get statementStateLock");
        this.statementState.acquireStatementStateLock();
        this.log.debug("cancel() have statementStateLock");
        try {
            int n = this.statementState.getState();
            if (n == 12) {
                this.setAbortLobTransfer(true);
                this.log.debug("cancel() setting flag to abort deferred LOB transfer");
            } else if (n == 3) {
                try {
                    this.log.debug("cancel() StatementState is REQUEST_SENT, preparing to send ABORT request to server");
                    StatementController statementController = new StatementController(this, this.session);
                    statementController.setResultTypeExpected(4);
                    statementController.setHistoricalState(new StatementAbortState(statementController));
                    statementController.setCurrentRequestNumber(this.currentRequestNumber);
                    statementController.run();
                }
                catch (SQLException sQLException) {
                    this.log.error("Exception while attempting to cancel statement", sQLException);
                }
            } else if (n == 2) {
                this.log.debug("cancel() StatementState is ACTIVE - changing state to ABORTED");
                this.statementState.setState(11);
                if (this.executingThread != null) {
                    this.log.debug("cancel() Interrupting executingThread: " + this.executingThread.getName());
                    this.executingThread.interrupt();
                }
            } else {
                this.log.debug("cancel() no request to cancel: StatementState is: " + this.statementState.getState());
            }
        }
        finally {
            this.log.debug("cancel() releasing the StatementState lock");
            this.statementState.releaseStatementStateLock();
        }
    }

    public void setCursorName(String string) {
    }

    public int getUpdateCount() throws SQLException {
        if (this.results.moreResults() && (this.results.getResultType() == 1 || this.results.getResultType() == 3)) {
            return this.results.getResult().getUpDateCount();
        }
        return -1;
    }

    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    public boolean getMoreResults(int n) throws SQLException {
        switch (n) {
            case 1: {
                break;
            }
            case 2: {
                if (!this.session.isStatementPositioningSupported()) {
                    throw ErrorFactory.makeDriverJDBCException("TJ549", "getMoreResults(KEEP_CURRENT_RESULT)");
                }
                if (this.getResultSetType() == 1004) break;
                throw ErrorFactory.makeDriverJDBCException("TJ551", "getMoreResults(KEEP_CURRENT_RESULT)");
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ634", n);
            }
        }
        if (n == 1 && this.results.getResultType() == 2) {
            this.results.getResult().getResultSet().close();
        }
        return this.results.getMoreResults() && this.results.getResultType() == 2;
    }

    public void initResults() {
        this.results.reinit();
    }

    public Results getResults() {
        return this.results;
    }

    private void initStatement(boolean bl) throws SQLException {
        if (this.session.isClosed()) {
            throw ErrorFactory.makeDriverJDBCException("TJ188");
        }
        this.log.debug("initStatement()");
        this.close();
        this.useKeepResponse = bl;
        this.statementStartTime = System.currentTimeMillis();
        this.changeStatementState(2);
        this.results.reinit();
        this.warning = null;
        this.m_rsOutParams = null;
        this.currentRequestNumber = 0;
        this.abortLobTransfer = false;
        this.m_bRequestClosed = false;
    }

    public void acquireStatementStateLock() throws JDBCException {
        this.statementState.acquireStatementStateLock();
    }

    public void releaseStatementStateLock() {
        this.statementState.releaseStatementStateLock();
    }

    public void setState(int n) {
        this.statementState.setState(n);
    }

    public int getState() {
        return this.statementState.getState();
    }

    public String toString() {
        return super.toString() + "(statecode=" + this.getState() + " sess=" + this.session + ")";
    }

    public int getRemainingTime() {
        long l = 0L;
        if (this.queryTimeout == 0) {
            return 0;
        }
        long l2 = this.statementStartTime + (long)(this.queryTimeout * 1000);
        long l3 = System.currentTimeMillis();
        if (l2 > l3) {
            l = l2 - l3;
            if (l > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)l;
        }
        return this.queryTimeout * 1000;
    }

    protected void checkResults() throws BatchUpdateException {
        int n = this.results.getResultsSize();
        for (int i = 0; i < n; ++i) {
            if (this.results.getResultType(i) != 2) continue;
            throw ErrorFactory.makeBatchUpdateException("TJ191", this.results.getUpdateArray());
        }
    }

    public void setCurrentRequestNumber(int n) {
        this.currentRequestNumber = n;
    }

    public void setAbortLobTransfer(boolean bl) {
        this.abortLobTransfer = bl;
    }

    public boolean abortLobTransfer() {
        return this.abortLobTransfer;
    }

    public class StatementState {
        private int state = 0;
        private Mutex lock;
        public static final int CREATED = 0;
        public static final int INACTIVE = 1;
        public static final int ACTIVE = 2;
        public static final int REQUEST_SENT = 3;
        public static final int HAVE_RESULTS = 4;
        public static final int CANCEL_SENT = 5;
        public static final int CANCELLED = 6;
        public static final int CLOSED = 7;
        public static final int TIMEOUT = 8;
        public static final int ABORT_TIMEOUT_SENT = 9;
        public static final int ABORT_SENT = 10;
        public static final int ABORTED = 11;
        public static final int LOB_SENDING_DEFERRED = 12;

        StatementState() {
            this.lock = new Mutex("StatementStateLock", Statement.this.log);
        }

        synchronized void setState(int n) {
            this.state = n;
            Statement.this.executingThread = this.state == 2 ? Thread.currentThread() : null;
            if (Statement.this.log.isDebugEnabled()) {
                Statement.this.log.debug("StatementState.setState enclosing instance=" + Statement.this);
            }
        }

        synchronized int getState() {
            return this.state;
        }

        synchronized boolean isState(int n) {
            return this.state == n;
        }

        void acquireStatementStateLock() throws JDBCException {
            this.lock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        }

        void releaseStatementStateLock() {
            this.lock.release();
        }
    }
}

