/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.CurrentThreadIO;
import com.teradata.jdbc.TeraDriver;
import com.teradata.jdbc.URLParameters;
import com.teradata.jdbc.jdbc.ConnectionBase;
import com.teradata.jdbc.jdbc.GenericLogoffController;
import com.teradata.jdbc.jdbc.GenericLogonController;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_3.ifjdbc_4.TeraLocalConnection;
import com.teradata.jdbc.jdbc_4.CallableStatement;
import com.teradata.jdbc.jdbc_4.CreateProcedureStatement;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketPool;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.BigResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.CancelParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResponseParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ConfigController;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import org.ietf.jgss.Oid;

public class TDSession
extends ConnectionBase
implements LocalEscapeFunctions,
GenericTeradataConnection {
    public static final char ANSI_SEMANTICS = 'A';
    public static final char TD_SEMANTICS = 'T';
    public static final char DEFAULT_SEMANTICS = 'D';
    private TDPacketPool packetPool;
    private boolean bAutoCommit = true;
    private boolean m_bUseAnsiDate = true;
    private long requestNum = 1L;
    private boolean connected = false;
    private LogonInformation logonInformation;
    private long authenticationNonce;
    private TDNetworkIOIF io;
    private boolean transactionInProgress;
    private Mutex sessionLock;
    private int lobToken = 0;
    private boolean encryptPassword = false;
    private GenericTeraEncrypt myEncrypt = null;
    private AuthMechanism authMethod;
    private Oid serverDefaultAuthMethodOid;
    private ArrayList serverAuthMechs = new ArrayList();
    private boolean SSOSupported = false;
    private boolean usingClientDefaultMech = false;
    private ConfigRspParcel configRsp;
    private boolean cleanUpStatementsStarted = false;
    private Vector statementList = null;
    private AssignRspParcel assignRsp;
    private boolean UTF_CredentialSupported = false;
    private LogonSequenceNumberParcel logonSeqNumParcel = null;
    private int writableLobId = 1;
    private TeraLocalConnection connection = null;
    private boolean needNewPassword = false;
    private byte m_spReturnResult = 0;
    private long m_defaultConnectionRequestID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TDSession(String string, LogonInformation logonInformation, URLParameters uRLParameters, TeraLocalConnection teraLocalConnection) throws SQLException {
        super(string, uRLParameters);
        Object object;
        this.logonInformation = logonInformation;
        this.connection = teraLocalConnection;
        this.packetPool = TDPacketPool.getInstance();
        this.sessionLock = new Mutex("SessionLock", this.log);
        this.connected = true;
        if (uRLParameters.isJavaSPDefaultConnection()) {
            this.bAutoCommit = false;
            if (this.io == null) {
                object = TeraDriver.getCurrentThreadDefaultConnection();
                this.io = new TDNetworkIOIF(((CurrentThreadIO)object).getOutputStream(), ((CurrentThreadIO)object).getInputStream(), this.log);
            }
            try {
                object = new ConfigController(this);
                ((ConfigController)object).run();
            }
            catch (JDBCException jDBCException) {
                this.connected = false;
                if (this.io != null) {
                    this.io.close();
                }
                throw jDBCException;
            }
            this.m_defaultConnectionRequestID = this.requestNum;
        } else {
            try {
                object = new GenericLogonController(logonInformation, this);
                ((GenericLogonController)object).run();
            }
            catch (JDBCException jDBCException) {
                this.connected = false;
                if (this.io != null) {
                    this.io.close();
                }
                throw jDBCException;
            }
        }
        try {
            if (this.supportsPasswordChange()) {
                object = "MODIFY USER " + this.getLogonInformation().getUserName() + " AS PASSWORD=" + uRLParameters.getNewPassword();
                Statement.executeSessionCommand(this, (String)object, false);
                if (this.isAnsiMode()) {
                    Statement.executeSessionCommand(this, "COMMIT WORK", false);
                }
                this.needNewPassword = false;
            }
            if (this.needNewPassword) {
                return;
            }
            if (uRLParameters.isJavaSPDefaultConnection()) {
                boolean bl;
                ResultSet resultSet = Statement.executeQuerySessionCommand(this, "HELP SESSION", false);
                try {
                    resultSet.next();
                    bl = "ANSI".equals(resultSet.getObject(8));
                }
                finally {
                    resultSet.close();
                }
                uRLParameters.setTransactMode(bl ? "ansi" : "tera");
                if (!this.isAnsiMode()) {
                    boolean bl2 = this.bAutoCommit = !this.transactionInProgress;
                }
            }
            if (uRLParameters.getRunStartup() && !uRLParameters.isJavaSPDefaultConnection()) {
                this.runUserStartup();
            }
            if (uRLParameters.getDatabaseName() != null && uRLParameters.getDatabaseName().length() > 0 && !uRLParameters.getDatabaseName().equals("NO_DEF_DATABASE")) {
                String string2 = "DATABASE " + uRLParameters.getDatabaseName();
                if (this.isAnsiMode()) {
                    string2 = string2 + ";COMMIT WORK";
                }
                Statement.executeSessionCommand(this, string2, false);
            }
        }
        catch (SQLException sQLException) {
            try {
                this.close();
            }
            catch (SQLException sQLException2) {
                sQLException.setNextException(sQLException2);
            }
            throw sQLException;
        }
    }

    private void initPacketForRequest(TDPacket tDPacket, byte by, int n) throws SQLException {
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(by);
        tDPacket.setHostCharSet(this.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.getSessionNum());
        tDPacket.setAuthentication(this.getAuthenticationNonce());
        tDPacket.setRequestNumber(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendAndReceive(TDPacket tDPacket, int n, String string, Integer n2) throws SQLException {
        if (this.getEncryptData() && this.getAuthMethod() != null) {
            tDPacket.setEncrypted();
        }
        tDPacket.toStream();
        this.log.debug(tDPacket.getBuffer());
        this.io.acquireWriteLock();
        try {
            tDPacket.getBuffer().writeStream(this.io, this.getTeraEncrypt(), false);
        }
        finally {
            this.io.releaseWriteLock();
        }
        tDPacket.clear();
        this.io.acquireReadLock();
        try {
            tDPacket.getBuffer().readStream(this.io, this.getTeraEncrypt(), false, n, true);
        }
        finally {
            this.io.releaseReadLock();
        }
        this.log.debug(tDPacket.getBuffer());
        String string2 = this.getCharSet();
        tDPacket.initParcelFactory(string2, this.log);
        this.setTransactionInProgress(tDPacket.inTransaction());
        switch (tDPacket.nextParcelPeek()) {
            case 9: 
            case 49: {
                boolean bl;
                ErrorParcel errorParcel = (ErrorParcel)tDPacket.nextParcel();
                JDBCException jDBCException = ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                if (this.log.canLog(1)) {
                    this.log.info(string + " produced Error or Failure parcel: " + jDBCException);
                }
                boolean bl2 = bl = n2 != null && jDBCException.getErrorCode() == n2.intValue();
                if (bl) {
                    return true;
                }
                throw jDBCException;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runUserStartup() throws SQLException {
        boolean bl;
        TDPacket tDPacket = this.getPacket();
        try {
            Parcel parcel;
            ResponseParcel responseParcel;
            int n = this.getRequestNum();
            this.initPacketForRequest(tDPacket, (byte)5, n);
            String string = this.getCharSet();
            OptionsParcel optionsParcel = new OptionsParcel(string, this);
            optionsParcel.setDBCFunction((byte)69);
            optionsParcel.setReturnStatementInfo(this.isStatementInfoSupported());
            if (this.isLargeDecimalAndBigIntSupported()) {
                optionsParcel.setMaxDecimalPrecision(this.getMaxDecimalPrecision());
            }
            if (this.areAPHResponsesSupported()) {
                optionsParcel.setAPHResponses((byte)89);
            }
            if (this.dynamicResultSetsSupported()) {
                optionsParcel.setDynamicResultSetAllowed(true);
                optionsParcel.setSPReturnResult(this.getSPReturnResult());
            }
            tDPacket.addParcel(optionsParcel);
            tDPacket.getBuffer().putShort((short)2);
            tDPacket.getBuffer().putShort((short)4);
            tDPacket.addToMsgLength(4);
            if (this.areAPHResponsesSupported()) {
                responseParcel = new BigResponseParcel(string, this.log);
                responseParcel.setMaxMsgSize(1048500);
            } else {
                responseParcel = new ResponseParcel(string, this.log);
            }
            tDPacket.addParcel(responseParcel);
            boolean bl2 = this.sendAndReceive(tDPacket, 0, "RUNSTARTUP Execute", new Integer(3747));
            bl = this.isAnsiMode() && this.transactionInProgress;
            boolean bl3 = bl2;
            while (!bl3 && (parcel = tDPacket.nextParcel()) != null) {
                if (!(parcel instanceof EndRequestParcel)) continue;
                bl3 = true;
            }
            if (!bl3) {
                this.initPacketForRequest(tDPacket, (byte)6, n);
                parcel = new CancelParcel(this.log);
                tDPacket.addParcel(parcel);
                this.sendAndReceive(tDPacket, 0, "RUNSTARTUP Continue/Cancel", null);
            }
        }
        finally {
            this.returnPacket(tDPacket);
        }
        if (bl) {
            Statement.executeSessionCommand(this, "COMMIT WORK", false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        if (this.connected) {
            if (this.isJavaSPDefaultConnection()) {
                return;
            }
            this.cleanUpStatements();
            GenericLogoffController genericLogoffController = new GenericLogoffController(this);
            this.log.debug("TDSession.close: logoff waiting for session lock");
            this.acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            try {
                this.log.debug("TDSession.close: acquired session lock, beginning logoff");
                genericLogoffController.run();
                this.io.close();
                if (this.log.isDebugEnabled()) {
                    this.packetPool.getPoolStatistics(this.log);
                }
                Object var3_2 = null;
                this.releaseSessionLock();
                this.log.debug("TDSession.close: logoff complete");
                this.connected = false;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.releaseSessionLock();
                this.log.debug("TDSession.close: logoff complete");
                this.connected = false;
                throw throwable;
            }
        }
    }

    public void setTransactionInProgress(boolean bl) {
        this.transactionInProgress = bl;
    }

    public LocalEscapeFunctions getLocalEscapeFunctions() {
        return this;
    }

    public synchronized int getWritableLobId() {
        if (this.writableLobId < 0) {
            this.writableLobId = 0;
        }
        return this.writableLobId++;
    }

    public String getLobTempTable() {
        return this.urlParams.getLobTempTable();
    }

    public String getLogonSequenceNumber() {
        return this.logonSeqNumParcel == null ? "" : String.valueOf(this.logonSeqNumParcel.getLogonSequenceNumber());
    }

    public String getAMPCount() {
        return this.configRsp == null ? "" : String.valueOf(this.configRsp.getAMPCount());
    }

    public String getLogLevel() {
        return this.getLog().getLogLevel();
    }

    public String setLogLevel(String string) {
        this.getLog().setLogLevel(string);
        return "";
    }

    public String beginCapture() {
        this.getLog().beginCapture();
        return "";
    }

    public String endCapture() {
        return this.getLog().endCapture();
    }

    public boolean shouldSendAnsiDate() {
        return this.isStatementInfoRequestSupported() && this.m_bUseAnsiDate;
    }

    public String useAnsiDate() {
        this.m_bUseAnsiDate = true;
        return "";
    }

    public String useIntegerDate() {
        this.m_bUseAnsiDate = false;
        return "";
    }

    public String getSessionNumber() {
        return this.io != null ? String.valueOf(this.io.getSessionNum()) : "";
    }

    public String getSocketInfo() {
        return this.io != null ? this.io.toString() : "";
    }

    public TDNetworkIOIF getIO() throws JDBCException {
        if (this.io == null) {
            this.io = new TDNetworkIOIF(this);
        }
        return this.io;
    }

    public TDPacket getPacket() {
        return this.packetPool.getTDPacket(this.log);
    }

    public TDPacket getPacket(int n) {
        return this.packetPool.getTDPacket(n, this.log);
    }

    public void returnPacket(TDPacket tDPacket) {
        this.packetPool.returnTDPacket(tDPacket, this.log);
    }

    public int getSessionNum() {
        return this.io.getSessionNum();
    }

    public void setSessionNum(int n) {
        this.io.setSessionNum(n);
    }

    public synchronized int getRequestNum() {
        ++this.requestNum;
        if (this.requestNum == -1L) {
            this.requestNum = 0L;
        }
        return (int)this.requestNum;
    }

    public synchronized int getCurrentRequestNum() {
        return (int)this.requestNum;
    }

    public synchronized void setCurrentRequestNum(int n) {
        this.requestNum = n;
    }

    public boolean getAutoCommit() {
        return this.bAutoCommit;
    }

    public void setAutoCommit(boolean bl) throws SQLException {
        if (this.urlParams.getConnectFunction() == 0) {
            this.commit();
        }
        this.bAutoCommit = bl;
    }

    public void commit() throws SQLException {
        block4: {
            if (this.isAnsiMode()) {
                Statement.executeSessionCommand(this, "COMMIT WORK", true);
            } else {
                try {
                    Statement.executeSessionCommand(this, "ET", true);
                }
                catch (JDBCException jDBCException) {
                    if (jDBCException.getErrorCode() == 3510) break block4;
                    throw jDBCException;
                }
            }
        }
    }

    public boolean isClosed() throws JDBCException {
        return !this.connected;
    }

    public Statement createStatement(int n, int n2) throws JDBCException {
        if (this.connected) {
            return new Statement(this, n, n2, null);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ188");
    }

    public CallableStatement createCallableStatement(String string, int n, int n2) throws SQLException {
        if (this.connected) {
            return new CallableStatement(this, string, n, n2);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ188");
    }

    public PreparedStatement createPreparedStatement(String string, int n, int n2, GeneratedKeys generatedKeys) throws SQLException {
        if (this.connected) {
            return new PreparedStatement(this, string, n, n2, generatedKeys);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ188");
    }

    public CreateProcedureStatement createCreateProcedureStatement(int n, int n2) throws JDBCException {
        if (this.connected) {
            return new CreateProcedureStatement(this, n, n2);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ188");
    }

    public long getAuthenticationNonce() {
        if (++this.authenticationNonce < 0L) {
            this.authenticationNonce = 0L;
        }
        return this.authenticationNonce;
    }

    public void setAuthenticationNonce(long l) {
        this.authenticationNonce = l;
    }

    public void rollBack() throws SQLException {
        block4: {
            try {
                if (this.isAnsiMode()) {
                    Statement.executeSessionCommand(this, "ROLLBACK WORK", true);
                } else {
                    Statement.executeSessionCommand(this, "ABORT", true);
                }
            }
            catch (JDBCException jDBCException) {
                if (jDBCException.getErrorCode() == 3514) break block4;
                throw jDBCException;
            }
        }
    }

    public void beforeExecuteStatement() throws SQLException {
        if (!(this.isAnsiMode() || this.bAutoCommit || this.transactionInProgress)) {
            Statement.executeSessionCommand(this, "BT", false);
        }
    }

    public void afterExecuteStatement() throws SQLException {
        if (this.isAnsiMode() && this.bAutoCommit) {
            Statement.executeSessionCommand(this, "COMMIT WORK", false);
        }
    }

    public void setClosed() {
        this.connected = false;
    }

    public void acquireSessionLock(Mutex.AcquireCallback acquireCallback) throws JDBCException {
        this.sessionLock.acquire(acquireCallback);
    }

    public void releaseSessionLock() {
        this.sessionLock.release();
    }

    public boolean isAphSupported() {
        return this.configRsp.getAPHSupport();
    }

    public boolean isLobSupported() {
        return this.configRsp.getLOBSupport() && this.urlParams.isLobSupported();
    }

    public boolean isPositioningSupported() {
        return this.configRsp.getPositioningSupport();
    }

    public boolean isStatementPositioningSupported() {
        return this.configRsp.getStatementPositioningSupport();
    }

    public boolean areAPHResponsesSupported() {
        return this.configRsp.getAPHResponseSupport();
    }

    public boolean generatedKeysSupported() {
        return this.configRsp.getGeneratedKeysSupport();
    }

    public boolean dynamicResultSetsSupported() {
        return this.configRsp.isDynamicResultSetsSupported();
    }

    public Integer getLobToken() {
        ++this.lobToken;
        return new Integer(this.lobToken);
    }

    public void setEncryptPassword(boolean bl) {
        this.encryptPassword = bl;
    }

    public boolean getEncryptPassword() {
        return this.encryptPassword;
    }

    public void setTeraEncrypt(GenericTeraEncrypt genericTeraEncrypt) {
        this.myEncrypt = genericTeraEncrypt;
    }

    public GenericTeraEncrypt getTeraEncrypt() {
        return this.myEncrypt;
    }

    public AuthMechanism getAuthMethod() {
        return this.authMethod;
    }

    public void setAuthMethod(AuthMechanism authMechanism) {
        this.authMethod = authMechanism;
    }

    public boolean serverHasAuthMechs() {
        return this.serverAuthMechs.size() > 0;
    }

    public LogonInformation getLogonInformation() {
        return this.logonInformation;
    }

    public void setServerDefaultAuthMethodOid(Oid oid) {
        this.serverDefaultAuthMethodOid = oid;
    }

    public Oid getServerDefaultAuthMethodOid() {
        return this.serverDefaultAuthMethodOid;
    }

    public void addServerAuthMech(AuthMechanism authMechanism) {
        this.serverAuthMechs.add(authMechanism);
    }

    public ArrayList getServerAuthMechs() {
        return this.serverAuthMechs;
    }

    public void setSSOSupported(boolean bl) {
        this.SSOSupported = bl;
    }

    public boolean getSSOSupported() {
        return this.SSOSupported;
    }

    public void setUsingClientDefaultMech(boolean bl) {
        this.usingClientDefaultMech = bl;
    }

    public boolean getUsingClientDefaultMech() {
        return this.usingClientDefaultMech;
    }

    public boolean arraySupported() {
        return this.configRsp.getArraySupport();
    }

    public boolean outParamArgSupported() {
        return this.configRsp.getOutParamArgSupport();
    }

    public boolean isLargeDecimalAndBigIntSupported() {
        return this.configRsp.isLargeDecimalAndBigIntSupported();
    }

    public byte getMaxDecimalPrecision() {
        if (this.configRsp.isLargeDecimalAndBigIntSupported()) {
            return 38;
        }
        return 18;
    }

    public boolean isAnsiMode() {
        return this.getTransactionSemantics() == 'A' || this.getTransactionSemantics() == 'D' && this.configRsp.getDefaultTransactionSemantics() == 'A';
    }

    public String getCharSet() {
        if (this.urlParams.getCharset_Xlate_Flag()) {
            return this.urlParams.getJavaEnCoding();
        }
        return this.getSessionJavaCharSet();
    }

    public char getTransactionSemantics() {
        return this.urlParams.getTransactMode().charAt(0);
    }

    public short getMaximumNumberOfSegments() {
        return this.configRsp.getMaximumNumberOfSegments();
    }

    public int getMaximumSegmentSize() {
        return this.configRsp.getMaximumSegmentSize();
    }

    public byte getTdSessionCharSetCode() throws JDBCException {
        return this.configRsp.getTDCharSetCodeFromName(this.urlParams.getCharSet());
    }

    public int getCompatDBS() {
        return this.urlParams.getCompatDBS();
    }

    public int getCompatIsAutoInc() {
        return this.urlParams.getCompatIsAutoInc();
    }

    public int getCompatIsCurrency() {
        return this.urlParams.getCompatIsCurrency();
    }

    public int getCompatIsSigned() {
        return this.urlParams.getCompatIsSigned();
    }

    public int getCompatIsSearch() {
        return this.urlParams.getCompatIsSearch();
    }

    public String getCompatGetSchema() {
        return this.urlParams.getCompatGetSchema();
    }

    public String getCompatGetTable() {
        return this.urlParams.getCompatGetTable();
    }

    public String getlogmech() {
        return this.urlParams.getLogMech();
    }

    public String getlogdata() {
        return this.urlParams.getLogData();
    }

    public boolean getEncryptData() {
        return this.urlParams.getEncryptData();
    }

    public int getCompatIsReadOnly() {
        return this.urlParams.getCompatIsReadOnly();
    }

    public int getCompatIsWritable() {
        return this.urlParams.getCompatIsWritable();
    }

    public int getCompatIsDefWrit() {
        return this.urlParams.getCompatIsDefWrit();
    }

    public ConfigRspParcel getConfigResponse() {
        return this.configRsp;
    }

    public void setConfigResponse(ConfigRspParcel configRspParcel) {
        this.configRsp = configRspParcel;
    }

    public void setLogonSequenceNumberParcel(LogonSequenceNumberParcel logonSequenceNumberParcel) {
        this.logonSeqNumParcel = logonSequenceNumberParcel;
    }

    public void setAssignRspParcel(AssignRspParcel assignRspParcel) {
        this.assignRsp = assignRspParcel;
    }

    public String getTeradataDatabaseVersion() {
        String string;
        String string2;
        if (this.configRsp.getTeradataDatabaseRelease() != null) {
            string2 = this.configRsp.getTeradataDatabaseRelease();
            string = this.configRsp.getTeradataDatabaseVersion();
        } else {
            string2 = this.assignRsp.getDBSRelease();
            string = this.assignRsp.getDBSVersion();
        }
        if (string.startsWith("0")) {
            string = string2.substring(0, 3) + string;
        }
        return "Teradata Database " + string;
    }

    public void setTransactionIsolation(int n) throws JDBCException, SQLException {
        boolean bl;
        String string = null;
        switch (n) {
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ396", n);
            }
        }
        n = this.getMappedTransactionLevel(n);
        switch (n) {
            case 8: {
                string = "SR";
                break;
            }
            case 2: {
                string = "RC";
                break;
            }
            case 1: {
                string = "RU";
                break;
            }
            case 4: {
                string = "RR";
            }
        }
        boolean bl2 = bl = n == this.configRsp.getSupportedTransactionIsolationLevels();
        if (bl) {
            return;
        }
        String string2 = "SET SESSION CHARACTERISTICS AS TRANSACTION ISOLATION LEVEL " + string;
        if (this.isAnsiMode()) {
            string2 = string2 + ";COMMIT WORK";
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Sending: " + string2);
        }
        Statement.executeSessionCommand(this, string2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getTransactionIsolation() throws SQLException {
        ResultSet resultSet = Statement.executeQuerySessionCommand(this, "HELP SESSION", false);
        try {
            if (resultSet.next() && resultSet.getMetaData().getColumnCount() >= 42) {
                String string = String.valueOf(resultSet.getObject(42)).trim();
                if ("SR".equals(string)) {
                    int n = 8;
                    return n;
                }
                if ("RC".equals(string)) {
                    int n = 2;
                    return n;
                }
                if ("RU".equals(string)) {
                    int n = 1;
                    return n;
                }
                if ("RR".equals(string)) {
                    int n = 4;
                    return n;
                }
            }
            int n = this.configRsp.getTransactionIsolationDefault();
            return n;
        }
        finally {
            resultSet.close();
        }
    }

    private int getMappedTransactionLevel(int n) {
        while (n < 8) {
            if ((n & this.configRsp.getSupportedTransactionIsolationLevels()) != 0) {
                return n;
            }
            n *= 2;
        }
        return 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerStatement(Statement statement) {
        if (this.cleanUpStatementsStarted) {
            return false;
        }
        TDSession tDSession = this;
        synchronized (tDSession) {
            if (this.statementList == null) {
                this.statementList = new Vector();
            }
            if (!this.statementList.contains(statement)) {
                this.statementList.addElement(statement);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterStatement(Statement statement) {
        if (this.cleanUpStatementsStarted) {
            return;
        }
        TDSession tDSession = this;
        synchronized (tDSession) {
            if (this.statementList == null) {
                this.statementList = new Vector();
            }
            this.statementList.removeElement(statement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpStatements() throws SQLException {
        TDSession tDSession = this;
        synchronized (tDSession) {
            this.cleanUpStatementsStarted = true;
            if (this.statementList != null) {
                Statement statement;
                Enumeration enumeration = this.statementList.elements();
                while (enumeration.hasMoreElements()) {
                    statement = (Statement)enumeration.nextElement();
                    int n = statement.getState();
                    statement.cancel();
                }
                enumeration = this.statementList.elements();
                while (enumeration.hasMoreElements()) {
                    statement = (Statement)enumeration.nextElement();
                    statement.close();
                }
                this.statementList = null;
            }
        }
    }

    public boolean isCleanUpStatementsStarted() {
        return this.cleanUpStatementsStarted;
    }

    public boolean isUTF_CredentialSupported() {
        return this.UTF_CredentialSupported;
    }

    public void setUTF_CredentialSupported(boolean bl) {
        this.UTF_CredentialSupported = bl;
    }

    public boolean isStatementInfoSupported() {
        return this.configRsp.isStatementInfoSupported() && this.urlParams.sipSupport();
    }

    public boolean isStatementInfoRequestSupported() {
        return this.configRsp.isStatementInfoRequestSupported() && this.urlParams.sipSupport();
    }

    public boolean supportsPasswordChange() {
        return this.needNewPassword && this.urlParams.getNewPassword() != null && this.urlParams.getNewPassword().length() > 0 && !this.urlParams.isJavaSPDefaultConnection();
    }

    public void setNeedNewPassword(boolean bl) {
        this.needNewPassword = bl;
    }

    public TeraLocalConnection getTeraLocalConnection() {
        return this.connection;
    }

    public boolean isJavaSPDefaultConnection() {
        return this.urlParams.isJavaSPDefaultConnection();
    }

    public byte getSPReturnResult() {
        return this.m_spReturnResult;
    }

    public void setSPReturnResult(byte by) {
        this.m_spReturnResult = by;
    }

    public long getConnectionRequestID() {
        return this.m_defaultConnectionRequestID;
    }
}

