/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc_4.Blob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.SQLException;

public class BlobOutputStream
extends OutputStream {
    private Blob blob;

    public BlobOutputStream(Blob blob) {
        this.blob = blob;
    }

    public void close() {
        this.blob = null;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.blob == null) {
            throw new IOException(ErrorMessage.messages.getString("TJ550"));
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            this.blob.writeStream(this.blob.length() + 1L, byteArrayInputStream, n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
        }
    }
}

