/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc_4.Clob;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.SQLException;

public class ClobOutputStream
extends OutputStream {
    private Clob clob;

    public ClobOutputStream(Clob clob) {
        this.clob = clob;
    }

    public void close() {
        this.clob = null;
    }

    public void write(int n) throws IOException {
        this.write(new byte[]{(byte)n});
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.clob == null) {
            throw new IOException(ErrorMessage.messages.getString("TJ550"));
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
            this.clob.writeStream(this.clob.length() + 1L, new InputStreamReader((InputStream)byteArrayInputStream, "ASCII"), n2);
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getErrorCode() + ": " + sQLException);
        }
    }
}

