/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class ConvertSplitScalarFunction
extends ConvertScalarFunction {
    public String processTokens(String string, StringTokenizer stringTokenizer, LocalEscapeFunctions localEscapeFunctions) throws SQLException {
        if ("MOD".equals(string)) {
            return this.createNativeSQL(string, " MOD ", stringTokenizer);
        }
        if ("CONCAT".equals(string)) {
            return this.createNativeSQL(string, " || ", stringTokenizer);
        }
        return null;
    }

    private String createNativeSQL(String string, String string2, StringTokenizer stringTokenizer) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            this.countEscapeTokens(string3);
            if (this.isEndParen(string3)) {
                ++n;
                continue;
            }
            if (this.canICountComma() && ",".equals(string3)) {
                stringBuffer.append(string2);
                continue;
            }
            if (this.addParams) {
                stringBuffer.append(string3);
            }
            if (!this.isStartParen(string3)) continue;
            this.addParams = true;
        }
        if (n != 1) {
            throw ErrorFactory.makeDriverJDBCException("TJ377", string);
        }
        return stringBuffer.toString().trim() + " ";
    }
}

