/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.ComUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeConverter;
import com.teradata.jdbc.jdbc_4.ifsupport.EscapeStringUtil;
import com.teradata.jdbc.jdbc_4.ifsupport.LocalEscapeFunctions;
import com.teradata.jdbc.jdbc_4.ifsupport.ManageEscapeState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class EscapeUtil {
    private String sInput = null;
    private LocalEscapeFunctions localEscFunc = null;
    private Hashtable classTable;
    private ManageEscapeState escapeState = null;
    private String lastToken = null;
    private StringBuffer commentBuffer = null;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction;
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction;

    private EscapeUtil(String string, LocalEscapeFunctions localEscapeFunctions) {
        this.sInput = string;
        this.localEscFunc = localEscapeFunctions;
    }

    public static String nativeSQL(String string, LocalEscapeFunctions localEscapeFunctions) throws SQLException {
        return EscapeUtil.nativeSQL(string, true, localEscapeFunctions);
    }

    public static String nativeSQL(String string, boolean bl, LocalEscapeFunctions localEscapeFunctions) throws SQLException {
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ395", "null");
        }
        string = ComUtil.remLineFeeds(string);
        string = string.trim();
        if (bl) {
            EscapeUtil escapeUtil = new EscapeUtil(string, localEscapeFunctions);
            string = escapeUtil.processString();
        }
        return string;
    }

    public String processScalarFunction(StringTokenizer stringTokenizer) throws SQLException {
        String string = null;
        this.escapeState = new ManageEscapeState();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.ignore(string2)) continue;
            string = this.callEscapeInterface(string2, stringTokenizer, true);
            break;
        }
        if (string == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ383");
        }
        return this.restoreComments(string);
    }

    public String convertToNativeSql(String string) throws SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"'(), \t\n\r\f/*-", true);
        this.escapeState = new ManageEscapeState();
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (this.ignore(string2)) continue;
            if ("FN".equals(string2.toUpperCase())) {
                string = this.processScalarFunction(stringTokenizer);
                break;
            }
            string = this.callEscapeInterface(string2, stringTokenizer);
            break;
        }
        return this.restoreComments(string);
    }

    public String processString() throws SQLException {
        int n;
        String string = this.sInput;
        int n2 = ComUtil.lastIndexOf(string, "{");
        if (n2 == -1 && (n = ComUtil.indexOf(string, "}", n2)) != -1) {
            throw ErrorFactory.makeDriverJDBCException("TJ384");
        }
        while (n2 != -1) {
            n = ComUtil.indexOf(string, "}", n2);
            if (n == -1) {
                throw ErrorFactory.makeDriverJDBCException("TJ384");
            }
            String string2 = string.substring(n2 + 1, n);
            string2 = this.convertToNativeSql(string2);
            boolean bl = n2 == 0 && n + "}".length() == string.length();
            string = EscapeStringUtil.replace(n2, n, string, string2);
            if (bl) break;
            n2 = ComUtil.lastIndexOf(string, "{");
        }
        return string;
    }

    public String callEscapeInterface(String string, StringTokenizer stringTokenizer) throws SQLException {
        return this.callEscapeInterface(string, stringTokenizer, false);
    }

    public String callEscapeInterface(String string, StringTokenizer stringTokenizer, boolean bl) throws SQLException {
        this.initClassTable();
        Class clazz = (Class)this.classTable.get(string.toUpperCase());
        if (clazz != null) {
            Object var5_5 = null;
            try {
                var5_5 = clazz.newInstance();
            }
            catch (Exception exception) {
                throw ErrorFactory.makeDriverJDBCException("TJ157", exception.toString());
            }
            EscapeConverter escapeConverter = var5_5;
            return escapeConverter.processTokens(string.toUpperCase(), stringTokenizer, this.localEscFunc);
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append(string.toUpperCase());
        } else if ("ESCAPE".equals(string.toUpperCase())) {
            stringBuffer.append(string.toUpperCase());
        } else if ("CALL".equals(string.toUpperCase())) {
            stringBuffer.append(string.toUpperCase());
        } else if (!this.validEscape(string)) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", this.sInput);
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return this.addParensForCall(string, stringBuffer.toString());
    }

    private boolean validEscape(String string) {
        if ("OJ".equals(string.toUpperCase())) {
            return true;
        }
        if ("ESCAPE".equals(string.toUpperCase())) {
            return true;
        }
        return "CALL".equals(string.toUpperCase());
    }

    private void initClassTable() {
        if (this.classTable == null) {
            this.classTable = new Hashtable();
            this.classTable.put("T", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals);
            this.classTable.put("D", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals);
            this.classTable.put("TS", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertDateTimeLiterals")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertDateTimeLiterals);
            this.classTable.put("SECOND", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("PI", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("MOD", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSplitScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction);
            this.classTable.put("LENGTH", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("LOCATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSwitchArgsScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction);
            this.classTable.put("ATAN2", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSwitchArgsScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSwitchArgsScalarFunction);
            this.classTable.put("LTRIM", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("RTRIM", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("LCASE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("UCASE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("SUBSTRING", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSubStringScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSubStringScalarFunction);
            this.classTable.put("CONCAT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertSplitScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertSplitScalarFunction);
            this.classTable.put("CURDATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("CURTIME", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("NOW", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("MINUTE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("HOUR", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("DAYOFMONTH", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("WEEK", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("MONTH", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("YEAR", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("TIMESTAMPADD", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertTimestampAddScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampAddScalarFunction);
            this.classTable.put("TIMESTAMPDIFF", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertTimestampDiffScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertTimestampDiffScalarFunction);
            this.classTable.put("DATABASE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("USER", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("IFNULL", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertIfNullScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertIfNullScalarFunction);
            this.classTable.put("CONVERT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertCastScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertCastScalarFunction);
            this.classTable.put("TERADATA_LOGON_SEQUENCE_NUMBER", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_AMP_COUNT", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_GETLOGLEVEL", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_SETLOGLEVEL", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertScalarFunction);
            this.classTable.put("TERADATA_BEGINCAPTURE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_ENDCAPTURE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_USEANSIDATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_USEINTEGERDATE", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_SESSION_NUMBER", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
            this.classTable.put("TERADATA_SOCKET_INFO", class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction == null ? (class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction = EscapeUtil.class$("com.teradata.jdbc.jdbc_4.ifsupport.ConvertNoArgScalarFunction")) : class$com$teradata$jdbc$jdbc_4$ifsupport$ConvertNoArgScalarFunction);
        }
    }

    private String addParensForCall(String string, String string2) {
        if (!"CALL".equals(string.toUpperCase())) {
            return string2;
        }
        if (ComUtil.lastIndexOf(string2, ")") == -1) {
            int n = string2.length() - 1;
            string2 = string2.charAt(n) == ';' ? string2.substring(0, n).concat("()") : string2.concat("()");
        }
        return string2;
    }

    private boolean ignore(String string) throws SQLException {
        if (" \t\n\r\f".indexOf(string) != -1) {
            return true;
        }
        boolean bl = true;
        this.escapeState.setManageEscapeState(string, bl);
        if (!this.escapeState.inEscapeState() && "/-".indexOf(string) != -1) {
            this.lastToken = string;
            this.commentBuffer = new StringBuffer(string);
            return true;
        }
        if (!this.escapeState.inEscapeState() && this.lastToken != null) {
            throw ErrorFactory.makeDriverJDBCException("TJ385", this.lastToken);
        }
        this.lastToken = null;
        if (this.escapeState.inEscapeState()) {
            this.commentBuffer.append(string);
        }
        return this.escapeState.inEscapeState();
    }

    private String restoreComments(String string) {
        if (this.commentBuffer != null) {
            string = this.commentBuffer.toString() + " " + string;
            this.commentBuffer = null;
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

