/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.interfaces.Lob;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.ParameterSet;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.statemachine.LobReceiveController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementCancelState;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import java.sql.SQLException;
import java.util.HashMap;

public class LobStatement
extends PreparedStatement {
    protected static final int LOBLENGTH = 2097088000;
    private ParameterProperties paramProperties = null;
    LobReceiveController controller;
    boolean updateLobReq;

    public LobStatement(TDSession tDSession) throws SQLException {
        super(tDSession, null, 1003, 1007, null);
        this.updateLobReq = false;
    }

    public LobStatement(TDSession tDSession, String string) throws SQLException {
        super(tDSession, string, 1003, 1007, null);
        this.updateLobReq = true;
    }

    public void lobRequest(String string, byte[] byArray, short s, LobStream lobStream) throws SQLException {
        ParameterSet parameterSet = this.initParameterProperties(1);
        this.setParameterWithPrefixLength(parameterSet, 1, s, byArray, 2097088000);
        this.setParameterProperties(this.paramProperties);
        if (this.controller != null) {
            this.close();
        }
        try {
            this.controller = new LobReceiveController(this, this.getConnection(), string, lobStream);
            this.controller.setLobSelect((byte)73);
            this.executeStatement(this.controller, 2, (byte)69);
        }
        catch (JDBCException jDBCException) {
            this.controller = null;
            throw jDBCException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lobContinue() throws SQLException {
        switch (this.getState()) {
            case 7: {
                throw ErrorFactory.makeDriverJDBCException("TJ360");
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                throw ErrorFactory.makeDriverJDBCException("TJ057");
            }
        }
        this.getConnection().acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
        try {
            this.controller.run();
        }
        finally {
            this.getConnection().releaseSessionLock();
        }
    }

    public void updateLob(String string, byte[] byArray, short s) throws SQLException {
        ParameterSet parameterSet = this.initParameterProperties(1);
        this.setParameterWithPrefixLength(parameterSet, 1, s, byArray, 2097088000);
        this.setParameterProperties(this.paramProperties);
        this.executeUpdate(string);
    }

    public void updateLob(String string, byte[] byArray, short s, byte[] byArray2, int n) throws SQLException {
        ParameterSet parameterSet = this.initParameterProperties(3);
        this.setParameterWithPrefixLength(parameterSet, 1, s, byArray, 2097088000);
        this.setParameterWithPrefixLength(parameterSet, 2, n, byArray2, byArray2.length);
        this.setParameterWithPrefixLength(parameterSet, 3, s, byArray, 2097088000);
        this.setParameterProperties(this.paramProperties);
        this.executeUpdate(string);
    }

    public void updateLob(String string, byte[] byArray, short s, Lob lob, Integer n, int n2) throws SQLException {
        ParameterSet parameterSet = this.initParameterProperties(2);
        HashMap<Integer, Lob> hashMap = new HashMap<Integer, Lob>(1);
        hashMap.put(n, lob);
        parameterSet.setDeferredLobs(hashMap);
        this.setParameterWithPrefixLength(parameterSet, 1, s, byArray, 2097088000);
        this.setParameterDirect(parameterSet, 2, n2, ByteConverter.putInt(n), 2097088000);
        this.setParameterProperties(this.paramProperties);
        this.executeUpdate(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void internalClose(boolean bl) throws SQLException {
        if (this.updateLobReq) {
            super.internalClose(bl);
            return;
        }
        if (bl) {
            this.setIsFinalized(true);
        }
        int n = this.getState();
        this.log.debug("Closing the lob statement, state is: " + n);
        switch (n) {
            case 0: 
            case 7: {
                return;
            }
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                return;
            }
            case 1: {
                if (this.controller != null) break;
                this.setState(7);
                return;
            }
            case 2: 
            case 3: {
                this.cancel();
            }
        }
        if (this.getState() != 11) {
            this.getConnection().acquireSessionLock(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
            try {
                this.acquireStatementStateLock();
                try {
                    this.controller.setHistoricalState(new StatementCancelState(this.controller));
                    this.controller.run();
                }
                finally {
                    this.setState(7);
                    this.releaseStatementStateLock();
                }
            }
            finally {
                this.controller.getSession().releaseSessionLock();
            }
        }
    }

    private ParameterSet initParameterProperties(int n) {
        this.paramProperties = new ParameterProperties(n);
        ParameterSet parameterSet = new ParameterSet(n, this.paramProperties);
        this.paramProperties.addParameterSet(parameterSet);
        byte[] byArray = new byte[]{0};
        parameterSet.setNullIndicatorBits(byArray);
        return parameterSet;
    }

    private void setParameterWithPrefixLength(ParameterSet parameterSet, int n, int n2, byte[] byArray, int n3) throws JDBCException {
        byte[] byArray2 = new byte[byArray.length + 2];
        ByteConverter.putShort(byArray2, 0, (short)byArray.length);
        System.arraycopy(byArray, 0, byArray2, 2, byArray.length);
        this.setParameterDirect(parameterSet, n, n2, byArray2, n3);
    }

    private void setParameterDirect(ParameterSet parameterSet, int n, int n2, byte[] byArray, int n3) throws JDBCException {
        parameterSet.setParameter(n, byArray, byArray, n2, false, 0, 0);
        this.paramProperties.setDataInfoField(n, n2, n3, 0, 0, 0, true);
    }
}

