/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.ifsupport;

import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.LobBuffer;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStatement;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class LobStream
extends InputStream {
    private TDSession session;
    protected LobBuffer lobData = null;
    private short lobLocatorType;
    protected long totalLength = 0L;
    protected long amountRead = 0L;
    byte[] locator;
    protected LobStatement lobStmt;

    public LobStream(byte[] byArray, long l, TDSession tDSession, short s) {
        this.lobLocatorType = s;
        this.locator = byArray;
        this.totalLength = l;
        this.session = tDSession;
    }

    public synchronized int read() throws IOException {
        try {
            this.initStream();
            int n = this.lobData.nextByte();
            ++this.amountRead;
            return n;
        }
        catch (SQLException sQLException) {
            throw new IOException(sQLException.getMessage());
        }
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        try {
            this.initStream();
            n3 = this.lobData.read(byArray, n, n2);
            if (n3 != -1) {
                this.amountRead += (long)n3;
            }
        }
        catch (SQLException sQLException) {
            IOException iOException = new IOException(sQLException.toString());
            iOException.initCause(sQLException);
            throw iOException;
        }
        return n3;
    }

    public synchronized int available() {
        return (int)this.getAvailable();
    }

    public void close() throws IOException {
        if (this.lobData != null) {
            try {
                this.lobData.close();
            }
            catch (SQLException sQLException) {
                IOException iOException = new IOException(sQLException.toString());
                iOException.initCause(sQLException);
                throw iOException;
            }
            this.lobData = null;
        }
    }

    protected void initStream() throws SQLException {
        String string = "Select ?";
        if (this.lobData == null) {
            if (this.session != null) {
                this.lobStmt = new LobStatement(this.session);
                this.lobStmt.lobRequest(string, this.locator, this.lobLocatorType, this);
                if (this.lobData.lobLength() == 0) {
                    this.lobData.setEndOfFile();
                    this.lobData.setEndOfData();
                }
            } else {
                throw ErrorFactory.makeDriverJDBCException("TJ312", this.getClass().getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getBytes(long l, int n) throws SQLException {
        String string = "Select substr(?," + l + "," + n + ")";
        if (this.session != null) {
            this.lobStmt = new LobStatement(this.session);
            this.lobStmt.lobRequest(string, this.locator, this.lobLocatorType, this);
            n = this.lobData.lobLength();
            byte[] byArray = new byte[n];
            try {
                this.lobData.read(byArray, 0, n);
            }
            finally {
                this.lobData.close();
            }
            this.lobData = null;
            return byArray;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ312", this.getClass().getName());
    }

    public void setBuffer(LobBuffer lobBuffer) {
        this.lobData = lobBuffer;
    }

    public void setLength(long l) {
        this.totalLength = l;
    }

    public long getTotalLength() {
        return this.totalLength;
    }

    public synchronized long getAvailable() {
        return this.totalLength - this.amountRead;
    }
}

