/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.io.BufferContainer;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.Mutex;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TDNetworkIOIF {
    private String m_sOriginalHostName;
    private Socket socket = null;
    private OutputStream outStream;
    private InputStream inStream;
    private Mutex readLock;
    private Mutex writeLock;
    private int sessionNum;
    private final String m_sConnectionID = Integer.toHexString(System.identityHashCode(this));
    protected Log log;
    private static Map sm_mapConnectFailures = Collections.synchronizedMap(new HashMap());
    private static Map sm_map = new HashMap();
    private static final int GET_TCP_KEEPALIVE = 1;
    private static final int GET_TCP_NODELAY = 2;
    private static final int GET_TCP_RECEIVE = 3;
    private static final int GET_TCP_SEND = 4;
    private static final int GET_TCP_LINGER = 5;
    private static final int GET_TCP_TRAFFIC = 6;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TDNetworkIOIF(GenericTeradataConnection genericTeradataConnection) throws JDBCException {
        String string;
        this.log = genericTeradataConnection.getLog();
        this.m_sOriginalHostName = string = genericTeradataConnection.getMachineName();
        boolean bl = true;
        try {
            try {
                String string2 = genericTeradataConnection.getURLParameters().getCopDiscovery() ? "cop" : null;
                this.socket = TDNetworkIOIF.connectToHost(genericTeradataConnection, string2);
                this.outStream = this.socket.getOutputStream();
                this.inStream = this.socket.getInputStream();
                this.readLock = new Mutex("IO ReadLock", this.log);
                this.writeLock = new Mutex("IO WriteLock", this.log);
                bl = false;
            }
            catch (Throwable throwable) {
                throw ErrorAnalyzer.analyzeIoError("Connection to " + string, this, throwable, false, false);
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            try {
                if (!bl) throw throwable;
                if (this.socket == null) throw throwable;
                this.socket.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (!bl) return;
        if (this.socket == null) return;
        this.socket.close();
        return;
    }

    public TDNetworkIOIF(OutputStream outputStream, InputStream inputStream, Log log) throws JDBCException {
        this.log = log;
        this.outStream = outputStream;
        this.inStream = inputStream;
        this.socket = null;
        this.readLock = new Mutex("IO ReadLock", log);
        this.writeLock = new Mutex("IO WriteLock", log);
    }

    private static int randomNumber(int n, int n2) {
        int n3 = n2 - n + 1;
        return (int)(Math.random() * (double)n3) % n3 + n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Socket connectToHost(GenericTeradataConnection genericTeradataConnection, String string) throws IOException, JDBCException {
        Object object;
        Object object2;
        int n;
        Lookup lookup;
        String[] stringArray;
        Integer n2;
        int n3;
        boolean bl;
        int n4;
        int n5;
        boolean bl2;
        boolean bl3;
        Log log;
        long l;
        int n6;
        String string2;
        block36: {
            string2 = genericTeradataConnection.getMachineName();
            n6 = genericTeradataConnection.getMachinePort();
            l = genericTeradataConnection.getURLParameters().getConnectFailureTTL();
            log = genericTeradataConnection.getLog();
            bl3 = false;
            bl2 = false;
            n5 = 65156;
            n4 = 65156;
            bl = true;
            n3 = 10;
            n2 = null;
            String string3 = genericTeradataConnection.getURLParameters().getTCP();
            if (string3 != null) {
                stringArray = string3.toUpperCase().trim().split("[+]");
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("KEEPALIVE")) {
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[i].equals("NODELAY")) {
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[i].startsWith("RECEIVE")) {
                        n5 = Integer.parseInt(stringArray[i].substring("RECEIVE".length()));
                        continue;
                    }
                    if (stringArray[i].startsWith("SEND")) {
                        n4 = Integer.parseInt(stringArray[i].substring("SEND".length()));
                        continue;
                    }
                    if (stringArray[i].equals("NOLINGER")) {
                        bl = false;
                        continue;
                    }
                    if (stringArray[i].startsWith("LINGER")) {
                        n3 = Integer.parseInt(stringArray[i].substring("LINGER".length()));
                        continue;
                    }
                    if (!stringArray[i].startsWith("TRAFFIC")) continue;
                    n2 = new Integer(stringArray[i].substring("TRAFFIC".length()));
                }
            }
            stringArray = new ArrayList();
            lookup = new Lookup(genericTeradataConnection, string2);
            if (lookup.isLiteralIpAddress()) {
                stringArray.add(lookup.getAddresses());
            } else if (string != null) {
                n = string2.indexOf(46);
                object2 = n < 0 ? string2 : string2.substring(0, n);
                object = n < 0 ? "" : string2.substring(n);
                try {
                    int n7 = 1;
                    while (true) {
                        String string4 = (String)object2 + string + n7 + (String)object;
                        stringArray.add(new Lookup(genericTeradataConnection, string4).getAddresses());
                        ++n7;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    if (log.isDebugEnabled()) {
                        log.debug("TDNetworkIOIF.connectToHost: caught " + unknownHostException);
                    }
                }
                catch (SecurityException securityException) {
                    if (!log.isDebugEnabled()) break block36;
                    log.debug("TDNetworkIOIF.connectToHost: caught " + securityException);
                }
            }
        }
        if (stringArray.size() == 0) {
            stringArray.add(lookup.getAddresses());
        }
        n = TDNetworkIOIF.randomNumber(0, stringArray.size() - 1);
        object2 = sm_map;
        synchronized (object2) {
            object = (Integer)sm_map.get(string2);
            if (object != null) {
                n = ((Integer)object + 1) % stringArray.size();
            }
            sm_map.put(string2, new Integer(n));
        }
        Collections.rotate(stringArray, -n);
        if (log.isDebugEnabled()) {
            log.debug("Before connect loop: sm_mapConnectFailures=" + sm_mapConnectFailures);
        }
        object2 = null;
        for (int i = 0; i < stringArray.size(); ++i) {
            InetAddress[] inetAddressArray = (InetAddress[])stringArray.get(i);
            for (int j = 0; j < inetAddressArray.length; ++j) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddressArray[j], n6);
                int n8 = genericTeradataConnection.checkRemainingLoginTime();
                long l2 = System.currentTimeMillis();
                Date date = (Date)sm_mapConnectFailures.get(inetSocketAddress);
                if (date != null) {
                    boolean bl4;
                    long l3 = date.getTime();
                    boolean bl5 = bl4 = l3 <= l2;
                    if (bl4) {
                        boolean bl6;
                        long l4 = l3 + l * 1000L;
                        boolean bl7 = bl6 = l2 < l4;
                        if (bl6) {
                            if (log.canLog(2)) {
                                log.timing("Fail-fast connection attempt skipped due to failure at " + date + ", " + inetSocketAddress + " will become usable at " + new Date(l4));
                            }
                            continue;
                        }
                    }
                }
                try {
                    Socket socket;
                    block37: {
                        Socket socket2 = new Socket();
                        socket2.setKeepAlive(bl3);
                        socket2.setTcpNoDelay(bl2);
                        socket2.setReceiveBufferSize(n5);
                        socket2.setSendBufferSize(n4);
                        socket2.setSoLinger(bl, n3);
                        if (n2 != null) {
                            socket2.setTrafficClass(n2);
                        }
                        socket2.connect(inetSocketAddress, n8);
                        socket = socket2;
                        {
                            Object var34_39 = null;
                            if (!log.canLog(2)) break block37;
                            log.timing("Connection attempt to " + inetSocketAddress + " took " + (System.currentTimeMillis() - l2) + " ms");
                        }
                    }
                    return socket;
                }
                catch (Throwable throwable) {
                    try {
                        Object var34_40 = null;
                        if (log.canLog(2)) {
                            log.timing("Connection attempt to " + inetSocketAddress + " took " + (System.currentTimeMillis() - l2) + " ms");
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        sm_mapConnectFailures.put(inetSocketAddress, new Date());
                        object2 = iOException;
                    }
                }
            }
        }
        if (object2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ635", String.valueOf(l));
        }
        throw object2;
    }

    public String toString() {
        boolean bl = this.m_sOriginalHostName == null;
        return (bl ? "jdbc:default:connection" : "socket orig=" + this.m_sOriginalHostName) + (this.socket != null ? " local=" + this.socket.getLocalAddress() + ":" + this.socket.getLocalPort() + " remote=" + this.socket.getInetAddress() + ":" + this.socket.getPort() + " keepalive=" + this.getTcpOption(1) + " nodelay=" + this.getTcpOption(2) + " receive=" + this.getTcpOption(3) + " send=" + this.getTcpOption(4) + " linger=" + this.getTcpOption(5) + " traffic=" + this.getTcpOption(6) : "") + " cid=" + this.m_sConnectionID + " sess=" + this.sessionNum;
    }

    private String getTcpOption(int n) {
        try {
            switch (n) {
                case 1: {
                    return String.valueOf(this.socket.getKeepAlive());
                }
                case 2: {
                    return String.valueOf(this.socket.getTcpNoDelay());
                }
                case 3: {
                    return String.valueOf(this.socket.getReceiveBufferSize());
                }
                case 4: {
                    return String.valueOf(this.socket.getSendBufferSize());
                }
                case 5: {
                    return String.valueOf(this.socket.getSoLinger());
                }
                case 6: {
                    return String.valueOf(this.socket.getTrafficClass());
                }
            }
            throw new IllegalArgumentException("Invalid value specified for nDesiredOption");
        }
        catch (SocketException socketException) {
            return "unavailable";
        }
    }

    public String getOriginalHostName() {
        return this.m_sOriginalHostName;
    }

    public InetAddress getRemoteAddress() {
        return this.socket != null ? this.socket.getInetAddress() : null;
    }

    public int getRemotePort() {
        return this.socket != null ? this.socket.getPort() : 0;
    }

    public String getConnectionID() {
        return this.m_sConnectionID;
    }

    public int getSessionNum() {
        return this.sessionNum;
    }

    public void setSessionNum(int n) {
        this.sessionNum = n;
    }

    public int read(BufferContainer bufferContainer, int n, boolean bl) throws IOException {
        if (this.socket != null) {
            this.socket.setSoTimeout(n);
        }
        int n2 = 0;
        long l = System.currentTimeMillis();
        byte[] byArray = bufferContainer.getBuffer();
        int n3 = 1;
        while (true) {
            Object var15_11;
            int n4 = 0;
            try {
                int n5;
                boolean bl2;
                boolean bl3;
                int n6;
                while (n2 < 52 && (n6 = this.inStream.read(byArray, n2, 52 - n2)) != -1) {
                    n2 += n6;
                }
                if (n2 < 52) {
                    if (!bl) {
                        this.log.error("Read message " + n3 + ": Incomplete LAN message header: read " + n2 + " bytes");
                        if (n2 > 0) {
                            this.log.debugPartialByteArray("Incomplete response message header", byArray, 0, n2);
                        }
                    }
                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ324"), n2));
                }
                n6 = (UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 3)) << 16) + UnsignedConversions.convertUnsignedShort(ByteConverter.getShort(byArray, 8));
                n4 = 52 + n6;
                boolean bl4 = bl3 = n4 > byArray.length && n4 <= 2097104;
                if (bl3) {
                    byte[] byArray2 = new byte[n4];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    if (this.log.canLog(1)) {
                        this.log.info("Read message " + n3 + ": resizing buffer from " + byArray.length + " bytes to " + byArray2.length + " bytes");
                    }
                    byArray = byArray2;
                    bufferContainer.setBuffer(byArray);
                }
                boolean bl5 = bl2 = n4 > byArray.length;
                if (bl2) {
                    this.log.error("Read message " + n3 + ": Bad response message header with invalid message length of " + n4 + " bytes");
                    this.log.debugPartialByteArray("Bad response message header message dump", byArray, 0, 52);
                    throw new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ325"), n4));
                }
                while (n2 < n4 && (n5 = this.inStream.read(byArray, n2, n4 - n2)) != -1) {
                    n2 += n5;
                }
                if (this.socket != null) {
                    this.socket.setSoTimeout(0);
                }
                n5 = n2;
                var15_11 = null;
                if (this.log.canLog(2)) {
                    this.log.timing("Read message " + n3 + ", " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                }
                return n5;
            }
            catch (IOException iOException) {
                try {
                    block29: {
                        if (iOException instanceof SocketException && iOException.getMessage().equals("Read timed out") || iOException instanceof InterruptedIOException) {
                            if (!bl) {
                                this.log.error("Read message " + n3 + ", " + n2 + (n4 > 0 ? " of " + n4 : "") + " bytes, timed out: " + iOException);
                                if (n2 > 0) {
                                    this.log.debugPartialByteArray("Timed out message header message dump", byArray, 0, Math.min(n2, 52));
                                }
                            }
                            if (n2 > 0) {
                                if (n3 < 2) {
                                    var15_11 = null;
                                    if (this.log.canLog(2)) {
                                        this.log.timing("Read message " + n3 + ", " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                                    }
                                }
                                if (!bl) {
                                    this.log.error("Read message " + n3 + " timed out after partial read; closing socket due to: " + iOException);
                                }
                                this.close();
                                IOException iOException2 = new IOException(ErrorMessage.Format1(ErrorMessage.messages.getString("TJ625"), n2));
                                iOException2.initCause(iOException);
                                throw iOException2;
                            }
                            try {
                                if (this.socket != null) {
                                    this.socket.setSoTimeout(0);
                                }
                                break block29;
                            }
                            catch (IOException iOException3) {
                                if (!bl) {
                                    this.log.error("Read message " + n3 + " reset socket timeout failed: " + iOException3);
                                }
                                break block29;
                            }
                        }
                        if (!bl) {
                            this.log.error("Read message " + n3 + " failed; closing socket due to: " + iOException);
                        }
                        this.close();
                    }
                    throw iOException;
                }
                catch (Throwable throwable) {
                    var15_11 = null;
                    if (this.log.canLog(2)) {
                        this.log.timing("Read message " + n3 + ", " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
                    }
                    throw throwable;
                }
            }
            ++n3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray) throws IOException {
        if (this.log.canLog(0)) {
            this.log.debug("writing " + byArray.length + " bytes");
        }
        long l = System.currentTimeMillis();
        try {
            this.outStream.write(byArray);
            this.outStream.flush();
            Object var5_3 = null;
            if (this.log.canLog(2)) {
                this.log.timing("Wrote " + byArray.length + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (this.log.canLog(2)) {
                this.log.timing("Wrote " + byArray.length + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.log.canLog(0)) {
            this.log.debug("writing " + n2 + " bytes");
        }
        long l = System.currentTimeMillis();
        try {
            this.outStream.write(byArray, n, n2);
            this.outStream.flush();
            Object var7_5 = null;
            if (this.log.canLog(2)) {
                this.log.timing("Wrote " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (this.log.canLog(2)) {
                this.log.timing("Wrote " + n2 + " bytes, time: " + (System.currentTimeMillis() - l) + " ms");
            }
            throw throwable;
        }
    }

    public void close() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void acquireReadLock() throws JDBCException {
        this.readLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    public void acquireWriteLock() throws JDBCException {
        this.writeLock.acquire(Mutex.IGNORE_INTERRUPT_AND_NO_TIMEOUT);
    }

    public void releaseReadLock() {
        this.readLock.release();
    }

    public void releaseWriteLock() {
        this.writeLock.release();
    }

    public Log getLog() {
        return this.log;
    }

    public static class Lookup {
        private InetAddress[] m_aAddrs;
        private UnknownHostException m_exUnk;
        private SecurityException m_exSec;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Lookup(GenericTeradataConnection genericTeradataConnection, String string) throws JDBCException {
            block9: {
                this.m_aAddrs = null;
                this.m_exUnk = null;
                this.m_exSec = null;
                genericTeradataConnection.checkRemainingLoginTime();
                long l = System.currentTimeMillis();
                try {
                    try {
                        this.m_aAddrs = InetAddress.getAllByName(string);
                    }
                    catch (UnknownHostException unknownHostException) {
                        this.m_exUnk = unknownHostException;
                        Object var7_5 = null;
                        if (genericTeradataConnection.getLog().canLog(2)) {
                            genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                        break block9;
                    }
                    catch (SecurityException securityException) {
                        this.m_exSec = securityException;
                        Object var7_6 = null;
                        if (genericTeradataConnection.getLog().canLog(2)) {
                            genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                        }
                    }
                    Object var7_4 = null;
                    if (genericTeradataConnection.getLog().canLog(2)) {
                        genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (genericTeradataConnection.getLog().canLog(2)) {
                        genericTeradataConnection.getLog().timing("Hostname lookup for " + string + " took " + (System.currentTimeMillis() - l) + " ms and " + (this.m_aAddrs != null ? "found " + this.m_aAddrs.length + " address(es)" : "failed"));
                    }
                    throw throwable;
                }
            }
        }

        public boolean isLiteralIpAddress() {
            return this.m_aAddrs != null && this.m_aAddrs.length > 0 && this.m_aAddrs[0].toString().startsWith("/");
        }

        public InetAddress[] getAddresses() throws UnknownHostException, SecurityException {
            if (this.m_exUnk != null) {
                throw this.m_exUnk;
            }
            if (this.m_exSec != null) {
                throw this.m_exSec;
            }
            return this.m_aAddrs;
        }
    }
}

