/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.jdbc_4.io.LanHeader;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ParcelFactory;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class TDPacket {
    private Parcel lnkParcel;
    private LanHeader lanHeader = new LanHeader();
    private TDPacketStream buffer;
    private ParcelFactory parcelFactory;

    public TDPacket(int n) {
        this.buffer = new TDPacketStream(n);
    }

    public void setBuffer(TDPacketStream tDPacketStream) {
        this.buffer = tDPacketStream;
    }

    public TDPacketStream getBuffer() {
        return this.buffer;
    }

    public void newLanHeader() {
        this.lanHeader = new LanHeader();
    }

    public void addToMsgLength(int n) {
        this.lanHeader.addToMsgLength(n);
    }

    public void setInitParcelPosition() {
        this.buffer.position(52);
    }

    public void addParcel(Parcel parcel) throws JDBCException {
        this.buffer.putStream(parcel.toStream());
        int n = parcel.getLength();
        this.lanHeader.addToMsgLength(n);
    }

    public void initParcelFactory(String string, Log log) throws SQLException {
        if (this.parcelFactory == null) {
            this.parcelFactory = new ParcelFactory(log, string);
        } else {
            this.parcelFactory.setCharSetName(string);
        }
        this.lanHeader = new LanHeader(this.buffer);
        this.setInitParcelPosition();
        this.parcelFactory.setTDPacket(this);
    }

    public void setParcelFactoryPrepInfo(PrepInfoParcel prepInfoParcel) {
        this.parcelFactory.setPrepInfo(prepInfoParcel);
    }

    public PrepInfoParcel getParcelFactoryPrepInfo() {
        return this.parcelFactory.getPrepInfo();
    }

    public Parcel nextParcel() throws SQLException {
        return this.parcelFactory.nextParcel();
    }

    public Parcel scanForEndParcel(boolean bl) throws SQLException {
        return this.parcelFactory.scanForEndStatementParcel(bl);
    }

    public int nextParcelPeek() throws SQLException {
        return this.parcelFactory.nextParcelPeek();
    }

    public int getCurrentPosition() {
        return this.parcelFactory.getCurrentPosition();
    }

    public void skipParcel(int n) {
        this.parcelFactory.skipParcel(n);
    }

    public TDPacketStream toStream() throws JDBCException {
        this.buffer.position(0);
        this.buffer.putStream(this.lanHeader.toStream());
        this.buffer.position(0);
        this.buffer.limit(52 + this.lanHeader.getMsgLength());
        return this.buffer;
    }

    public int getLanMsgLength() {
        return this.lanHeader.getMsgLength();
    }

    public int getLANSessionNumber() {
        return this.lanHeader.getSessionNo();
    }

    public void setLANClass(byte by) {
        this.lanHeader.setMsgType(by);
    }

    public void setLANKind(byte by) {
        this.lanHeader.setKind(by);
    }

    public int getRequestNumber() {
        return this.lanHeader.getRequestNo();
    }

    public void setByteVar(byte by) {
        this.lanHeader.setByteVar(by);
    }

    public void setSessionNumber(int n) {
        this.lanHeader.setSessionNo(n);
    }

    public void setRequestNumber(int n) {
        this.lanHeader.setRequestNo(n);
    }

    public void setHostCharSet(byte by) {
        this.lanHeader.setHostCharSet(by);
    }

    public byte getHostCharSet() {
        return this.lanHeader.getHostCharSet();
    }

    public void setAuthentication(long l) {
        this.lanHeader.setAuthentication(l);
    }

    public long getAuthentication() {
        return ByteConverter.getLong(this.lanHeader.getAuthentication(), 0);
    }

    public void clear() {
        this.buffer.clear();
    }

    public boolean getEncryption() {
        return this.lanHeader.getEncryption();
    }

    public void setEncrypted() {
        this.lanHeader.setEncrypted();
    }

    public void setClassType(byte by) {
        this.lanHeader.setClassType(by);
    }

    public boolean inTransaction() {
        return this.lanHeader.inTransaction();
    }
}

