/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.io;

import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class TDPacketPool {
    private static TDPacketPool instance;
    private static int max64K;
    private static int max1MB;
    private Pool pool64K = new Pool(65156, max64K);
    private Pool pool1MB = new Pool(1048552, max1MB);
    static /* synthetic */ Class class$com$teradata$jdbc$jdbc_4$io$TDPacketPool;

    private TDPacketPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TDPacketPool getInstance() {
        if (instance == null) {
            Class clazz = class$com$teradata$jdbc$jdbc_4$io$TDPacketPool == null ? (class$com$teradata$jdbc$jdbc_4$io$TDPacketPool = TDPacketPool.class$("com.teradata.jdbc.jdbc_4.io.TDPacketPool")) : class$com$teradata$jdbc$jdbc_4$io$TDPacketPool;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new TDPacketPool();
                }
            }
        }
        return instance;
    }

    public TDPacket getTDPacket(int n, Log log) {
        if (n > 65156) {
            return this.pool1MB.getTDPacket(log);
        }
        return this.pool64K.getTDPacket(log);
    }

    public TDPacket getTDPacket(Log log) {
        return this.getTDPacket(65156, log);
    }

    public void returnTDPacket(TDPacket tDPacket, Log log) {
        if (tDPacket.getBuffer().capacity() < 1048552) {
            this.pool64K.returnTDPacket(tDPacket, log);
        } else {
            this.pool1MB.returnTDPacket(tDPacket, log);
        }
    }

    public static int getMax64K() {
        return max64K;
    }

    public static int getMax1MB() {
        return max1MB;
    }

    public static void setMax64(int n) {
        if (n > 0) {
            max64K = n;
        }
    }

    public static void setMax1MB(int n) {
        if (n > 0) {
            max1MB = n;
        }
    }

    public void getPoolStatistics(Log log) {
        log.info("Pool 64K newCount " + this.pool64K.getNewCount());
        log.info("Pool 64K poolCount " + this.pool64K.getPoolCount());
        log.info("Pool 64K refFreeCount " + this.pool64K.getRefFreeCount());
        log.info("Pool 64K refListCount " + this.pool64K.getRefListCount());
        log.info("Pool 64K refPoolCount " + this.pool64K.getRefPoolCount());
        log.info("Pool 64K poolReturn " + this.pool64K.getPoolReturn());
        log.info("Pool 64K refPoolReturn " + this.pool64K.getRefPoolReturn());
        log.info("Pool 64K totalRequest " + this.pool64K.getTotalRequests());
        log.info("Pool 64K totalReturns " + this.pool64K.getTotalReturns());
        log.info("Pool 1MB newCount " + this.pool1MB.getNewCount());
        log.info("Pool 1MB poolCount " + this.pool1MB.getPoolCount());
        log.info("Pool 1MB refFreeCount " + this.pool1MB.getRefFreeCount());
        log.info("Pool 1MB refListCount " + this.pool1MB.getRefListCount());
        log.info("Pool 1MB refPoolCount " + this.pool1MB.getRefPoolCount());
        log.info("Pool 1MB poolReturn " + this.pool1MB.getPoolReturn());
        log.info("Pool 1MB refPoolReturn " + this.pool1MB.getRefPoolReturn());
        log.info("Pool 1MB totalRequest " + this.pool1MB.getTotalRequests());
        log.info("Pool 1MB totalReturns " + this.pool1MB.getTotalReturns());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        max64K = 10;
        max1MB = 10;
    }

    private class Pool {
        private int packetSize;
        private int max;
        private TDPacket[] pool;
        private int minSpare;
        private int maxSpare;
        private int current = -1;
        private Object lock;
        private ArrayList refList;
        private int counter = 0;
        private int poolGetCount = 0;
        private int refPoolGetCount = 0;
        private int newCount = 0;
        private int refFreeCount = 0;
        private int poolReturn = 0;
        private int refPoolReturn = 0;
        private int totalRequests = 0;
        private int totalReturns = 0;

        public Pool(int n, int n2) {
            this.packetSize = n;
            this.lock = new Object();
            this.refList = new ArrayList();
            this.max = n2;
            this.pool = new TDPacket[n2];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void returnTDPacket(TDPacket tDPacket, Log log) {
            WeakReference<TDPacket> weakReference = null;
            ++this.totalReturns;
            int n = -1;
            Object object = this.lock;
            synchronized (object) {
                if (this.current < max64K - 1) {
                    n = ++this.current;
                }
            }
            tDPacket.clear();
            if (n >= 0) {
                log.debug("packet returned to pool: " + tDPacket);
                this.pool[n] = tDPacket;
                ++this.poolReturn;
            } else {
                log.debug("packet returned to reference pool: " + tDPacket);
                weakReference = new WeakReference<TDPacket>(tDPacket);
                object = this.lock;
                synchronized (object) {
                    this.refList.add(weakReference);
                    ++this.refPoolReturn;
                }
                weakReference = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized TDPacket getTDPacket(Log log) {
            WeakReference weakReference = null;
            Object var3_3 = null;
            ++this.totalRequests;
            int n = -1;
            Object object = this.lock;
            synchronized (object) {
                if (this.current >= 0) {
                    n = this.current--;
                }
            }
            if (n >= 0) {
                object = this.pool[n];
                ++this.poolGetCount;
                log.debug("Getting packet from pool: " + object);
                return object;
            }
            object = this.lock;
            synchronized (object) {
                Iterator iterator = this.refList.iterator();
                while (iterator.hasNext()) {
                    weakReference = (WeakReference)iterator.next();
                    var3_3 = weakReference.get();
                    if (var3_3 != null) {
                        iterator.remove();
                        iterator = null;
                        weakReference = null;
                        break;
                    }
                    log.debug("A wr was null: ");
                    iterator.remove();
                    weakReference = null;
                    ++this.refFreeCount;
                }
            }
            if (var3_3 != null) {
                log.debug("obtaining packet from weak reference TDPacketPool: ");
                ++this.refPoolGetCount;
                return var3_3;
            }
            object = new TDPacket(this.packetSize);
            log.debug("new of packet: " + object);
            ++this.newCount;
            return object;
        }

        public int getMax64K() {
            return max64K;
        }

        public int getPoolCount() {
            return this.poolGetCount;
        }

        public int getRefPoolCount() {
            return this.refPoolGetCount;
        }

        public int getNewCount() {
            return this.newCount;
        }

        public int getRefFreeCount() {
            return this.refFreeCount;
        }

        public int getRefListCount() {
            return this.refList.size();
        }

        public int getPoolReturn() {
            return this.poolReturn;
        }

        public int getRefPoolReturn() {
            return this.refPoolReturn;
        }

        public int getTotalRequests() {
            return this.totalRequests;
        }

        public int getTotalReturns() {
            return this.totalReturns;
        }
    }
}

