/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.logging;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.TDPacketStreamRenderer;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Log {
    private String caller;
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd.HH:mm:ss.SSS");
    public static final int DEBUG = 0;
    public static final int INFO = 1;
    public static final int TIMING = 2;
    public static final int ERROR = 3;
    private static final String[] NAMES = new String[]{"DEBUG", "INFO", "TIMING", "ERROR"};
    private PrintWriter logFile = new PrintWriter(System.out, true);
    private int level = 3;
    private StringBuffer m_sbCapture = null;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final int FULL_HEX_LENGTH = 56;
    private static final int SEG_SIZE = 16;

    public Log(String string) {
        this.caller = string;
    }

    public synchronized void beginCapture() {
        this.m_sbCapture = new StringBuffer();
    }

    public synchronized String endCapture() {
        String string = this.m_sbCapture != null ? this.m_sbCapture.toString() : "";
        this.m_sbCapture = null;
        return string;
    }

    public String getLogLevel() {
        return NAMES[this.level];
    }

    public void setLogLevel(String string) {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!NAMES[i].equalsIgnoreCase(string)) continue;
            this.level = i;
        }
    }

    public boolean isDebugEnabled() {
        return this.canLog(0);
    }

    public boolean canLog(int n) {
        return n >= this.level;
    }

    private synchronized void log(int n, Object object, Throwable throwable) {
        if (this.canLog(n)) {
            String string = dateFormat.format(new Date()) + " TERAJDBC4 " + NAMES[n] + " [" + Thread.currentThread().getName() + "] " + this.caller + " " + String.valueOf(object);
            if (throwable != null) {
                StringWriter stringWriter = new StringWriter();
                throwable.printStackTrace(new PrintWriter((Writer)stringWriter, true));
                string = string + " begin-log-stack-trace>>> " + stringWriter + " <<<end-log-stack-trace";
            }
            if (this.m_sbCapture != null) {
                this.m_sbCapture.append(string).append(LINE_SEP);
            }
            this.logFile.println(string);
        }
    }

    public void error(Object object) {
        this.log(3, object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(3, object, throwable);
    }

    public void info(Object object) {
        this.log(1, object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(1, object, throwable);
    }

    public void debug(Object object) {
        this.log(0, object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(0, object, throwable);
    }

    public void timing(Object object) {
        this.log(2, object, null);
    }

    public void timing(Object object, Throwable throwable) {
        this.log(2, object, throwable);
    }

    public void debug(TDPacketStream tDPacketStream) {
        this.debugByteArray("message dump", TDPacketStreamRenderer.dump(tDPacketStream));
    }

    public void debugByteArray(String string, byte[] byArray) {
        this.debugPartialByteArray(string, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    public void debugPartialByteArray(String string, byte[] byArray, int n, int n2) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.debug(Log.formatPartialByteArray(string, byArray, n, n2));
    }

    public static String formatPartialByteArray(String string, byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + ": ");
        if (byArray == null) {
            stringBuffer.append("null byte array");
        } else if (n >= byArray.length) {
            stringBuffer.append("offset " + n + " is beyond the end of byte array length " + byArray.length);
        } else {
            stringBuffer.append("byte array length " + byArray.length + " (0x" + Integer.toHexString(byArray.length) + "), offset " + n + " (0x" + Integer.toHexString(n) + "), dump length " + n2 + " (0x" + Integer.toHexString(n2) + ")");
            if (n + n2 > byArray.length) {
                n2 = byArray.length - n;
                stringBuffer.append(" --> limited to " + n2 + " (0x" + Integer.toHexString(n2) + ")");
            }
            stringBuffer.append(LINE_SEP);
            int n3 = 0;
            for (int i = 0; i < n2 - 16; i += 16) {
                stringBuffer.append(Log.formatByteArrayLine(byArray, n + i, 16));
                n3 += 16;
            }
            if (n3 < n2) {
                stringBuffer.append(Log.formatByteArrayLine(byArray, n + n3, n2 - n3));
            }
        }
        return stringBuffer.toString();
    }

    private static String formatByteArrayLine(byte[] byArray, int n, int n2) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(150);
        stringBuffer.append(Log.leadingZeros(Integer.toHexString(n), 5) + "   ");
        for (n3 = 0; n3 < n2; ++n3) {
            stringBuffer.append(Log.rightJustify(Integer.toHexString(byArray[n + n3]), 2) + " ");
        }
        if (stringBuffer.length() < 56) {
            String string = "                                                                ";
            char[] cArray = string.toCharArray();
            stringBuffer.append(cArray, 0, 56 - stringBuffer.length());
        }
        stringBuffer.append(" |");
        for (n3 = 0; n3 < n2; ++n3) {
            char c = (char)byArray[n + n3];
            if (!Log.isPrintableAscii(c)) {
                c = '.';
            }
            stringBuffer.append(c);
        }
        stringBuffer.append("|" + LINE_SEP);
        return stringBuffer.toString();
    }

    private static boolean isPrintableAscii(char c) {
        return c >= ' ' && c < '\u007f';
    }

    private static String rightJustify(String string, int n) {
        if (string.length() > 2) {
            string = string.substring(string.length() - 2);
        }
        return Log.leadingZeros(string, n);
    }

    public static String leadingZeros(String string, int n) {
        for (int i = n - string.length(); i > 0; --i) {
            string = "0" + string;
        }
        return string;
    }
}

