/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;

public class ClientConfigParcel
extends Parcel {
    private int clientConfigEx;
    private Vector features = new Vector();
    private static final int LENGTH = 200;

    public ClientConfigParcel(Log log) {
        super(log);
        this.setFlavor((short)166);
        this.setLength(8);
        this.createBuffer(200);
        this.clientConfigEx = 1;
    }

    public ClientConfigParcel(TDPacketStream tDPacketStream, Log log) throws SQLException {
        this(tDPacketStream, "ASCII", log);
    }

    public ClientConfigParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(string, log);
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        tDPacketStream.position(this.flavorPosition);
        this.clientConfigEx = tDPacketStream.getInt();
    }

    public int getClientConfigEx() {
        return this.clientConfigEx;
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        this.buffer.putInt(this.clientConfigEx);
        Enumeration enumeration = this.features.elements();
        while (enumeration.hasMoreElements()) {
            Parcel parcel = (Parcel)enumeration.nextElement();
            TDPacketStream tDPacketStream = parcel.toStream();
            int n = tDPacketStream.position();
            tDPacketStream.rewind();
            byte[] byArray = new byte[n];
            tDPacketStream.get(byArray, 0, n);
            this.buffer.put(byArray, 0, n);
        }
        this.buffer.flip();
        return this.buffer;
    }

    public void addFeature(Parcel parcel) {
        this.features.add(parcel);
        int n = parcel.getLength();
        this.setLength(this.getLength() + n);
    }
}

