/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;
import java.sql.SQLException;
import java.util.HashMap;

public class ConfigRspParcel
extends Parcel {
    public static final int FIRSTSESSIONNO = 4;
    public static final int FIRSTREQNO = 8;
    public static final int MAXSESSCNT = 12;
    public static final int PROCCOUNT = 14;
    public static final int IFPRECSIZE = 4;
    public static final int AMPRECSIZE = 2;
    public static final int CHARSETRECSIZE = 30;
    public static final int SIXTYFOURKSUPPORT = 7;
    public static final int LOB_SUPPORT = 11;
    public static final int SQL_CAPABILITIES = 10;
    public static final int DBS_RELEASEVERSION = 13;
    public static final int SIP_SUPPORT = 14;
    private char defaultTransactionSemantics;
    private byte defaultTDCharSetCode;
    private short ampCount;
    private HashMap mapCharSetNameToCode = new HashMap();
    private short maximumNumberOfSegments = 0;
    private int maximumSegmentSize = 0;
    private byte lobSupport;
    private byte aphSupport;
    private byte extendedRspSupport;
    private byte positioningSupport;
    private byte msrPositioningSupport;
    private byte udtSupport;
    private byte enhancedStatementStatusSupport;
    private byte aphResponseSupport;
    private byte arraySupport;
    private byte outParamArgSupport;
    private byte generatedKeysSupport;
    private byte largeDecimalBIGINT;
    private byte statementInfoSupport = 0;
    private byte dynamicResultSetsSupport = 0;
    private byte m_statementInfoRequestSupport;
    private String dbsRelease = null;
    private int dbsReleaseLength = 30;
    private String dbsVersion = null;
    private int dbsVersionLength = 32;
    private int nullCollation = 1;
    private String DBMS = "Teradata";
    private int unquotedIdentifierCase = 2;
    private int quotedIdentifierCase = 2;
    private String identifierQuote = "\"";
    private String specialChars = "#$";
    private boolean supportsExtendedSQLGrammar = false;
    private boolean supportsANSI92IntermSQLGrammar = false;
    private boolean supportsANSI92FullSQLGrammar = false;
    private boolean supportsIntegrityEnhancementFacility = false;
    private int cursorCommitBehavior = 1;
    private int maxBinLiteralChars = 62000;
    private int maxCharLiteralChars = 31000;
    private int maxColNameChars = 30;
    private int maxColGrpBy = 0;
    private int maxColperIdx = 64;
    private int maxColOrdrBy = 0;
    private int maxColInSel = 0;
    private int maxColinTbl = 2000;
    private int maximumDriverConnections = 0;
    private int maxCursorNameChars = 18;
    private int maxIdxBytes = 64000;
    private int maxSchemaNameChars = 30;
    private int maxProcedureNameChars = 30;
    private int maxRowBytes = 64256;
    private boolean maxRowBytesIncludesLOBs = false;
    private int maxStatementChars = 1048076;
    private int maxRequests = 16;
    private int maxRequestBytes = 0;
    private int maxTblNameChars = 30;
    private int maxTblinSel = 0;
    private int maxUsrNameChars = 30;
    private int transactionIsolationDefault = 8;
    private int supportedTransactionIsolationLevels = 8;
    private int transactionCapability = 2;
    private long maxLobBytes = 0L;
    private int maxResponseBytes = 0;
    private int maxSPParams = 0;
    private int maxObjectNameChars = 0;
    private int maxFieldsUsingRow = 0;
    private int maxUsingDataBytes = 0;
    private int maxDecimal = 0;
    private int maxColBytes = 0;
    private int maxVarcharChars = 0;
    private int maxCharChars = 0;
    private int maxGraphicChars = 0;
    private int maxVargraphicChars = 0;
    private int maxVarbyteBytes = 0;
    private int maxByteBytes = 0;
    private int maxParamsInRequest = 0;
    private int maxTimeScale = 0;
    private int maxTimeStampScale = 0;
    private int maxIntervalToSecondScale = 0;

    public ConfigRspParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(string, log);
        short s = 0;
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        tDPacketStream.position(this.flavorPosition + 14);
        s = tDPacketStream.getShort();
        tDPacketStream.position(tDPacketStream.position() + s * 4);
        this.ampCount = tDPacketStream.getShort();
        tDPacketStream.position(tDPacketStream.position() + this.ampCount * 2);
        this.defaultTDCharSetCode = tDPacketStream.get();
        tDPacketStream.position(tDPacketStream.position() + 1);
        int n = tDPacketStream.getShort();
        for (int i = 0; i < n; ++i) {
            Byte by = new Byte(tDPacketStream.get());
            tDPacketStream.get();
            String string2 = tDPacketStream.getString(30, "ASCII").trim();
            this.mapCharSetNameToCode.put(string2, by);
        }
        this.defaultTransactionSemantics = (char)tDPacketStream.get(tDPacketStream.position() + 6);
        tDPacketStream.position(tDPacketStream.position() + 7);
        this.determineFeatureSupport(tDPacketStream);
    }

    public ConfigRspParcel(TDPacketStream tDPacketStream, Log log) throws SQLException {
        this(tDPacketStream, "ASCII", log);
    }

    private void determineFeatureSupport(TDPacketStream tDPacketStream) throws SQLException {
        while (tDPacketStream.position() + 4 < this.flavorPosition + this.length) {
            short s = tDPacketStream.getShort();
            short s2 = tDPacketStream.getShort();
            switch (s) {
                case 7: {
                    this.maximumNumberOfSegments = tDPacketStream.getShort(tDPacketStream.position() + 2);
                    this.maximumSegmentSize = tDPacketStream.getInt(tDPacketStream.position() + 4);
                    if (s2 <= 116) break;
                    this.maxRowBytes = tDPacketStream.getInt(tDPacketStream.position() + 8);
                    this.maxLobBytes = tDPacketStream.getLong(tDPacketStream.position() + 12);
                    this.maxRequestBytes = tDPacketStream.getInt(tDPacketStream.position() + 20);
                    this.maxResponseBytes = tDPacketStream.getInt(tDPacketStream.position() + 24);
                    this.maxSPParams = tDPacketStream.getInt(tDPacketStream.position() + 28);
                    this.maxColGrpBy = tDPacketStream.getInt(tDPacketStream.position() + 32);
                    this.maxColOrdrBy = tDPacketStream.getInt(tDPacketStream.position() + 36);
                    this.maxColInSel = tDPacketStream.getInt(tDPacketStream.position() + 40);
                    this.maxColinTbl = tDPacketStream.getInt(tDPacketStream.position() + 44);
                    this.maxObjectNameChars = tDPacketStream.getInt(tDPacketStream.position() + 48);
                    this.maxTblinSel = tDPacketStream.getInt(tDPacketStream.position() + 52);
                    this.maxFieldsUsingRow = tDPacketStream.getInt(tDPacketStream.position() + 56);
                    this.maxUsingDataBytes = tDPacketStream.getInt(tDPacketStream.position() + 60);
                    this.maxBinLiteralChars = tDPacketStream.getInt(tDPacketStream.position() + 64);
                    this.maxCharLiteralChars = tDPacketStream.getInt(tDPacketStream.position() + 68);
                    this.maxDecimal = tDPacketStream.getInt(tDPacketStream.position() + 72);
                    this.maxColBytes = tDPacketStream.getInt(tDPacketStream.position() + 76);
                    this.maxVarcharChars = tDPacketStream.getInt(tDPacketStream.position() + 80);
                    this.maxCharChars = tDPacketStream.getInt(tDPacketStream.position() + 84);
                    this.maxGraphicChars = tDPacketStream.getInt(tDPacketStream.position() + 88);
                    this.maxVargraphicChars = tDPacketStream.getInt(tDPacketStream.position() + 92);
                    this.maxVarbyteBytes = tDPacketStream.getInt(tDPacketStream.position() + 96);
                    this.maxByteBytes = tDPacketStream.getInt(tDPacketStream.position() + 100);
                    this.maxParamsInRequest = tDPacketStream.getInt(tDPacketStream.position() + 104);
                    this.maxTimeScale = tDPacketStream.getInt(tDPacketStream.position() + 108);
                    this.maxTimeStampScale = tDPacketStream.getInt(tDPacketStream.position() + 112);
                    this.maxIntervalToSecondScale = tDPacketStream.getInt(tDPacketStream.position() + 116);
                    break;
                }
                case 11: {
                    this.lobSupport = tDPacketStream.get(tDPacketStream.position());
                    this.aphSupport = tDPacketStream.get(tDPacketStream.position() + 1);
                    this.extendedRspSupport = tDPacketStream.get(tDPacketStream.position() + 2);
                    if (s2 > 3) {
                        this.positioningSupport = tDPacketStream.get(tDPacketStream.position() + 3);
                    }
                    if (s2 > 4) {
                        this.udtSupport = tDPacketStream.get(tDPacketStream.position() + 4);
                    }
                    if (s2 > 5) {
                        this.enhancedStatementStatusSupport = tDPacketStream.get(tDPacketStream.position() + 5);
                    }
                    if (s2 > 6) {
                        this.aphResponseSupport = tDPacketStream.get(tDPacketStream.position() + 6);
                    }
                    if (s2 > 7) {
                        this.statementInfoSupport = tDPacketStream.get(tDPacketStream.position() + 7);
                    }
                    if (s2 > 9) {
                        this.dynamicResultSetsSupport = tDPacketStream.get(tDPacketStream.position() + 9);
                    }
                    if (s2 > 10) {
                        this.msrPositioningSupport = tDPacketStream.get(tDPacketStream.position() + 10);
                    }
                    if (s2 > 11) {
                        this.m_statementInfoRequestSupport = tDPacketStream.get(tDPacketStream.position() + 11);
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug("lobSupport=" + this.lobSupport + " aphSupport=" + this.aphSupport + " extendedRspSupport=" + this.extendedRspSupport + " positioningSupport=" + this.positioningSupport + " udtSupport=" + this.udtSupport + " enhancedStatementStatusSupport=" + this.enhancedStatementStatusSupport + " aphResponseSupport=" + this.aphResponseSupport + " statementInfoSupport=" + this.statementInfoSupport + " dynamicResultSetsSupport=" + this.dynamicResultSetsSupport + " msrPositioningSupport=" + this.msrPositioningSupport + " m_statementInfoRequestSupport=" + this.m_statementInfoRequestSupport);
                    break;
                }
                case 10: {
                    this.arraySupport = tDPacketStream.get(tDPacketStream.position() + 1);
                    this.outParamArgSupport = tDPacketStream.get(tDPacketStream.position() + 3);
                    this.largeDecimalBIGINT = tDPacketStream.get(tDPacketStream.position() + 4);
                    this.generatedKeysSupport = tDPacketStream.get(tDPacketStream.position() + 5);
                    break;
                }
                case 13: {
                    try {
                        this.dbsRelease = tDPacketStream.getString(tDPacketStream.position(), this.dbsReleaseLength, "ASCII").trim();
                        this.dbsVersion = tDPacketStream.getString(tDPacketStream.position() + this.dbsReleaseLength, this.dbsVersionLength, "ASCII").trim();
                        break;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        this.log.error("UnsupportedEncodingException exception when retrieving DBS Release/Version from parcel ConfigRspParcel: " + unsupportedEncodingException);
                    }
                }
            }
            tDPacketStream.position(tDPacketStream.position() + s2);
        }
        this.supportedTransactionIsolationLevels = this.dbsRelease == null ? 8 : 9;
    }

    public int getMaximumSegmentSize() {
        return this.maximumSegmentSize;
    }

    public short getMaximumNumberOfSegments() {
        return this.maximumNumberOfSegments;
    }

    public char getDefaultTransactionSemantics() {
        return this.defaultTransactionSemantics;
    }

    public byte getDefaultTDCharSetCode() {
        return this.defaultTDCharSetCode;
    }

    public boolean getLOBSupport() {
        return this.lobSupport == 1;
    }

    public boolean isMultiPartProtocolSupported() {
        return this.lobSupport == 1;
    }

    public boolean getAPHSupport() {
        return this.aphSupport >= 1;
    }

    public boolean getExtendedRspSupport() {
        return this.extendedRspSupport == 1;
    }

    public boolean getStatementPositioningSupport() {
        return this.msrPositioningSupport >= 1;
    }

    public boolean getPositioningSupport() {
        return this.positioningSupport >= 1;
    }

    public boolean getArraySupport() {
        return this.arraySupport == 1;
    }

    public boolean callSPHasDMLArraySupport() {
        return false;
    }

    public boolean getOutParamArgSupport() {
        return this.outParamArgSupport == 1;
    }

    public boolean getGeneratedKeysSupport() {
        return this.generatedKeysSupport == 1;
    }

    public boolean isLargeDecimalAndBigIntSupported() {
        return this.largeDecimalBIGINT >= 1;
    }

    public boolean getAPHResponseSupport() {
        return this.aphResponseSupport >= 1;
    }

    public byte getTDCharSetCodeFromName(String string) throws JDBCException {
        if (this.mapCharSetNameToCode.containsKey(string)) {
            return (Byte)this.mapCharSetNameToCode.get(string);
        }
        throw ErrorFactory.makeDriverJDBCException("TJ311", string);
    }

    public String getTeradataDatabaseRelease() {
        return this.dbsRelease;
    }

    public String getTeradataDatabaseVersion() {
        return this.dbsVersion;
    }

    public int getNullCollation() {
        return this.nullCollation;
    }

    public String getDBMS() {
        return this.DBMS;
    }

    public int getUnquotedIdentifierCase() {
        return this.unquotedIdentifierCase;
    }

    public int getQuotedIdentifierCase() {
        return this.quotedIdentifierCase;
    }

    public String getIdentifierQuote() {
        return this.identifierQuote;
    }

    public String getSpecialChars() {
        return this.specialChars;
    }

    public boolean getSupportsExtendedSQLGrammar() {
        return this.supportsExtendedSQLGrammar;
    }

    public boolean getSupportsANSI92IntermSQLGrammar() {
        return this.supportsANSI92IntermSQLGrammar;
    }

    public boolean getSupportsANSI92FullSQLGrammar() {
        return this.supportsANSI92FullSQLGrammar;
    }

    public boolean getSupportsIntegrityEnhancementFacility() {
        return this.supportsIntegrityEnhancementFacility;
    }

    public int getCursorCommitBehavior() {
        return this.cursorCommitBehavior;
    }

    public int getMaxBinLiteralChars() {
        return this.maxBinLiteralChars;
    }

    public int getMaxCharLiteralChars() {
        return this.maxCharLiteralChars;
    }

    public int getMaxColNameChars() {
        return this.maxColNameChars;
    }

    public int getMaxColGrpBy() {
        return this.maxColGrpBy;
    }

    public int getMaxColperIdx() {
        return this.maxColperIdx;
    }

    public int getMaxColOrdrBy() {
        return this.maxColOrdrBy;
    }

    public int getMaxColInSel() {
        return this.maxColInSel;
    }

    public int getMaxColinTbl() {
        return this.maxColinTbl;
    }

    public int getMaximumDriverConnections() {
        return this.maximumDriverConnections;
    }

    public int getMaxCursorNameChars() {
        return this.maxCursorNameChars;
    }

    public int getMaxIdxBytes() {
        return this.maxIdxBytes;
    }

    public int getMaxSchemaNameChars() {
        return this.maxSchemaNameChars;
    }

    public int getMaxProcedureNameChars() {
        return this.maxProcedureNameChars;
    }

    public int getMaxRowBytes() {
        return this.maxRowBytes;
    }

    public boolean getMaxRowBytesIncludesLOBs() {
        return this.maxRowBytesIncludesLOBs;
    }

    public int getMaxStatementChars() {
        return this.maxStatementChars;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public int getMaxTblNameChars() {
        return this.maxTblNameChars;
    }

    public int getMaxTblinSel() {
        return this.maxTblinSel;
    }

    public int getMaxUsrNameChars() {
        return this.maxUsrNameChars;
    }

    public int getTransactionIsolationDefault() {
        return this.transactionIsolationDefault;
    }

    public int getSupportedTransactionIsolationLevels() {
        return this.supportedTransactionIsolationLevels;
    }

    public int getTransactionCapability() {
        return this.transactionCapability;
    }

    public boolean isStatementInfoSupported() {
        return this.statementInfoSupport >= 1;
    }

    public boolean isDynamicResultSetsSupported() {
        return this.dynamicResultSetsSupport >= 1;
    }

    public boolean isStatementInfoRequestSupported() {
        return this.m_statementInfoRequestSupport >= 1;
    }

    public short getAMPCount() {
        return this.ampCount;
    }
}

