/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.ArrayList;

public class DataInfoParcel
extends PrepInfoParcel {
    protected int fieldCount;
    protected DataInfoField[] fields;
    public static final int LENGTH = 6;

    public DataInfoParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(tDPacketStream, string, log);
        if (DataInfoParcel.trueFlavor(this.flavor) != 71) {
            return;
        }
        this.fieldCount = tDPacketStream.getShort();
        this.fields = new DataInfoField[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            DataInfoField dataInfoField = new DataInfoField();
            dataInfoField.setType(tDPacketStream.getShort());
            dataInfoField.setLength(tDPacketStream.getShort());
            this.fields[i] = dataInfoField;
        }
        this.initPrepInfoItems();
    }

    protected void initPrepInfoItems() throws SQLException {
        ArrayList<PrepInfoItem> arrayList = new ArrayList<PrepInfoItem>();
        if (this.fields != null) {
            for (int i = 0; i < this.fieldCount; ++i) {
                if (JDBC4Constants.getTDTypeParameterMode(this.fields[i].getType()) == 1) continue;
                PrepInfoItem prepInfoItem = DataInfoParcel.createPrepInfoItem(this.log, (short)this.fields[i].getType(), this.decimalShift());
                arrayList.add(prepInfoItem);
                prepInfoItem.setDataLen(this.fields[i].getLength());
                prepInfoItem.setCharSetName(this.charSetName);
            }
        }
        this.items = arrayList.toArray(new PrepInfoItem[0]);
    }

    public DataInfoParcel(Log log) {
        this("ASCII", log);
    }

    public DataInfoParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)71);
    }

    public DataInfoParcel(int n, Log log) {
        this(n, "ASCII", log);
    }

    public DataInfoParcel(int n, String string, Log log) {
        super(string, log);
        this.setFlavor((short)71);
        int n2 = n * 4 + 6;
        this.fields = new DataInfoField[n];
        this.setLength(n2);
        this.createBuffer(n2);
    }

    public void addField(DataInfoField dataInfoField) {
        if (dataInfoField.getType() == 0) {
            return;
        }
        this.fields[this.fieldCount++] = dataInfoField;
        this.setLength(this.getLength() + 4);
    }

    public DataInfoField[] getFields() {
        return this.fields;
    }

    public void setFields(DataInfoField[] dataInfoFieldArray) {
        int n = 0;
        for (int i = 0; i < dataInfoFieldArray.length; ++i) {
            if (dataInfoFieldArray[i].getType() <= 0) continue;
            this.fields[n++] = dataInfoFieldArray[i];
        }
    }

    public DataInfoFieldIterator getDataInfoFieldIterator() {
        return new DataInfoFieldIterator();
    }

    public TDPacketStream toStream() throws JDBCException {
        if (this.buffer == null) {
            this.createBuffer(this.getLength());
        }
        super.toStream();
        this.fieldCount = this.fields.length;
        this.putFieldCount();
        for (int i = 0; i < this.fields.length; ++i) {
            DataInfoField dataInfoField = this.fields[i];
            dataInfoField.putBufferType(this.buffer);
            dataInfoField.putBufferLength(this.buffer);
        }
        this.buffer.flip();
        return this.buffer;
    }

    protected void putFieldCount() {
        this.buffer.putShort((short)this.fieldCount);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" *************************\n");
        stringBuffer.append("fieldCount: " + this.fieldCount + '\n');
        DataInfoFieldIterator dataInfoFieldIterator = this.getDataInfoFieldIterator();
        while (dataInfoFieldIterator.hasNext()) {
            DataInfoField dataInfoField = dataInfoFieldIterator.next();
            stringBuffer.append(dataInfoField.getClass().getName());
            stringBuffer.append(" *********************\n");
            stringBuffer.append("DataType: " + dataInfoField.getType() + '\n');
            stringBuffer.append("DataLen: " + dataInfoField.getLength() + '\n');
            stringBuffer.append(dataInfoField.getClass().getName());
            stringBuffer.append(" END ****************\n");
        }
        stringBuffer.append(this.formatPrepInfoItems());
        stringBuffer.append(this.getClass().getName());
        stringBuffer.append(" END *******************\n");
        return stringBuffer.toString();
    }

    public class DataInfoFieldIterator {
        private int index = 0;

        public int count() {
            return DataInfoParcel.this.fields != null ? DataInfoParcel.this.fields.length : 0;
        }

        public boolean hasNext() {
            return DataInfoParcel.this.fields != null ? this.index < DataInfoParcel.this.fields.length : false;
        }

        public DataInfoField next() {
            return this.hasNext() ? DataInfoParcel.this.fields[this.index++] : null;
        }
    }
}

