/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXField;
import java.sql.SQLException;

public class DataInfoXParcel
extends DataInfoParcel {
    public static final int LENGTH = 8;

    public DataInfoXParcel(TDPacketStream tDPacketStream, Log log) throws SQLException {
        this(tDPacketStream, "ASCII", log);
    }

    public DataInfoXParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(tDPacketStream, string, log);
        this.fieldCount = tDPacketStream.getInt();
        this.fields = new DataInfoXField[this.fieldCount];
        for (int i = 0; i < this.fieldCount; ++i) {
            DataInfoXField dataInfoXField = new DataInfoXField();
            dataInfoXField.setType(tDPacketStream.getShort());
            dataInfoXField.setLength(tDPacketStream.getLong());
            this.fields[i] = dataInfoXField;
        }
        this.initPrepInfoItems();
    }

    protected int decimalShift() {
        return 32;
    }

    public DataInfoXParcel(Log log) {
        this("ASCII", log);
    }

    public DataInfoXParcel(String string, Log log) {
        super(log);
        this.setCharSetName(string);
        this.setFlavor((short)146);
    }

    public DataInfoXParcel(int n, String string, Log log) {
        super(log);
        this.setCharSetName(string);
        this.setFlavor((short)146);
        int n2 = n * 10 + 8;
        this.fields = new DataInfoXField[n];
        this.setLength((short)n2);
        this.createBuffer(n2);
    }

    protected void putFieldCount() {
        this.buffer.putInt(this.fieldCount);
    }
}

