/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ByteConverter;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;

public class DataParcel
extends Parcel {
    protected String dataParcelInfo = null;
    private boolean dataParcelInfoNeedsLength = false;

    public DataParcel(String string, Log log, String string2, boolean bl) {
        super(string, log);
        this.setFlavor((short)3);
        this.dataParcelInfo = string2;
        this.dataParcelInfoNeedsLength = bl;
    }

    public TDPacketStream toStream() throws JDBCException {
        byte[] byArray = null;
        try {
            byArray = this.dataParcelInfo.getBytes(this.getCharSetName());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ309", unsupportedEncodingException.getMessage());
        }
        if (this.dataParcelInfoNeedsLength) {
            this.setLength(byArray.length + 4 + 2);
        } else {
            this.setLength(byArray.length + 4);
        }
        this.createBuffer(this.getLength());
        this.parcelHeaderToStream();
        if (this.dataParcelInfoNeedsLength) {
            byte[] byArray2 = new byte[2];
            ByteConverter.putShort(byArray2, 0, (short)byArray.length);
            this.buffer.put(byArray2);
        }
        this.buffer.put(byArray);
        this.buffer.flip();
        return this.buffer;
    }
}

