/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;

public class ElicitFileParcel
extends Parcel {
    byte sourceLang = 0;
    byte fileType = 0;
    byte fileSupplied = 0;
    short fileNameLength = 0;
    String fileName = null;

    public ElicitFileParcel(Log log) {
        this("ASCII", log);
    }

    public ElicitFileParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)151);
        this.setLength(4);
        this.createBuffer(4);
    }

    public ElicitFileParcel(TDPacketStream tDPacketStream, Log log) throws SQLException {
        this(tDPacketStream, "ASCII", log);
    }

    public ElicitFileParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(log);
        this.initResponseParcel(tDPacketStream, string);
        this.sourceLang = tDPacketStream.get();
        this.fileType = tDPacketStream.get();
        this.fileSupplied = tDPacketStream.get();
        tDPacketStream.get();
        this.fileNameLength = tDPacketStream.getShort();
        int n = UnsignedConversions.convertUnsignedShort(this.fileNameLength);
        this.fileName = tDPacketStream.getString(n, this.getCharSetName());
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        this.buffer.flip();
        return this.buffer;
    }

    public String getFileName() {
        return this.fileName;
    }
}

