/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;

public class ErrorParcel
extends Parcel {
    private short statementNumber;
    private short info;
    private short code;
    private short msgLength;
    private String msg;

    public ErrorParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(log);
        this.initResponseParcel(tDPacketStream, string);
        this.statementNumber = tDPacketStream.getShort();
        this.info = tDPacketStream.getShort();
        this.code = tDPacketStream.getShort();
        this.msgLength = tDPacketStream.getShort();
        int n = UnsignedConversions.convertUnsignedShort(this.msgLength);
        if (n > 0) {
            this.msg = tDPacketStream.getString(n, this.getCharSetName());
        }
    }

    public short getStatementNumber() {
        return this.statementNumber;
    }

    public short getInfo() {
        return this.info;
    }

    public short getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }
}

