/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import java.sql.SQLException;

public class GtwConfigParcel
extends Parcel {
    private boolean supportsUTF_Credentials = false;

    public GtwConfigParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(string, log);
        this.flavorPosition = tDPacketStream.position();
        this.setFlavor(tDPacketStream.getShort());
        this.setLength(tDPacketStream.getShort());
        if (tDPacketStream.getInt() == 1) {
            this.determineFeatureSupport(tDPacketStream, this.flavorPosition + this.length);
        }
    }

    private void determineFeatureSupport(TDPacketStream tDPacketStream, int n) throws SQLException {
        while (tDPacketStream.position() + 4 <= n) {
            int n2 = tDPacketStream.position();
            short s = tDPacketStream.getShort();
            short s2 = tDPacketStream.getShort();
            if (this.log.isDebugEnabled()) {
                this.log.debug("GtwConfigParcel: self-defining feature " + s + " at position " + n2 + " has length " + s2);
            }
            switch (s) {
                case 3: {
                    this.supportsUTF_Credentials = true;
                }
            }
            tDPacketStream.position(n2 + s2);
        }
    }

    public boolean isUTF_CredentialSupported() {
        return this.supportsUTF_Credentials;
    }
}

