/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.PreparedParameter;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class IndicDataParcel
extends Parcel {
    private PreparedParameter[] preparedParams;
    private byte[] nullIndicatorBits;
    public static final int LENGTH = 4;

    public IndicDataParcel(Log log) {
        this("ASCII", log);
    }

    public IndicDataParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)68);
    }

    public IndicDataParcel(int n, Log log) {
        this(n, "ASCII", log);
    }

    public IndicDataParcel(int n, String string, Log log) {
        super(string, log);
        this.setFlavor((short)68);
        this.setLength(n + 4);
        this.createBuffer(n + 4);
    }

    public void setParameters(PreparedParameter[] preparedParameterArray) {
        this.preparedParams = preparedParameterArray;
    }

    public void setNullIndicatorBits(byte[] byArray) {
        this.nullIndicatorBits = byArray;
    }

    public TDPacketStream toStream() throws JDBCException {
        if (this.buffer == null) {
            this.createBuffer(this.getLength());
        }
        super.toStream();
        this.buffer.put(this.nullIndicatorBits);
        for (int i = 0; i < this.preparedParams.length; ++i) {
            if (this.preparedParams[i] == null || this.preparedParams[i].getParamType() == 2) continue;
            this.buffer.put(this.preparedParams[i].getBinaryValue());
        }
        this.buffer.flip();
        return this.buffer;
    }
}

