/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitDataReceivedParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitFileParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartRecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.NopParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.PromptParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOAuthResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import java.sql.SQLException;

public class ParcelFactory {
    protected Log log;
    private TDPacket packet;
    private int packetLength;
    private int parcelLength;
    private int nextParcelStart;
    private int currentPosition;
    private TDPacketStream buffer;
    private PrepInfoParcel prepInfo;
    private String charSetName;
    private SuccessParcel successParcel;
    private MultiPartRecordParcel initialMultiPartRecordParcel;

    public ParcelFactory(Log log) {
        this.log = log;
    }

    public ParcelFactory(Log log, String string) {
        this.charSetName = string;
        this.log = log;
    }

    public void setCharSetName(String string) {
        this.charSetName = string;
    }

    public void skipParcel(int n) {
        this.currentPosition += n;
    }

    public int nextParcelPeek() throws SQLException {
        if (this.currentPosition < this.buffer.limit()) {
            return Parcel.trueFlavor(this.buffer.getShort(this.currentPosition));
        }
        return -1;
    }

    public int getCurrentPosition() {
        return this.currentPosition;
    }

    public Parcel scanForEndStatementParcel(boolean bl) throws SQLException {
        EndStatementParcel endStatementParcel = null;
        int n = this.currentPosition;
        if (this.packet != null) {
            if (bl) {
                this.clearMultiPartRecordParcel();
            }
            while (n < this.buffer.limit()) {
                this.buffer.position(n);
                Parcel.ParcelHeader parcelHeader = Parcel.readParcelHeader(this.buffer, this.log);
                if (11 == parcelHeader.flavor) {
                    this.buffer.position(n);
                    endStatementParcel = new EndStatementParcel(this.buffer, this.log);
                    if (bl) {
                        this.currentPosition = n + endStatementParcel.getLength();
                        break;
                    }
                    this.buffer.position(this.currentPosition);
                    break;
                }
                n += parcelHeader.length;
            }
        }
        return endStatementParcel;
    }

    public Parcel nextParcel() throws SQLException {
        Parcel parcel = null;
        if (this.packet != null && this.currentPosition < this.buffer.limit()) {
            short s = Parcel.trueFlavor(this.buffer.getShort(this.currentPosition));
            this.log.debug("ParcelFactory:nextParcel flavor value: " + s);
            switch (s) {
                case 29: {
                    this.log.debug("ParcelFactory: creating a PromptParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new PromptParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 89: {
                    this.log.debug("ParcelFactory: creating a LogonSequenceNumberParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new LogonSequenceNumberParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 101: {
                    this.log.debug("ParcelFactory: creating an AssignRspParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new AssignRspParcel(this.buffer, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 43: {
                    this.log.debug("ParcelFactory: creating an ConfigRspParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ConfigRspParcel(this.buffer, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 8: {
                    this.log.debug("ParcelFactory: creating a SuccessParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new SuccessParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.successParcel = (SuccessParcel)parcel;
                    this.log.debug("parcel factory success parcel create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 9: {
                    this.log.debug("ParcelFactory: creating a FailureParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new FailureParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 10: {
                    this.log.debug("ParcelFactory: creating a RecordParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new RecordParcel(this.buffer, this.successParcel, this.prepInfo != null ? this.prepInfo.getPrepInfoItemIterator() : null, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 11: {
                    this.log.debug("ParcelFactory: creating an EndStatementParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndStatementParcel(this.buffer, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 12: {
                    this.log.debug("ParcelFactory: creating an EndRequestParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndRequestParcel(this.buffer, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 49: {
                    this.log.debug("ParcelFactory: creating an ErrorParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ErrorParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 164: {
                    this.log.debug("ParcelFactory: creating an ErrorInfoParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ErrorInfoParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 71: {
                    this.log.debug("ParcelFactory: creating a DataInfoParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new DataInfoParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    if (this.prepInfo == null) {
                        this.prepInfo = (DataInfoParcel)parcel;
                    }
                    this.log.debug("parcel factory datainfo create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 86: {
                    this.log.debug("ParcelFactory: creating a PrepInfoParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new PrepInfoParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.prepInfo = (PrepInfoParcel)parcel;
                    this.log.debug("parcelfactory prepinfo create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 134: {
                    this.log.debug("ParcelFactory: creating an SSORespParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new SSOResponseParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory SSOResp create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 125: {
                    this.log.debug("ParcelFactory: creating a PrepInfoXParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new PrepInfoXParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.prepInfo = (PrepInfoXParcel)parcel;
                    this.log.debug("parcelfactory prepinfox create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 146: {
                    this.log.debug("ParcelFactory: creating a DataInfoX");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new DataInfoXParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    if (this.prepInfo == null) {
                        this.prepInfo = (DataInfoXParcel)parcel;
                    }
                    this.log.debug("parcelfactory datainfox create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 144: {
                    this.log.debug("ParcelFactory: creating a MultipartRecordParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new MultiPartRecordParcel(this.buffer, this.prepInfo != null ? this.prepInfo.getPrepInfoItemIterator() : null, this.charSetName, this.log);
                    this.initialMultiPartRecordParcel = (MultiPartRecordParcel)parcel;
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 145: {
                    this.log.debug("ParcelFactory: creating an EndMultiPartRecordParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new EndMultiPartRecordParcel(this.buffer, this.log);
                    this.currentPosition += parcel.getLength();
                    this.clearMultiPartRecordParcel();
                    break;
                }
                case 32: {
                    this.log.debug("ParcelFactory: creating a NOPParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new NopParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 150: {
                    this.log.debug("ParcelFactory: creating a ElicitDataParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ElicitDataParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 152: {
                    this.log.debug("ParcelFactory: creating a ElicitDataReceivedParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ElicitDataReceivedParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 151: {
                    this.log.debug("ParcelFactory: creating an ELicitFileParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new ElicitFileParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory ElicitFile create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 165: {
                    this.log.debug("ParcelFactory: creating a GtwConfigParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new GtwConfigParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory GtwConfig create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 167: {
                    this.log.debug("ParcelFactory: creating an AuthMechParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new AuthMechParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory AuthMech create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 131: {
                    this.log.debug("ParcelFactory: creating an SSOAuthRespParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new SSOAuthResponseParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory SSOAuthResp create time: " + (System.currentTimeMillis() - l));
                    break;
                }
                case 169: {
                    this.log.debug("ParcelFactory: creating a StatementInfoParcel");
                    long l = System.currentTimeMillis();
                    this.buffer.position(this.currentPosition);
                    parcel = new StatementInfoParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    this.log.debug("parcelfactory StatementInfoParcel create time: " + (System.currentTimeMillis() - l));
                    this.prepInfo = (StatementInfoParcel)parcel;
                    break;
                }
                case 170: {
                    this.log.debug("ParcelFactory: creating an StatementInfoEndParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new StatementInfoEndParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                case 172: {
                    this.log.debug("ParcelFactory: creating a ResultSetParcel");
                    this.buffer.position(this.currentPosition);
                    parcel = new ResultSetParcel(this.buffer, this.charSetName, this.log);
                    this.currentPosition += parcel.getLength();
                    break;
                }
                default: {
                    this.log.debug("ParcelFactory unknown parcel");
                    this.buffer.position(this.currentPosition);
                    this.log.debug("ParcelFactory.nextParcel unidentified parcel flavor: " + this.buffer.getShort(this.currentPosition));
                    parcel = null;
                }
            }
            return parcel;
        }
        return null;
    }

    public void setTDPacket(TDPacket tDPacket) {
        this.packet = tDPacket;
        this.buffer = tDPacket.getBuffer();
        this.currentPosition = this.buffer.position();
        this.prepInfo = null;
    }

    public PrepInfoParcel getPrepInfo() {
        return this.prepInfo;
    }

    public void setPrepInfo(PrepInfoParcel prepInfoParcel) {
        this.prepInfo = prepInfoParcel;
    }

    public void clearMultiPartRecordParcel() {
        this.initialMultiPartRecordParcel = null;
    }
}

