/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;

public class PrepInfoItemDecimal
extends PrepInfoItem {
    private int precision;
    private int scale;
    private int shiftBits;

    public PrepInfoItemDecimal(Log log, short s, int n) {
        super(log, s);
        this.shiftBits = n;
    }

    public Object produce(TDPacketStream tDPacketStream, boolean bl) throws SQLException {
        BigInteger bigInteger = null;
        Long l = null;
        long l2 = this.getLongDataLen();
        this.precision = (int)(l2 >>> this.shiftBits);
        this.scale = (int)(l2 & 0x7FL);
        if (this.precision <= 2) {
            l = new Long(tDPacketStream.get());
        } else if (this.precision <= 4) {
            l = new Long(tDPacketStream.getShort());
        } else if (this.precision <= 9) {
            l = new Long(tDPacketStream.getInt());
        } else if (this.precision <= 18) {
            l = new Long(tDPacketStream.getLong());
        } else if (this.precision <= 38) {
            bigInteger = tDPacketStream.get16ByteBigInteger();
        } else {
            throw ErrorFactory.makeDriverJDBCException("TJ373", this.precision);
        }
        if (bigInteger == null) {
            return bl ? null : BigDecimal.valueOf(l, this.scale);
        }
        return bl ? null : new BigDecimal(bigInteger, this.scale);
    }

    public int getScale() {
        return this.scale;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setDataLen(long l) {
        super.setDataLen(l);
        this.precision = (int)(l >>> this.shiftBits);
        this.scale = (int)(l & 0x7FL);
    }
}

