/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;

public class RecordParcel
extends Parcel {
    private byte[] nullIndicators;
    private Object[] columnValues;
    private int[] bitMasks = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    private static long time = 0L;
    private int savedIndex;

    RecordParcel(TDPacketStream tDPacketStream, SuccessParcel successParcel, PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator, String string, Log log) throws SQLException {
        super(log);
        this.initResponseParcel(tDPacketStream, string);
        if (successParcel != null && ActivityAnalyzer.isHUTConfig(successParcel.getActivityType())) {
            this.parseHUTConfig(tDPacketStream);
        } else if (successParcel != null && ActivityAnalyzer.isDBCCONSpartition(successParcel)) {
            this.columnValues = new Object[1];
            this.readVarChar(tDPacketStream);
        } else if (prepInfoItemIterator != null) {
            this.setup(tDPacketStream, prepInfoItemIterator.count());
            this.buildColumns(tDPacketStream, prepInfoItemIterator);
        } else {
            this.setup(tDPacketStream, 1);
            this.readVarChar(tDPacketStream);
        }
    }

    private void parseHUTConfig(TDPacketStream tDPacketStream) throws SQLException {
        short s;
        int n;
        this.columnValues = new Object[7];
        this.columnValues[0] = new Integer(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort()));
        this.columnValues[1] = new Integer(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort()));
        this.columnValues[2] = new Integer(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort()));
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (n = 0; n < (Integer)this.columnValues[1]; ++n) {
            string = string != null ? string + "," + String.valueOf(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort())) : String.valueOf(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort()));
            string2 = string2 != null ? string2 + "," + String.valueOf(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort())) : String.valueOf(UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort()));
            s = tDPacketStream.getShort();
        }
        this.columnValues[3] = string;
        this.columnValues[4] = string2;
        for (n = 0; n < (Integer)this.columnValues[2]; ++n) {
            string3 = string3 != null ? string3 + "," + String.valueOf(tDPacketStream.get() & 0xFF) : String.valueOf(tDPacketStream.get() & 0xFF);
            s = tDPacketStream.get();
            s = tDPacketStream.getShort();
            string4 = string4 != null ? string4 + "," + String.valueOf(tDPacketStream.get() & 0xFF) : String.valueOf(tDPacketStream.get() & 0xFF);
            s = tDPacketStream.get();
        }
        this.columnValues[5] = string3;
        this.columnValues[6] = string4;
    }

    private void readVarChar(TDPacketStream tDPacketStream) throws SQLException {
        int n = UnsignedConversions.convertUnsignedShort(tDPacketStream.getShort());
        this.columnValues[0] = tDPacketStream.getString(n, super.getCharSetName());
    }

    protected void buildColumns(TDPacketStream tDPacketStream, PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator) throws SQLException {
        boolean bl = false;
        int n = this.savedIndex;
        while (tDPacketStream.position() < tDPacketStream.limit() && prepInfoItemIterator.hasNext()) {
            bl = false;
            if ((this.nullIndicators[n / 8] & this.bitMasks[n % 8]) / this.bitMasks[n % 8] == 1) {
                bl = true;
            }
            this.columnValues[n] = prepInfoItemIterator.next().produce(tDPacketStream, bl);
            this.savedIndex = n++;
        }
    }

    protected void setup(TDPacketStream tDPacketStream, int n) {
        this.columnValues = new Object[n];
        int n2 = (n + 7) / 8;
        this.nullIndicators = new byte[n2];
        tDPacketStream.get(this.nullIndicators);
    }

    public RecordParcelColumnValuesIterator getRecordParcelColumnValuesIterator() {
        return new RecordParcelColumnValuesIterator();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("RecordParcel  *******************\n");
        for (int i = 0; i < this.columnValues.length; ++i) {
            if (this.columnValues[i] != null) {
                stringBuffer.append(this.columnValues[i].toString() + '\n');
                continue;
            }
            stringBuffer.append("NULL VALUE\n");
        }
        stringBuffer.append("RecordParcel END *****************\n");
        return stringBuffer.toString();
    }

    public class RecordParcelColumnValuesIterator {
        private int index = 0;

        public boolean hasNext() {
            return RecordParcel.this.columnValues != null ? this.index < RecordParcel.this.columnValues.length : false;
        }

        public Object next() {
            return this.hasNext() ? RecordParcel.this.columnValues[this.index++] : null;
        }
    }
}

