/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.UnsupportedEncodingException;

public class RequestParcel
extends Parcel {
    protected byte[] requestText;
    public static final int LENGTH = 4;

    public RequestParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)1);
    }

    public void setRequestText(String string) throws JDBCException {
        try {
            this.requestText = string.getBytes(super.getCharSetName());
            this.setLength(4 + this.requestText.length);
            this.createBuffer(this.getLength());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw ErrorFactory.makeDriverJDBCException("TJ309", unsupportedEncodingException.getMessage());
        }
    }

    public void setRequestText(byte[] byArray) {
        this.requestText = byArray;
        this.setLength(4 + this.requestText.length);
        this.createBuffer(this.getLength());
    }

    public void setRequestText(byte[] byArray, int n, int n2) {
        this.requestText = new byte[n2];
        System.arraycopy(byArray, n, this.requestText, 0, n2);
        this.setLength(4 + this.requestText.length);
        this.createBuffer(this.getLength());
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        this.buffer.put(this.requestText);
        this.buffer.flip();
        return this.buffer;
    }
}

