/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import java.sql.SQLException;

public class ResultSetParcel
extends Parcel {
    private long startingRowPosition;
    private String databaseName;
    private String procedureName;

    public ResultSetParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(string, log);
        this.initResponseParcel(tDPacketStream, string);
        this.startingRowPosition = tDPacketStream.getLong();
        int n = tDPacketStream.getUnsignedShort();
        this.databaseName = tDPacketStream.getString(n, this.getCharSetName());
        n = tDPacketStream.getUnsignedShort();
        this.procedureName = tDPacketStream.getString(n, this.getCharSetName());
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public long getStartingRowPosition() {
        return this.startingRowPosition;
    }

    public String toString() {
        return " startingRowPosition = " + this.startingRowPosition + " databaseName = " + this.databaseName + " procedureName = " + this.procedureName;
    }
}

