/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.ResultSetSelectionItem;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.util.ArrayList;

public class ResultSetSelectionParcel
extends Parcel {
    public static final byte RETURN_ALL = 0;
    public static final byte RETURN_FROM_POSITION = 1;
    public static final byte SELECT_SPECIFIC_LIST = 2;
    private byte m_returnOption = (byte)2;
    private ArrayList m_rsSelectItems;

    public ResultSetSelectionParcel(ArrayList arrayList, Log log) {
        super(log);
        this.m_rsSelectItems = arrayList;
        if (log.isDebugEnabled()) {
            log.debug("ResultSetSelectionParcel constructor this=" + this);
        }
        this.setFlavor((short)179);
        this.setLength(5 + 16 * this.m_rsSelectItems.size());
        this.createBuffer(this.getLength());
    }

    public TDPacketStream toStream() throws JDBCException {
        super.toStream();
        this.buffer.put(this.m_returnOption);
        for (int i = 0; i < this.m_rsSelectItems.size(); ++i) {
            ResultSetSelectionItem resultSetSelectionItem = (ResultSetSelectionItem)this.m_rsSelectItems.get(i);
            this.buffer.putShort((short)resultSetSelectionItem.getStatementNumber());
            this.buffer.putInt(resultSetSelectionItem.getRequestNumber());
            this.buffer.putShort((short)0);
            this.buffer.putLong(resultSetSelectionItem.getRowNumber());
        }
        this.buffer.flip();
        return this.buffer;
    }

    public String toString() {
        return super.toString() + "(" + "returnOption=" + this.m_returnOption + " rsSelectionItems=" + this.m_rsSelectItems + ")";
    }
}

