/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class SSORequestParcel
extends Parcel {
    public static final byte AUTHTERADATA = 8;
    public static final byte AUTHNOTSPECIFIED = 0;
    public static final int LENGTH = 8;
    private byte method = (byte)8;
    private byte trip = 0;
    private byte[] authData = null;

    public SSORequestParcel(Log log) {
        this("ASCII", log);
    }

    public SSORequestParcel(String string, Log log) {
        super(string, log);
        this.setFlavor((short)132);
        this.setLength(8);
    }

    public byte getMethod() {
        return this.method;
    }

    public void setMethod(byte by) {
        this.method = by;
    }

    public byte getTrip() {
        return this.trip;
    }

    public void setTrip(byte by) {
        this.trip = by;
    }

    public short getAuthDataLen() {
        return (short)this.authData.length;
    }

    public byte[] getAuthData() {
        return this.authData;
    }

    public void setAuthData(byte[] byArray) throws JDBCException {
        this.authData = byArray;
        this.setLength(8 + byArray.length);
    }

    public TDPacketStream toStream() throws JDBCException {
        this.createBuffer(this.getLength());
        super.toStream();
        this.buffer.put(this.method);
        this.buffer.put(this.trip);
        this.buffer.putShort((short)this.authData.length);
        this.buffer.put(this.authData, 0, this.authData.length);
        this.buffer.flip();
        return this.buffer;
    }
}

