/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoField;
import com.teradata.jdbc.jdbc_4.parcel.FullContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.LimitedContentMetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.MetadataItem;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoXParcel;
import com.teradata.jdbc.jdbc_4.util.JDBC4Constants;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public class StatementInfoParcel
extends PrepInfoXParcel {
    private DataInfoField[] dataInfoField;
    private ArrayList listParameterMarkerMetadataItems = new ArrayList();
    private ArrayList listRSColumnMetadataItems = new ArrayList();
    private ArrayList listRSSummaryMetadataItems = new ArrayList();
    private ArrayList listAGKColumnMetadataItems = new ArrayList();
    private ArrayList listSPParameterMetadataItems = new ArrayList();
    private ArrayList listSPColumnMetadataItems = new ArrayList();
    private static final String LINE_SEP = System.getProperty("line.separator");

    public StatementInfoParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(tDPacketStream, string, log);
        MetadataItem metadataItem;
        block9: for (int i = this.bodyLength(); i > 0; i -= metadataItem.getHeaderLength() + metadataItem.getItemLength()) {
            metadataItem = this.createMetadataItem(tDPacketStream);
            if (metadataItem.getItemLayoutType() == 4) continue;
            switch (metadataItem.getItemContentType()) {
                case 1: {
                    this.listParameterMarkerMetadataItems.add(metadataItem);
                    continue block9;
                }
                case 2: {
                    this.listRSColumnMetadataItems.add(metadataItem);
                    continue block9;
                }
                case 3: {
                    this.listRSSummaryMetadataItems.add(metadataItem);
                    continue block9;
                }
                case 4: {
                    this.listAGKColumnMetadataItems.add(metadataItem);
                    continue block9;
                }
                case 5: {
                    this.listSPParameterMetadataItems.add(metadataItem);
                    continue block9;
                }
                case 6: {
                    this.listSPColumnMetadataItems.add(metadataItem);
                    continue block9;
                }
                case 7: {
                    continue block9;
                }
            }
        }
        this.translateSIPintoPrepInfoItem(string, log);
    }

    public StatementInfoParcel(String string, Log log, ArrayList arrayList) throws SQLException {
        super(string, log);
        this.listRSColumnMetadataItems.addAll(arrayList);
        this.translateSIPintoPrepInfoItem(string, log);
    }

    private void translateSIPintoPrepInfoItem(String string, Log log) throws SQLException {
        ArrayList arrayList = this.listRSColumnMetadataItems != null && this.listRSColumnMetadataItems.size() > 0 ? this.listRSColumnMetadataItems : (this.listSPParameterMetadataItems != null && this.listSPParameterMetadataItems.size() > 0 ? this.listSPParameterMetadataItems : (this.listSPColumnMetadataItems != null && this.listSPColumnMetadataItems.size() > 0 ? this.listSPColumnMetadataItems : (this.listAGKColumnMetadataItems != null && this.listAGKColumnMetadataItems.size() > 0 ? this.listAGKColumnMetadataItems : null)));
        ArrayList<PrepInfoItem> arrayList2 = new ArrayList<PrepInfoItem>();
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                LimitedContentMetadataItem limitedContentMetadataItem = (LimitedContentMetadataItem)iterator.next();
                if (JDBC4Constants.getTDTypeParameterMode(limitedContentMetadataItem.getDataType()) == 1) continue;
                PrepInfoItem prepInfoItem = StatementInfoParcel.createPrepInfoItem(log, limitedContentMetadataItem.getDataType(), this.decimalShift());
                arrayList2.add(prepInfoItem);
                prepInfoItem.setDataLen(limitedContentMetadataItem.getPrepInfoDataLength(this.decimalShift()));
                prepInfoItem.setCharSetName(string);
                if (!(limitedContentMetadataItem instanceof FullContentMetadataItem)) continue;
                FullContentMetadataItem fullContentMetadataItem = (FullContentMetadataItem)limitedContentMetadataItem;
                prepInfoItem.setColumnExtInfo(fullContentMetadataItem.getColumnExtInfo());
                prepInfoItem.setColumnName(fullContentMetadataItem.getCustomerVisibleColumnName());
                prepInfoItem.setColumnFormat(fullContentMetadataItem.getFormat());
                prepInfoItem.setColumnTitle(fullContentMetadataItem.getTitle());
            }
        }
        this.items = arrayList2.toArray(new PrepInfoItem[0]);
    }

    private MetadataItem createMetadataItem(TDPacketStream tDPacketStream) throws SQLException {
        MetadataItem metadataItem;
        short s = tDPacketStream.getShort();
        short s2 = tDPacketStream.getShort();
        short s3 = tDPacketStream.getShort();
        switch (s) {
            case 1: {
                metadataItem = new FullContentMetadataItem(s, s2, s3);
                break;
            }
            case 2: {
                metadataItem = new LimitedContentMetadataItem(s, s2, s3);
                break;
            }
            default: {
                metadataItem = new MetadataItem(s, s2, s3);
            }
        }
        metadataItem.readItemBody(tDPacketStream, this.charSetName);
        return metadataItem;
    }

    public ArrayList getParameterMarkerMetadataItems() {
        return this.listParameterMarkerMetadataItems;
    }

    public ArrayList getRSColumnMetadataItems() {
        return this.listRSColumnMetadataItems;
    }

    public ArrayList getRSSummaryMetadataItems() {
        return this.listRSSummaryMetadataItems;
    }

    public ArrayList getAGKColumnMetadataItems() {
        return this.listAGKColumnMetadataItems;
    }

    public ArrayList getSPParameterMetadataItems() {
        return this.listSPParameterMetadataItems;
    }

    public ArrayList getSPColumnMetadataItems() {
        return this.listSPColumnMetadataItems;
    }

    public StatementInfoParcel(String string, Log log, boolean bl, DataInfoField[] dataInfoFieldArray, int n) {
        super(string, log);
        this.setAltHeader(bl);
        this.setFlavor(bl ? (short)-32599 : 169);
        this.dataInfoField = new DataInfoField[n];
        if (dataInfoFieldArray != null) {
            int n2 = 0;
            for (int i = 0; i < dataInfoFieldArray.length; ++i) {
                if (dataInfoFieldArray[i] == null || dataInfoFieldArray[i].getType() <= 0) continue;
                this.dataInfoField[n2++] = dataInfoFieldArray[i];
            }
        }
    }

    public static int getParcelLength(boolean bl, int n) {
        return Parcel.calculateHeaderLength(bl) + n * 22 + 6 + 0;
    }

    public TDPacketStream toStream() throws JDBCException {
        int n = StatementInfoParcel.getParcelLength(this.altHeader, this.dataInfoField.length);
        this.setLength(n);
        this.createBuffer(this.getLength());
        super.toStream();
        if (this.dataInfoField != null) {
            for (int i = 0; i < this.dataInfoField.length; ++i) {
                this.buffer.putShort((short)2);
                this.buffer.putShort((short)8);
                this.buffer.putShort((short)16);
                this.buffer.putShort((short)this.dataInfoField[i].getType());
                this.buffer.putLong(484 == JDBC4Constants.getTDBasicType(this.dataInfoField[i].getType()) ? (long)(this.dataInfoField[i].getPrecision() <= 2 ? 1 : (this.dataInfoField[i].getPrecision() <= 4 ? 2 : (this.dataInfoField[i].getPrecision() <= 9 ? 4 : (this.dataInfoField[i].getPrecision() <= 18 ? 8 : 16)))) : this.dataInfoField[i].getLength());
                this.buffer.putShort((short)this.dataInfoField[i].getPrecision());
                this.buffer.putShort((short)0);
                this.buffer.putShort((short)this.dataInfoField[i].getScale());
            }
        }
        this.buffer.putShort((short)4);
        this.buffer.putShort((short)8);
        this.buffer.putShort((short)0);
        this.buffer.flip();
        return this.buffer;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(LINE_SEP).append("*** StatementInfoParcel ***").append(LINE_SEP).append(LINE_SEP);
        ArrayList[] arrayListArray = new ArrayList[]{this.listParameterMarkerMetadataItems, this.listRSColumnMetadataItems, this.listRSSummaryMetadataItems, this.listAGKColumnMetadataItems, this.listSPParameterMetadataItems, this.listSPColumnMetadataItems};
        for (int i = 0; i < arrayListArray.length; ++i) {
            stringBuffer.append("*** Begin List with ").append(arrayListArray[i].size()).append(" items ***").append(LINE_SEP).append(LINE_SEP);
            Iterator iterator = arrayListArray[i].iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next().toString()).append(LINE_SEP);
            }
            stringBuffer.append("*** End of List ***").append(LINE_SEP).append(LINE_SEP);
        }
        return stringBuffer.toString();
    }
}

