/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.parcel;

import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import com.teradata.jdbc.jdbc_4.util.UnsignedConversions;
import java.sql.SQLException;

public class SuccessParcel
extends Parcel {
    private short statementNumber;
    private int activityCount;
    private short warningCode;
    private short fieldCount;
    private short activityType;
    private String warningMessage;
    private short len;

    public SuccessParcel(TDPacketStream tDPacketStream, String string, Log log) throws SQLException {
        super(log);
        this.initResponseParcel(tDPacketStream, string);
        this.statementNumber = tDPacketStream.getShort();
        this.activityCount = tDPacketStream.getInt();
        this.warningCode = tDPacketStream.getShort();
        this.fieldCount = tDPacketStream.getShort();
        this.activityType = tDPacketStream.getShort();
        this.len = tDPacketStream.getShort();
        int n = UnsignedConversions.convertUnsignedShort(this.len);
        if (n > 0) {
            this.warningMessage = tDPacketStream.getString(n, this.getCharSetName());
        }
    }

    public TDPacketStream toStream() throws JDBCException {
        return super.toStream();
    }

    public short getStatementNumber() {
        return this.statementNumber;
    }

    public int getActivityCount() {
        return this.activityCount;
    }

    public short getWarningCode() {
        return this.warningCode;
    }

    public short getFieldCount() {
        return this.fieldCount;
    }

    public short getActivityType() {
        return this.activityType;
    }

    public String getWarningMessage() {
        return this.warningMessage;
    }
}

