/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.CreateProcedureStatement;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicRequestParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.MultiTSRParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiTSRParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.SPOptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.SPOptionsParcelAltHeader;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class CreateProcedureStatementSendState
extends StatementSendState {
    private boolean firstPass = true;
    private boolean isLast = false;
    int MaxSegmentSize;
    int MaximumNumberOfSegments;
    short sequenceNumber = 1;
    private byte[] text;
    protected static final int MAX_APH_SEG_SIZE = 999500;
    protected int srcPosition = 0;

    public CreateProcedureStatementSendState(StatementController statementController) {
        super(statementController);
        this.MaxSegmentSize = statementController.getSession().getMaximumSegmentSize();
        this.MaximumNumberOfSegments = statementController.getSession().getMaximumNumberOfSegments();
    }

    public TDParcelState action() throws JDBCException {
        String string = this.getController().getSession().getCharSet();
        if (this.firstPass) {
            this.text = this.convertQueryToBytes(this.getController().getQuery(), string);
            this.altHeaderRequired();
        }
        String string2 = this.getQuery();
        this.initPacket();
        this.initMultiTSR(string);
        if (this.firstPass) {
            this.initOptions(string, this.getController().getMode(), this.getController().getLobSelect());
        }
        this.initIndic(string, string2);
        if (this.firstPass) {
            this.initSPOptions(string);
        }
        this.initRsp(string);
        if (!this.firstPass) {
            this.getController().getStatement().initResults();
        }
        this.sendPacket();
        return this.returnToController();
    }

    private String getQuery() throws JDBCException {
        String string;
        if (this.isAltHeader()) {
            string = this.getController().getQuery();
            if (this.text.length - this.srcPosition <= 999500) {
                this.isLast = true;
            }
        } else {
            String string2 = this.getController().getQuery();
            int n = string2.length();
            if (this.MaxSegmentSize == 0) {
                throw ErrorFactory.makeDriverJDBCException("TJ307", this.getController().getSession().getTeradataDatabaseVersion());
            }
            if (n > this.MaxSegmentSize * this.MaximumNumberOfSegments) {
                throw ErrorFactory.makeDriverJDBCException("TJ308", n, this.MaxSegmentSize * this.MaximumNumberOfSegments);
            }
            if (n > this.MaxSegmentSize) {
                int n2 = this.MaxSegmentSize;
                string = string2.substring(0, n2);
                this.getController().setQuery(string2.substring(n2));
            } else {
                this.isLast = true;
                int n3 = n;
                string = string2;
            }
        }
        return string;
    }

    private void initMultiTSR(String string) throws JDBCException {
        MultiTSRParcel multiTSRParcel = null;
        multiTSRParcel = this.isAltHeader() ? new MultiTSRParcelAltHeader(string, this.log) : new MultiTSRParcel(string, this.log);
        short s = this.sequenceNumber;
        this.sequenceNumber = (short)(s + 1);
        multiTSRParcel.setSequenceNumber(s);
        multiTSRParcel.setIsLast(this.isLast);
        this.getPacket().addParcel(multiTSRParcel);
    }

    protected void initIndic(String string, String string2) throws JDBCException {
        IndicRequestParcel indicRequestParcel = null;
        if (this.isAltHeader()) {
            indicRequestParcel = new IndicRequestParcelAltHeader(string, this.log);
            if (this.isLast) {
                indicRequestParcel.setRequestText(this.text, this.srcPosition, this.text.length - this.srcPosition);
            } else {
                indicRequestParcel.setRequestText(this.text, this.srcPosition, 999500);
                this.srcPosition += 999500;
            }
        } else {
            indicRequestParcel = new IndicRequestParcel(string, this.log);
            indicRequestParcel.setRequestText(string2);
        }
        this.getPacket().addParcel(indicRequestParcel);
    }

    protected void initSPOptions(String string) throws JDBCException {
        SPOptionsParcel sPOptionsParcel = null;
        sPOptionsParcel = this.isAltHeader() ? new SPOptionsParcelAltHeader(string, this.log) : new SPOptionsParcel(string, this.log);
        CreateProcedureStatement createProcedureStatement = (CreateProcedureStatement)this.getController().getStatement();
        sPOptionsParcel.setSPLOption(createProcedureStatement.getSPLOption());
        this.getPacket().addParcel(sPOptionsParcel);
        this.firstPass = false;
    }

    protected TDParcelState returnToController() {
        StatementReceiveState statementReceiveState = new StatementReceiveState(this.getController());
        this.controller.setHistoricalReturnState(this.isLast ? null : this);
        return statementReceiveState;
    }

    protected void altHeaderRequired() {
        this.bufferSize = 59 + OptionsParcel.standardOptionsParcelLength(this.controller.getSession()) + 4 + 6 + 6 + this.text.length;
        if (this.bufferSize > 65104 && this.controller.getSession().isAphSupported()) {
            this.altHeader = true;
            this.bufferSize += 20;
        }
        this.log.debug("USING ALTHEADER : " + this.altHeader);
        this.log.debug("Buffer size needed is: " + this.bufferSize);
    }
}

