/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.LobProcessDataSubState;
import com.teradata.jdbc.jdbc_4.statemachine.LobReceiveController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class LobProcessDataInitSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private LobReceiveController controller;
    private LobStream lobStream = null;
    private boolean firstTime = true;
    private long blobLength;
    private long bytesRead = 0L;
    protected Log log;

    public LobProcessDataInitSubState(StatementReceiveState statementReceiveState) {
        this.compositeState = statementReceiveState;
        this.controller = (LobReceiveController)statementReceiveState.getController();
        this.log = this.controller.getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        LobProcessDataSubState lobProcessDataSubState;
        block12: {
            block11: {
                lobProcessDataSubState = null;
                Parcel parcel = this.compositeState.getNextParcel();
                if (parcel == null) break block11;
                this.log.debug("Event flavor: " + parcel.getFlavor());
                this.log.debug("StatementState: " + this.controller.getStatement().getState());
                short s = parcel.getFlavor();
                switch (s) {
                    case 8: {
                        int n = this.controller.packet.nextParcelPeek();
                        while (n != 144 && n != -1) {
                            if (this.compositeState.getNextParcel() == null) {
                                this.log.error("Parcel state exception: " + n);
                                throw ErrorFactory.makeDriverJDBCException("TJ305", n);
                            }
                            n = this.controller.packet.nextParcelPeek();
                        }
                        lobProcessDataSubState = new LobProcessDataSubState(this.compositeState);
                        break block12;
                    }
                    case 9: {
                        FailureParcel failureParcel = (FailureParcel)parcel;
                        this.log.debug("Failure parcel received: " + failureParcel.getMsg());
                        switch (this.controller.getStatement().getState()) {
                            case 9: {
                                this.controller.getStatement().setState(11);
                                this.compositeState.setPacketInUse(false);
                                break block12;
                            }
                            case 10: {
                                this.controller.getStatement().setState(11);
                                this.compositeState.setPacketInUse(false);
                                this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ057"));
                                break block12;
                            }
                            default: {
                                throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                            }
                        }
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        this.log.debug("Error parcel received: " + errorParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                    }
                    default: {
                        this.log.error("Parcel state exception: " + parcel.getFlavor());
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                    }
                }
            }
            this.log.error("Parcel state exception: parcel is null");
            throw ErrorFactory.makeIoJDBCException("TJ330", "LobProcessDataInitSubState", this.controller.getNetworkIO(), null, this.log);
        }
        return lobProcessDataSubState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

