/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ifsupport.LobBuffer;
import com.teradata.jdbc.jdbc_4.ifsupport.LobStream;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.LobReceiveController;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceivePauseSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class LobProcessDataSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private LobReceiveController controller;
    private LobStream lobStream = null;
    private LobBuffer lobData;
    private boolean bLengthRead = false;
    private boolean bNullIndicatorRead = false;
    private long blobLength;
    private long bytesRead = 0L;
    protected Log log;

    public LobProcessDataSubState(StatementReceiveState statementReceiveState) {
        this.compositeState = statementReceiveState;
        this.controller = (LobReceiveController)statementReceiveState.getController();
        this.log = this.controller.getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        if (this.controller.packet.nextParcelPeek() == 144) {
            return this.processMultiPartRecord();
        }
        return this.processOtherParcel();
    }

    private TDParcelState processMultiPartRecord() throws SQLException {
        TDPacketStream tDPacketStream = this.controller.packet.getBuffer();
        int n = this.controller.packet.getCurrentPosition();
        int n2 = 0;
        tDPacketStream.position(n);
        Parcel.ParcelHeader parcelHeader = Parcel.readParcelHeader(tDPacketStream, this.log);
        int n3 = parcelHeader.length;
        if (this.log.isDebugEnabled()) {
            this.log.debug("processMultiPartRecord: null indicator read = " + this.bNullIndicatorRead + " length read = " + this.bLengthRead);
        }
        if (!this.bLengthRead) {
            int n4 = tDPacketStream.position();
            if (parcelHeader.bodyLength() >= 1 && !this.bNullIndicatorRead) {
                tDPacketStream.get();
                this.bNullIndicatorRead = true;
            }
            if (parcelHeader.bodyLength() >= 8) {
                this.blobLength = tDPacketStream.getLong();
                int n5 = tDPacketStream.position() - n4;
                n2 = parcelHeader.bodyLength() - n5;
                this.lobStream = this.controller.getLobStream();
                this.lobStream.setLength(this.blobLength);
                this.bLengthRead = true;
                this.lobData = new LobBuffer(this.controller, this.log);
                this.lobData.setLobLength(this.blobLength);
                this.lobStream.setBuffer(this.lobData);
            }
        } else {
            n2 = parcelHeader.bodyLength();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("processMultiPartRecord: packetSize=" + n3 + " bodyLength=" + parcelHeader.bodyLength() + " bytesToRead=" + n2);
        }
        if (n2 > 0) {
            this.lobData.addBufferRecord(tDPacketStream, n2);
        }
        this.controller.packet.skipParcel(n3);
        this.bytesRead += (long)n2;
        if (this.controller.packet.nextParcelPeek() == -1) {
            return new ReceivePauseSubState(this.compositeState, this, new StatementContinueState(this.compositeState.getController(), this.compositeState));
        }
        return this;
    }

    private TDParcelState processOtherParcel() throws SQLException {
        TDParcelState tDParcelState;
        block7: {
            block6: {
                tDParcelState = null;
                Parcel parcel = this.compositeState.getNextParcel();
                if (parcel == null) break block6;
                this.log.debug("Event flavor: " + parcel.getFlavor());
                this.log.debug("StatementState: " + this.controller.getStatement().getState());
                switch (parcel.getFlavor()) {
                    case 11: 
                    case 145: {
                        tDParcelState = this;
                        break block7;
                    }
                    case 12: {
                        if (this.controller.getStatement().getState() == 5) {
                            this.controller.getStatement().setState(6);
                        }
                        this.lobData.setEndOfFile();
                        break block7;
                    }
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        this.log.debug("Error parcel received: " + errorParcel.getMsg());
                        throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                    }
                    default: {
                        this.log.error("Parcel state exception: " + parcel.getFlavor());
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                    }
                }
            }
            tDParcelState = new ReceiveContinueSubState(this.compositeState, this);
        }
        return tDParcelState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

