/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.interfaces.Lob;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.io.TDPacketStream;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveElicitDataReceivedSubState;
import com.teradata.jdbc.jdbc_4.statemachine.SendState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementAbortState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.io.IOException;
import java.sql.SQLException;

public class LobSendState
extends SendState {
    private Lob lob;
    private int lobToken;
    private TDPacketStream buffer;
    private boolean eof = false;
    private boolean needLength = true;
    private String charSet;
    private boolean altHeader;
    private long lobBytesSent = 0L;

    public LobSendState(StatementController statementController, int n) {
        super(statementController);
        this.lobToken = n;
        this.charSet = statementController.getSession().getCharSet();
        this.altHeader = false;
        this.lobBytesSent = 0L;
    }

    public TDParcelState action() throws SQLException {
        int n = 0;
        try {
            if (this.lob == null) {
                this.lob = this.initLob();
            }
        }
        catch (SQLException sQLException) {
            return this.sendAbort(sQLException);
        }
        if (this.controller.getStatement().abortLobTransfer()) {
            return this.sendAbort(null);
        }
        this.initPacket();
        this.buffer = this.packet.getBuffer();
        try {
            n = this.putMultiPartData();
            n += this.putLobData();
            n += this.putLength(n);
            if (this.lob.eof()) {
                n += this.putEndMultiPart();
                this.eof = true;
            }
        }
        catch (IOException iOException) {
            JDBCException jDBCException = ErrorFactory.makeDriverJDBCException("TJ363", iOException.getMessage());
            jDBCException.initCause(iOException);
            return this.sendAbort(jDBCException);
        }
        this.packet.addToMsgLength(n);
        this.sendPacket();
        this.log.debug("Sending " + n + " of data");
        this.log.debug("Total LOB data sent so far: " + this.lobBytesSent);
        return this.returnToController();
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    protected void initPacket() throws JDBCException {
        if (this.altHeader) {
            super.initPacket(1048500);
        } else {
            super.initPacket(65104);
        }
        this.packet.setLANClass((byte)2);
        this.packet.setLANKind((byte)13);
        this.packet.setRequestNumber(this.controller.getCurrentRequestNumber());
    }

    private int putMultiPartData() {
        if (this.altHeader) {
            this.buffer.putShort((short)-32628);
        } else {
            this.buffer.putShort((short)140);
        }
        return 2;
    }

    private int putEndMultiPart() {
        if (this.altHeader) {
            this.buffer.putShort((short)-32627);
            this.buffer.putShort((short)0);
            this.buffer.putInt(8);
            return 8;
        }
        this.buffer.putShort((short)141);
        this.buffer.putShort((short)4);
        return 4;
    }

    private int putLength(int n) {
        if (this.altHeader) {
            this.buffer.putShort(54, (short)0);
            this.buffer.putInt(56, n + 6);
            return 6;
        }
        this.buffer.putShort(54, (short)(n + 2));
        return 2;
    }

    private int putLobData() throws IOException, SQLException {
        int n = 0;
        if (this.altHeader) {
            this.buffer.position(60);
        } else {
            this.buffer.position(56);
        }
        if (this.needLength) {
            this.buffer.putLong(0L);
            this.needLength = false;
            n += 8;
        }
        int n2 = this.lob.write(this.buffer, this.maxSize(), this.charSet);
        this.lobBytesSent += (long)n2;
        return n += n2;
    }

    private TDParcelState returnToController() {
        StatementReceiveState statementReceiveState = new StatementReceiveState(this.controller);
        if (!this.eof) {
            ReceiveElicitDataReceivedSubState receiveElicitDataReceivedSubState = new ReceiveElicitDataReceivedSubState(statementReceiveState, this);
            statementReceiveState.setHistoricalState(receiveElicitDataReceivedSubState);
        }
        return statementReceiveState;
    }

    private Lob initLob() throws SQLException {
        PreparedStatement preparedStatement = (PreparedStatement)this.controller.getStatement();
        this.lob = null;
        for (int i = 0; this.lob == null && i < preparedStatement.getParameterProperties().numberOfParamSets() && preparedStatement.getParameterProperties().getParameterSet(i) != null; ++i) {
            this.lob = (Lob)preparedStatement.getParameterProperties().getParameterSet(i).getDeferredLobs().remove(new Integer(this.lobToken));
        }
        if (this.lob == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ312", "LobSendState: No LOB found for token " + this.lobToken);
        }
        this.altHeader();
        return this.lob;
    }

    private void altHeader() throws SQLException {
        if (this.lob.length() > 64000L) {
            this.altHeader = true;
        }
        this.altHeader = false;
    }

    private int maxSize() {
        if (this.altHeader) {
            return 1024000;
        }
        return 64000;
    }

    private TDParcelState sendAbort(SQLException sQLException) throws JDBCException {
        this.log.debug("LOBSendState: Sending an Abort Message");
        StatementAbortState statementAbortState = new StatementAbortState(this.controller);
        statementAbortState.setUCAbort(true);
        this.controller.setStoredException(sQLException);
        return statementAbortState;
    }
}

