/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.PreparedStatement;
import com.teradata.jdbc.jdbc_4.Statement;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.ifsupport.Result;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedBatchStatementSendState;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedStatementController;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;
import java.util.ArrayList;

public class PreparedBatchStatementController
extends PreparedStatementController {
    private PreparedBatchStatementSendState batchSendState;

    public PreparedBatchStatementController(Statement statement, TDSession tDSession, String string) throws JDBCException {
        super(statement, tDSession, string);
    }

    public void addResults(ArrayList arrayList) {
        this.getStatement().getResults().addBatchResults(arrayList);
    }

    public void run() throws SQLException {
        TDParcelState tDParcelState = null;
        ParameterProperties parameterProperties = ((PreparedStatement)this.getStatement()).getParameterProperties();
        if (this.getHistoricalState() == null) {
            tDParcelState = new PreparedBatchStatementSendState(this);
            this.batchSendState = (PreparedBatchStatementSendState)tDParcelState;
            this.clearStatementStateLock = true;
        } else {
            tDParcelState = this.getHistoricalState();
            this.setHistoricalState(null);
        }
        this.runBody(tDParcelState);
    }

    protected TDParcelState handleRunException(SQLException sQLException) throws JDBCException {
        int n = sQLException.getErrorCode();
        if (!this.getSession().getAutoCommit() && !this.getSession().isAnsiMode()) {
            this.setTeraCommitOffResults(n);
        } else {
            this.setStandardResults(n);
        }
        return this.getNextState(n);
    }

    private TDParcelState setStandardResults(int n) throws JDBCException {
        int n2 = this.getNumberOfFailedStatements(n);
        this.addResults(this.initFailedResults(n2));
        return null;
    }

    private void setTeraCommitOffResults(int n) throws JDBCException {
        int n2 = ((PreparedStatement)this.getStatement()).getNumberOfBatchStatements();
        if (n < 2000 && n != 751) {
            this.addResults(this.initFailedResults(n2 -= this.getStatement().getResults().getResultsSize()));
        } else {
            this.getStatement().getResults().reinit();
            this.addResults(this.initFailedResults(n2));
        }
    }

    private TDParcelState getNextState(int n) throws JDBCException {
        if (this.batchSendState.paramProperties.numberOfParamSetsLeft() > 0 && n >= 2000 && (this.getSession().getAutoCommit() || this.getSession().isAnsiMode()) && n != 751) {
            return this.batchSendState;
        }
        return null;
    }

    private int getNumberOfFailedStatements(int n) {
        int n2 = this.batchSendState.getNumberOfStatementsInSubBatch();
        if (n < 2000 || n == 751 && !this.getSession().isAnsiMode() && this.getSession().getAutoCommit()) {
            n2 = ((PreparedStatement)this.getStatement()).getNumberOfBatchStatements() - this.getStatement().getResults().getResultsSize();
        }
        return n2;
    }

    private ArrayList initFailedResults(int n) {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Result(-3));
        }
        return arrayList;
    }
}

