/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.MetaDataList;
import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartIndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndMultiPartIndicDataParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartIndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.MultiPartIndicDataParcelAltHeader;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class PreparedIndicMultiPartProtocol
extends PreparedIndicProtocol {
    private int numberOfDataParcelsInBuffer;
    private int bufferSize = 0;

    public PreparedIndicMultiPartProtocol(StatementSendState statementSendState, String string, ParameterProperties parameterProperties) throws JDBCException {
        super(statementSendState, string, parameterProperties);
        this.setNumberOfDataParcelsInBuffer();
    }

    void initIndicData() throws JDBCException {
        if (this.paramProperties != null && this.paramProperties.getNumberOfParams() > 0 && this.paramProperties.numberOfParamSetsLeft() > 0) {
            for (int i = 0; i < this.numberOfDataParcelsInBuffer; ++i) {
                super.initIndicData();
                this.initEndMultiPartIndicData();
            }
        }
    }

    protected void initEndMultiPartIndicData() throws JDBCException {
        Log log = this.sendState.getController().getSession().getLog();
        EndMultiPartIndicDataParcel endMultiPartIndicDataParcel = this.sendState.isAltHeader() ? new EndMultiPartIndicDataParcelAltHeader(log) : new EndMultiPartIndicDataParcel(log);
        this.sendState.getPacket().addParcel(endMultiPartIndicDataParcel);
    }

    protected DataInfoParcel getDataInfoParcel() throws JDBCException {
        Log log = this.sendState.getController().getSession().getLog();
        if (this.sendState.isAltHeader()) {
            return new DataInfoXParcelAltHeader(this.paramProperties.getNumberOfParams(), this.charSetName, log);
        }
        return new DataInfoXParcel(this.paramProperties.getNumberOfParams(), this.charSetName, log);
    }

    protected IndicDataParcel getIndicDataParcel() throws JDBCException {
        Log log = this.sendState.getController().getSession().getLog();
        int n = this.paramProperties.getParameterSet().getDataSize() + this.paramProperties.getParameterSet().getNullIndicatorBitsSize();
        if (this.sendState.isAltHeader()) {
            return new MultiPartIndicDataParcelAltHeader(n, this.charSetName, log);
        }
        return new MultiPartIndicDataParcel(n, this.charSetName, log);
    }

    protected int getDataParcelsHeaderLength(boolean bl) {
        int n = 8;
        return n += bl ? 8 : 0;
    }

    protected int getSize() throws JDBCException {
        return this.bufferSize;
    }

    private boolean paramSetIndexPermittedBySQLStatement(int n) throws JDBCException {
        MetaDataList metaDataList = this.sendState.getController().getStatement().getMetaDataList();
        if (metaDataList.size() > 0 && ActivityAnalyzer.outParamResultSet(metaDataList.getFirstMetaData().getActivityType()) && !this.sendState.getController().getSession().getConfigResponse().callSPHasDMLArraySupport()) {
            return n == 0;
        }
        return true;
    }

    protected void setNumberOfDataParcelsInBuffer() throws JDBCException {
        boolean bl = this.sendState.getController().getSession().isAphSupported();
        int n = this.getBaseSize(bl);
        if (this.paramProperties != null && this.paramProperties.getNumberOfParams() > 0) {
            int n2 = 0;
            int n3 = bl ? 1048500 : 65104;
            int n4 = 0;
            for (int i = this.paramProperties.getParameterSetIndex(); i < this.paramProperties.numberOfParamSets() && this.paramSetIndexPermittedBySQLStatement(n4) && n + n2 <= n3; ++i) {
                n += n2;
                n2 = this.getDataParcelsHeaderLength(bl) + this.paramProperties.getDataSize(i);
                ++n4;
            }
            if (n + n2 > n3) {
                --n4;
            } else {
                n += n2;
            }
            this.numberOfDataParcelsInBuffer = n4;
        }
        this.bufferSize = n;
    }

    protected int getNumberOfDataParcelsInBuffer() {
        return this.numberOfDataParcelsInBuffer;
    }
}

