/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.ParameterProperties;
import com.teradata.jdbc.jdbc_4.ParameterSet;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.IndicDataParcelAltHeader;
import com.teradata.jdbc.jdbc_4.parcel.OptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoEndParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementInfoParcel;
import com.teradata.jdbc.jdbc_4.statemachine.PreparedIndicMultiPartProtocol;
import com.teradata.jdbc.jdbc_4.statemachine.StatementSendState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public class PreparedIndicProtocol {
    protected StatementSendState sendState;
    protected String charSetName;
    protected ParameterProperties paramProperties;

    public PreparedIndicProtocol(StatementSendState statementSendState, String string, ParameterProperties parameterProperties) {
        this.sendState = statementSendState;
        this.charSetName = string;
        this.paramProperties = parameterProperties;
    }

    void initDataInfoParcel() throws JDBCException {
        if (this.paramProperties != null && this.paramProperties.getNumberOfParams() > 0) {
            if (this.sendState.getController().getSession().isStatementInfoRequestSupported()) {
                this.sendState.getPacket().addParcel(new StatementInfoParcel(this.charSetName, this.sendState.getController().getSession().getLog(), this.sendState.isAltHeader(), this.paramProperties.getDataInfoFields(), this.paramProperties.getNumberOfParams()));
                this.sendState.getPacket().addParcel(new StatementInfoEndParcel(this.charSetName, this.sendState.isAltHeader(), this.sendState.getController().getSession().getLog()));
                return;
            }
            DataInfoParcel dataInfoParcel = this.getDataInfoParcel();
            dataInfoParcel.setFields(this.paramProperties.getDataInfoFields());
            this.sendState.getPacket().addParcel(dataInfoParcel);
        }
    }

    void initIndicData() throws JDBCException {
        if (this.paramProperties != null && this.paramProperties.getNumberOfParams() > 0) {
            ParameterSet parameterSet = this.paramProperties.getParameterSet();
            IndicDataParcel indicDataParcel = this.getIndicDataParcel();
            indicDataParcel.setParameters(parameterSet.getPreparedParameters());
            indicDataParcel.setNullIndicatorBits(parameterSet.getNullIndicatorBits());
            this.sendState.getPacket().addParcel(indicDataParcel);
            this.paramProperties.setNextParameterSet();
        }
    }

    protected DataInfoParcel getDataInfoParcel() throws JDBCException {
        Log log = this.sendState.getController().getSession().getLog();
        if (this.sendState.isAltHeader()) {
            return new DataInfoParcelAltHeader(this.paramProperties.getNumberOfParams(), this.charSetName, log);
        }
        return new DataInfoParcel(this.paramProperties.getNumberOfParams(), this.charSetName, log);
    }

    protected IndicDataParcel getIndicDataParcel() throws JDBCException {
        Log log = this.sendState.getController().getSession().getLog();
        int n = this.paramProperties.getParameterSet().getDataSize() + this.paramProperties.getParameterSet().getNullIndicatorBitsSize();
        if (this.sendState.isAltHeader()) {
            return new IndicDataParcelAltHeader(n, this.charSetName, log);
        }
        return new IndicDataParcel(n, this.charSetName, log);
    }

    protected int getBaseSize(boolean bl) {
        int n = 52;
        n += OptionsParcel.standardOptionsParcelLength(this.sendState.getController().getSession());
        n += 4 + this.sendState.text.length;
        if (this.paramProperties != null && this.paramProperties.getNumberOfParams() > 0) {
            n += this.sendState.getController().getSession().isStatementInfoRequestSupported() ? StatementInfoParcel.getParcelLength(bl, this.paramProperties.getNumberOfParams()) + StatementInfoEndParcel.calculateHeaderLength(bl) : (this instanceof PreparedIndicMultiPartProtocol ? 8 : 6) + (bl ? 4 : 0) + this.paramProperties.getDataInfoSize();
        }
        n += 6;
        return n += bl ? 12 : 0;
    }

    protected int getDataParcelsHeaderLength(boolean bl) {
        return bl ? 8 : 4;
    }

    protected int getSize() throws JDBCException {
        boolean bl = this.sendState.getController().getSession().isAphSupported();
        int n = this.getBaseSize(bl);
        if (this.paramProperties != null && this.paramProperties.getNumberOfParams() > 0) {
            n += this.getDataParcelsHeaderLength(bl) + this.paramProperties.getDataSize();
        }
        return n;
    }
}

