/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoXParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveBatchRSErrorSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveMultipartRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class ReceiveDataInfoSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private DataInfoParcel currentEvent;
    private TDParcelState returnSubState;
    private boolean batchRSError = false;
    protected Log log = this.log;

    public ReceiveDataInfoSubState(StatementReceiveState statementReceiveState, DataInfoParcel dataInfoParcel) {
        this.compositeState = statementReceiveState;
        this.currentEvent = dataInfoParcel;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TDParcelState action() throws SQLException {
        this.returnSubState = null;
        Parcel parcel = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReceiveDataInfoSubState.action: currentEvent=" + this.currentEvent);
        }
        if (this.stateErrorCheck()) {
            this.batchRSError = true;
            parcel = this.currentEvent;
        } else {
            parcel = this.compositeState.getNextParcel();
        }
        if (parcel != null) {
            switch (parcel.getFlavor()) {
                case 10: {
                    this.returnSubState = !this.batchRSError ? new ReceiveRecordSubState(this.compositeState, (RecordParcel)parcel) : new ReceiveBatchRSErrorSubState(this.compositeState, (RecordParcel)parcel);
                    return this.returnSubState;
                }
                case 144: {
                    this.returnSubState = new ReceiveMultipartRecordSubState(this.compositeState, (RecordParcel)parcel);
                    return this.returnSubState;
                }
                case 11: {
                    this.returnSubState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                    return this.returnSubState;
                }
                case 146: {
                    this.returnSubState = new ReceiveBatchRSErrorSubState(this.compositeState, (DataInfoXParcel)parcel);
                    return this.returnSubState;
                }
                case 71: {
                    this.returnSubState = new ReceiveBatchRSErrorSubState(this.compositeState, (DataInfoParcel)parcel);
                    return this.returnSubState;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    if (errorParcel.getCode() != 3115) throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                    this.returnSubState = new ReceiveContinueSubState(this.compositeState, new ReceiveRecordSubState(this.compositeState, null));
                    return this.returnSubState;
                }
                default: {
                    throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                }
            }
        }
        if (!this.batchRSError) {
            this.compositeState.savePrepInfo();
            this.returnSubState = new ReceiveContinueSubState(this.compositeState, new ReceiveRecordSubState(this.compositeState, null));
            return this.returnSubState;
        } else {
            this.returnSubState = new ReceiveContinueSubState(this.compositeState, new ReceiveBatchRSErrorSubState(this.compositeState));
        }
        return this.returnSubState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    private boolean stateErrorCheck() {
        boolean bl = false;
        if (this.compositeState.getController().getResultTypeExpected() == 5 && ActivityAnalyzer.resultSetExpected(this.compositeState.getActivityType())) {
            bl = true;
        }
        return bl;
    }
}

