/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.ElicitDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.ElicitFileParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SuccessParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ElicitFileState;
import com.teradata.jdbc.jdbc_4.statemachine.LobSendState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveSuccessSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class ReceiveInitSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private StatementController controller;
    protected Log log;

    public ReceiveInitSubState(StatementReceiveState statementReceiveState) {
        this.compositeState = statementReceiveState;
        this.controller = statementReceiveState.getController();
        this.log = this.controller.getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        ReceiveSuccessSubState receiveSuccessSubState;
        block15: {
            block14: {
                receiveSuccessSubState = null;
                Parcel parcel = this.compositeState.getNextParcel();
                this.compositeState.setPacketInUse(false);
                if (parcel == null) break block14;
                this.log.debug("Event flavor: " + parcel.getFlavor());
                this.log.debug("StatementState: " + this.compositeState.getController().getStatement().getState());
                switch (parcel.getFlavor()) {
                    case 8: {
                        receiveSuccessSubState = this.compositeState.getController().getStatement().getState() == 9 ? null : new ReceiveSuccessSubState(this.compositeState, (SuccessParcel)parcel);
                        break block15;
                    }
                    case 9: 
                    case 49: {
                        ErrorParcel errorParcel = (ErrorParcel)parcel;
                        this.log.debug("Error or Failure parcel received: " + errorParcel.getMsg());
                        switch (this.compositeState.getController().getStatement().getState()) {
                            case 9: {
                                this.controller.getStatement().setState(11);
                                break block15;
                            }
                            case 10: {
                                this.controller.getStatement().setState(11);
                                if (this.controller.getStoredException() == null) {
                                    this.controller.setStoredException(ErrorFactory.makeDriverJDBCException("TJ057"));
                                }
                                break block15;
                            }
                            case 5: {
                                this.controller.getStatement().setState(6);
                                receiveSuccessSubState = null;
                                break block15;
                            }
                            default: {
                                throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode(), errorParcel.getInfo());
                            }
                        }
                    }
                    case 12: {
                        if (this.controller.getStatement().getState() == 5) {
                            this.controller.getStatement().setState(6);
                        }
                        receiveSuccessSubState = null;
                        break block15;
                    }
                    case 150: {
                        ElicitDataParcel elicitDataParcel = (ElicitDataParcel)parcel;
                        this.controller.getStatement().setState(12);
                        this.compositeState.setReturnState(new LobSendState(this.controller, elicitDataParcel.getToken()));
                        receiveSuccessSubState = null;
                        break block15;
                    }
                    case 151: {
                        ElicitFileParcel elicitFileParcel = (ElicitFileParcel)parcel;
                        this.controller.getStatement().setState(12);
                        this.compositeState.setReturnState(new ElicitFileState(this.controller, elicitFileParcel.getFileName()));
                        receiveSuccessSubState = null;
                        break block15;
                    }
                    default: {
                        this.log.error("Parcel state exception: " + parcel.getFlavor());
                        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
                    }
                }
            }
            this.log.error("Parcel state exception: parcel is null");
            throw ErrorFactory.makeIoJDBCException("TJ330", "ReceiveInitSubState", this.controller.getNetworkIO(), null, this.log);
        }
        return receiveSuccessSubState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

