/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.jdbc_4.ColumnProperties;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.DataInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoItem;
import com.teradata.jdbc.jdbc_4.parcel.PrepInfoParcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveDataInfoSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveRecordSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class ReceivePrepInfoSubState
implements TDParcelState {
    private StatementReceiveState compositeState;
    private PrepInfoParcel currentEvent;
    protected Log log;

    public ReceivePrepInfoSubState(StatementReceiveState statementReceiveState, PrepInfoParcel prepInfoParcel) {
        this.compositeState = statementReceiveState;
        this.currentEvent = prepInfoParcel;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    private void populateHUTConfig(TeraResultSetMetaData teraResultSetMetaData) {
        ColumnProperties columnProperties = new ColumnProperties();
        columnProperties.setPrecision(10);
        columnProperties.setScale(0);
        columnProperties.setColumnName("TotalAMPCount");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(4);
        columnProperties.setTdType(496);
        columnProperties.setColumnDisplaySize(11);
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties = new ColumnProperties();
        columnProperties.setPrecision(10);
        columnProperties.setScale(0);
        columnProperties.setColumnName("UpAMPCount");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(4);
        columnProperties.setTdType(496);
        columnProperties.setColumnDisplaySize(11);
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties = new ColumnProperties();
        columnProperties.setPrecision(10);
        columnProperties.setScale(0);
        columnProperties.setColumnName("DownAMPCount");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(4);
        columnProperties.setTdType(496);
        columnProperties.setColumnDisplaySize(11);
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties = new ColumnProperties();
        columnProperties.setPrecision(0);
        columnProperties.setScale(0);
        columnProperties.setColumnName("UpAMPPhysicalIDs");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(12);
        columnProperties.setTdType(448);
        columnProperties.setColumnDisplaySize(64000);
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties = new ColumnProperties();
        columnProperties.setPrecision(0);
        columnProperties.setScale(0);
        columnProperties.setColumnName("UpAMPLogicalIDs");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(12);
        columnProperties.setTdType(448);
        columnProperties.setColumnDisplaySize(64000);
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties = new ColumnProperties();
        columnProperties.setPrecision(0);
        columnProperties.setScale(0);
        columnProperties.setColumnName("DownAMPCabinetIDs");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(12);
        columnProperties.setTdType(448);
        columnProperties.setColumnDisplaySize(64000);
        teraResultSetMetaData.addColumnProperties(columnProperties);
        columnProperties = new ColumnProperties();
        columnProperties.setPrecision(0);
        columnProperties.setScale(0);
        columnProperties.setColumnName("DownAMPSlotIDs");
        columnProperties.setColumnLabel(columnProperties.getColumnName());
        columnProperties.setNullable(0);
        columnProperties.setColumnType(12);
        columnProperties.setTdType(448);
        columnProperties.setColumnDisplaySize(64000);
        teraResultSetMetaData.addColumnProperties(columnProperties);
    }

    public TDParcelState action() throws SQLException {
        Object object;
        TDParcelState tDParcelState = null;
        TeraResultSetMetaData teraResultSetMetaData = new TeraResultSetMetaData(this.compositeState.getController().getSession());
        teraResultSetMetaData.setActivityType(this.compositeState.getActivityType());
        teraResultSetMetaData.setPrepInfoParcel(this.currentEvent);
        Parcel parcel = null;
        if (this.log.isDebugEnabled()) {
            this.log.debug("ReceivePrepInfoSubState.action currentEvent=" + this.currentEvent);
        }
        PrepInfoParcel.PrepInfoItemIterator prepInfoItemIterator = this.currentEvent.getPrepInfoItemIterator();
        if (ActivityAnalyzer.isHUTConfig(this.compositeState.getActivityType())) {
            this.populateHUTConfig(teraResultSetMetaData);
        } else if (prepInfoItemIterator.count() > 0) {
            object = this.compositeState.getController().getStatement().getGeneratedKeys();
            int n = 1;
            while (prepInfoItemIterator.hasNext()) {
                PrepInfoItem prepInfoItem = prepInfoItemIterator.next();
                if (object != null && ActivityAnalyzer.update(this.compositeState.getActivityType()) && !((GeneratedKeys)object).addColumnProperties(prepInfoItem.getColumnName(), n++)) continue;
                ColumnProperties columnProperties = new ColumnProperties();
                columnProperties.initWithPrepInfoItem(prepInfoItem, this.compositeState.getController().getSession().getSessionJavaCharSet());
                teraResultSetMetaData.addColumnProperties(columnProperties);
            }
            if (object != null && ActivityAnalyzer.update(this.compositeState.getActivityType())) {
                ((GeneratedKeys)object).verifyColumns(prepInfoItemIterator.count());
            }
        }
        parcel = this.compositeState.getNextParcel();
        switch (parcel.getFlavor()) {
            case 71: {
                object = (DataInfoParcel)parcel;
                tDParcelState = new ReceiveDataInfoSubState(this.compositeState, (DataInfoParcel)parcel);
                break;
            }
            case 146: {
                tDParcelState = new ReceiveDataInfoSubState(this.compositeState, (DataInfoParcel)parcel);
                break;
            }
            case 10: {
                tDParcelState = new ReceiveRecordSubState(this.compositeState, (RecordParcel)parcel);
                break;
            }
            case 11: {
                tDParcelState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                break;
            }
            default: {
                throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
            }
        }
        if (this.compositeState.preparingRequest()) {
            this.compositeState.getController().getStatement().getMetaDataList().saveMetaDataForStatement(teraResultSetMetaData, this.compositeState.getStatementNumber());
        } else {
            this.compositeState.createCurrentResultSet(teraResultSetMetaData);
        }
        return tDParcelState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }
}

