/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.TeraResultSetMetaData;
import com.teradata.jdbc.interfaces.Lob;
import com.teradata.jdbc.jdbc_4.Blob;
import com.teradata.jdbc.jdbc_4.Clob;
import com.teradata.jdbc.jdbc_4.GeneratedKeys;
import com.teradata.jdbc.jdbc_4.ResultSet;
import com.teradata.jdbc.jdbc_4.ResultSetRow;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.EndStatementParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.RecordParcel;
import com.teradata.jdbc.jdbc_4.statemachine.ActivityAnalyzer;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveContinueSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceiveEndSubState;
import com.teradata.jdbc.jdbc_4.statemachine.ReceivePauseSubState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementContinueState;
import com.teradata.jdbc.jdbc_4.statemachine.StatementReceiveState;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.ErrorAnalyzer;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import com.teradata.jdbc.jdbc_4.util.JDBCException;
import java.sql.SQLException;

public class ReceiveRecordSubState
implements TDParcelState {
    private RecordParcel currentEvent;
    private StatementReceiveState compositeState;
    private boolean continuing = false;
    private static long time = 0L;
    private TDParcelState returnSubState;
    boolean processEvents;
    protected Log log;

    public ReceiveRecordSubState(StatementReceiveState statementReceiveState, RecordParcel recordParcel) {
        this.currentEvent = recordParcel;
        this.compositeState = statementReceiveState;
        this.log = this.compositeState.getController().getSession().getLog();
    }

    public TDParcelState action() throws SQLException {
        boolean bl;
        this.processEvents = true;
        Parcel parcel = null;
        this.returnSubState = null;
        long l = System.currentTimeMillis();
        if (!this.continuing && this.currentEvent != null && !this.processRecordParcelAsMessage(this.currentEvent)) {
            this.processRecordParcel(this.currentEvent);
        }
        this.continuing = false;
        boolean bl2 = bl = this.compositeState.getPacket().nextParcelPeek() == 8;
        if (bl) {
            this.processEvents = false;
            this.compositeState.getController().setPacketDispose(true);
            this.returnSubState = new ReceiveEndSubState(this.compositeState, null);
        }
        block6: while (this.processEvents) {
            parcel = this.compositeState.getNextParcel();
            if (parcel != null) {
                switch (parcel.getFlavor()) {
                    case 10: 
                    case 144: {
                        if (this.processRecordParcelAsMessage((RecordParcel)parcel)) continue block6;
                        this.processRecordParcel((RecordParcel)parcel);
                        continue block6;
                    }
                    case 11: {
                        boolean bl3;
                        boolean bl4 = this.compositeState.getController().usePositioning();
                        boolean bl5 = this.compositeState.getPacket().nextParcelPeek() == 8;
                        boolean bl6 = bl3 = this.compositeState.getPacket().nextParcelPeek() == 12;
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveRecordSubState.action got PCLENDSTATEMENT, usePositioning=" + bl4 + ", bAnotherBundleComing=" + bl5 + ", bGotEndRequest=" + bl3 + ", this=" + this);
                        }
                        if (bl3) {
                            this.compositeState.getController().getStatement().getResults().markRequestAsComplete();
                        }
                        if (this.compositeState.getCurrentResultSet() != null) {
                            this.compositeState.getCurrentResultSet().lastRowFetched();
                        }
                        if (bl4 && !bl5 && this.compositeState.getCurrentResultSet() != null && !ActivityAnalyzer.outParamResultSet(this.compositeState.getActivityType())) {
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("ReceiveRecordSubState.action calling setAdditionalProcessing, this=" + this);
                            }
                            this.setAdditionalProcessing();
                            continue block6;
                        }
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("ReceiveRecordSubState.action NOT calling setAdditionalProcessing, this=" + this);
                        }
                        this.processEvents = false;
                        this.compositeState.getController().setPacketDispose(true);
                        this.returnSubState = new ReceiveEndSubState(this.compositeState, (EndStatementParcel)parcel);
                        continue block6;
                    }
                    case 49: {
                        this.log.error("Error Parcel: " + ((ErrorParcel)parcel).getMsg());
                        continue block6;
                    }
                    case 145: {
                        continue block6;
                    }
                }
                this.log.debug("unexpected parcel: " + parcel.getFlavor());
                throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.action reached end-of-packet, calling setAdditionalProcessing, this=" + this);
            }
            this.setAdditionalProcessing();
        }
        return this.returnSubState;
    }

    public TDParcelState action(Parcel parcel) throws JDBCException {
        return null;
    }

    private void processRecordParcel(RecordParcel recordParcel) throws JDBCException {
        ResultSetRow resultSetRow = new ResultSetRow();
        RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
        GeneratedKeys generatedKeys = this.compositeState.getController().getStatement().getGeneratedKeys();
        int n = 1;
        while (recordParcelColumnValuesIterator.hasNext()) {
            if (generatedKeys == null || !ActivityAnalyzer.update(this.compositeState.getActivityType()) || generatedKeys.addColumn(n++)) {
                resultSetRow.addValue(recordParcelColumnValuesIterator.next());
                continue;
            }
            recordParcelColumnValuesIterator.next();
        }
        ResultSet resultSet = this.compositeState.getCurrentResultSet();
        if (resultSet != null) {
            this.processResultSetRow(resultSet, resultSetRow);
            resultSet.addResultSetRow(resultSetRow);
        }
    }

    private void processResultSetRow(ResultSet resultSet, ResultSetRow resultSetRow) throws JDBCException {
        TeraResultSetMetaData teraResultSetMetaData = resultSet.getMetaData();
        int n = teraResultSetMetaData.getColumnCount();
        for (int i = 1; i <= n; ++i) {
            Lob lob;
            int n2 = teraResultSetMetaData.getColumnType(i);
            if (n2 == 2004 && resultSetRow.getValue(i - 1) instanceof Blob) {
                lob = (Blob)resultSetRow.getValue(i - 1);
                if (lob == null) continue;
                ((Blob)lob).setTDSession(resultSet.getLobSession());
                continue;
            }
            if (n2 != 2005 || !(resultSetRow.getValue(i - 1) instanceof Clob) || (lob = (Clob)resultSetRow.getValue(i - 1)) == null) continue;
            ((Clob)lob).setTDSession(resultSet.getLobSession());
        }
    }

    private boolean processRecordParcelAsMessage(RecordParcel recordParcel) {
        short s = this.compositeState.getWarningCode();
        boolean bl = ErrorAnalyzer.warningIsReallyError(s);
        if (!bl && !ActivityAnalyzer.messagesResultSet(this.compositeState.getActivityType())) {
            return false;
        }
        RecordParcel.RecordParcelColumnValuesIterator recordParcelColumnValuesIterator = recordParcel.getRecordParcelColumnValuesIterator();
        while (recordParcelColumnValuesIterator.hasNext()) {
            String string = String.valueOf(recordParcelColumnValuesIterator.next());
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.processRecordParcelAsMessage: " + (bl ? "Error" : "Warning") + " " + s + " [" + string + "] this=" + this);
            }
            if (bl) {
                this.compositeState.addException(ErrorFactory.makeDatabaseSQLException(string, s));
                continue;
            }
            this.compositeState.addWarning(ErrorFactory.makeDatabaseSQLWarning(string, s));
        }
        return true;
    }

    public void setCurrentEvent(RecordParcel recordParcel) {
        this.currentEvent = recordParcel;
    }

    private void setAdditionalProcessing() {
        this.processEvents = false;
        this.continuing = true;
        if (this.compositeState.getCurrentResultSet() != null && !this.compositeState.getController().getStatement().returnGeneratedKeys()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.setAdditionalProcessing setting up pause, this=" + this);
            }
            this.returnSubState = new ReceivePauseSubState(this.compositeState, this, new StatementContinueState(this.compositeState.getController(), this.compositeState));
            this.compositeState.setPacketInUse(false);
            this.compositeState.savePrepInfo();
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug("ReceiveRecordSubState.setAdditionalProcessing reading continuously, this=" + this);
            }
            this.returnSubState = new ReceiveContinueSubState(this.compositeState, this);
            this.compositeState.savePrepInfo();
        }
    }

    public String toString() {
        return super.toString() + "(compstate=" + this.compositeState + ")";
    }
}

