/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc_4.statemachine;

import com.teradata.jdbc.jdbc_4.io.TDNetworkIOIF;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.statemachine.StatementController;
import com.teradata.jdbc.jdbc_4.statemachine.TDParcelState;
import com.teradata.jdbc.jdbc_4.util.JDBCException;

public abstract class SendState
implements TDParcelState {
    protected TDPacket packet;
    protected StatementController controller;
    protected Log log;

    public SendState(StatementController statementController) {
        this.controller = statementController;
        this.log = statementController.getSession().getLog();
    }

    protected void initPacket() throws JDBCException {
        this.packet = this.controller.getPacket();
        this.packet.setInitParcelPosition();
        this.packet.setHostCharSet(this.controller.getSession().getTdSessionCharSetCode());
        this.packet.setSessionNumber(this.controller.getSession().getSessionNum());
        this.packet.setAuthentication(this.controller.getSession().getAuthenticationNonce());
    }

    protected void initPacket(int n) throws JDBCException {
        this.packet = this.controller.getPacket(n);
        this.packet.setInitParcelPosition();
        this.packet.setHostCharSet(this.controller.getSession().getTdSessionCharSetCode());
        this.packet.setSessionNumber(this.controller.getSession().getSessionNum());
        this.packet.setAuthentication(this.controller.getSession().getAuthenticationNonce());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendPacket() throws JDBCException {
        TDNetworkIOIF tDNetworkIOIF = null;
        if (this.controller.getSession().getEncryptData() && this.controller.getSession().getAuthMethod() != null) {
            this.packet.setEncrypted();
        }
        this.packet.toStream();
        this.log.debug(this.packet.getBuffer());
        this.log.debug("lanheader request no: " + this.packet.getRequestNumber());
        tDNetworkIOIF = this.controller.getNetworkIO();
        tDNetworkIOIF.acquireWriteLock();
        try {
            this.packet.getBuffer().writeStream(tDNetworkIOIF, this.controller.getSession().getTeraEncrypt(), this.controller.getStatement().isFinalized());
        }
        finally {
            tDNetworkIOIF.releaseWriteLock();
        }
    }
}

